/*
 * NodeListModel.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * ListModel for nodes (used together with MultiSelectionList)
 */

package vstrade.shared;

//Java
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;

//VSTrade
import vstrade.data.Node;

public class NodeListModel extends AbstractListModel {
	
	Vector<Node> nodes = new Vector<Node>();
	/** Creates a new instance of ItemListModel */
	public NodeListModel() {
	}
	public void add(Node node) {
		if (!nodes.contains(node)){
			nodes.add(node);
			Collections.sort(nodes, new NodeComparator());
			fireIntervalAdded(this, nodes.indexOf(node), nodes.indexOf(node));
		}
	}
	public void clear(){
		if (!nodes.isEmpty()){
			int index = nodes.size() - 1;
			nodes.clear();
			fireIntervalRemoved(this, 0, index);
		}
	}
	public void remove(int index){
		if (index >= 0 && index < nodes.size()){
			nodes.remove(index);
			fireIntervalRemoved(this, index, index);
		}
	}
	public Vector<Node> getItems(){
		return new Vector<Node>(nodes);
	}
	public int size() {
		return nodes.size();
	}
	public boolean isEmpty(){
		return nodes.isEmpty();
	}
	public boolean contains(Node node){
		return nodes.contains(node);
	}
	public int indexOf(Node node){
		return nodes.indexOf(node);
	}
	
	@Override
	public int getSize() {
		return nodes.size();
	}
	
	@Override
	public Object getElementAt(int index) {
		return nodes.get(index);
	}
	public Node get(int index) {
		if (index > nodes.size()-1) return null;
		return nodes.get(index);
	}
	public Vector<Node> getSelectedNodes(JList jList){
		if (jList.getModel().equals(this)){
			int[] indices = jList.getSelectedIndices();
			Vector<Node> nodeVector = new Vector<Node>(indices.length);
			for (int a = 0; a < indices.length; a++){
				Node node = nodes.get(indices[a]);
				nodeVector.add(node);
			}
			return nodeVector;
		} else {
			return null;
		}
		
	}
	
}
