/*
 * KeyActionTimer.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Map of the galaxy (GalaxyView). Controls to select systems and show/hide different things on the map. 
 */


package vstrade.shared;

//Java
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;


public class KeyActionTimer implements ActionListener{
	private final String ACTION_START = "Start";
	private final String ACTION_END = "End";
	
	private Timer timer;
	private ActionListener actionListener;
	private String actionCommand;
	private JComponent jComponent;
	private int keyCode;
	private String start;
	private String end;
	
	
	/**
	 * Creates a new instance of KeyActionTimer
	 */
	public KeyActionTimer(ActionListener actionListener, String actionCommand, JComponent jComponent, int keyCode) {
		this.actionCommand = actionCommand;
		this.actionListener = actionListener;
		this.jComponent = jComponent;
		this.keyCode = keyCode;
		
		start = actionCommand+ACTION_START;
		end = actionCommand+ACTION_END;
		
		jComponent.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(keyCode, 0),start);
		jComponent.getActionMap().put(start, new KeyAction(this, start));
		
		jComponent.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(keyCode, 0, true), end);
		jComponent.getActionMap().put(end, new KeyAction(this, end));
		
		timer = new Timer(10, this);
		timer.setActionCommand(actionCommand);
		timer.setInitialDelay( 0 );
	
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		if (start.equals(e.getActionCommand())) {
			jComponent.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).remove(KeyStroke.getKeyStroke(keyCode, 0));
			timer.start();
		}
		if (end.equals(e.getActionCommand())) {
			jComponent.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT).put(KeyStroke.getKeyStroke(keyCode, 0), start);
			timer.stop();
		}
		if (actionCommand.equals(e.getActionCommand())) {
			actionListener.actionPerformed(e);
		}
	}
}
