/*
 * DoubleKeyListener.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * KeyListener that only allows double value (all other keys are consumed)
 */

package vstrade.shared;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class DoubleKeyListener implements KeyListener {
	
	/** Creates a new instance of DoubleKeyListener */
	public DoubleKeyListener() {
	}
	
	@Override
	public void keyTyped(KeyEvent e) {
		if (Character.isLetter(  e.getKeyChar() ) || (!Character.isLetterOrDigit(e.getKeyChar()) && ! String.valueOf(e.getKeyChar()).equals(".")) ){
			e.consume();
		}
		
	}
	
	@Override
	public void keyPressed(KeyEvent e) {}
	
	@Override
	public void keyReleased(KeyEvent e) {}
}
