/*
 * ComboSelectionManager.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * KeySelectionManager that ignores space (Used with JComboBox)
 */

package vstrade.shared;

//Java
import javax.swing.ComboBoxModel;

public class ComboSelectionManager implements javax.swing.JComboBox.KeySelectionManager{
	
	/** Creates a new instance of ComboSelectionManager */
	public ComboSelectionManager() {
	}
	
	@Override
	public int selectionForKey(char aKey, ComboBoxModel aModel) {
		int i,c;
		int currentSelection = -1;
		Object selectedItem = aModel.getSelectedItem();
		String v;
		String pattern;

		if ( selectedItem != null ) {
			for ( i=0,c=aModel.getSize();i<c;i++ ) {
				if ( selectedItem == aModel.getElementAt(i) ) {
					currentSelection  =  i;
					break;
				}
			}
		}

		pattern = ("" + aKey).toLowerCase();
		aKey = pattern.charAt(0);

		for ( i = ++currentSelection, c = aModel.getSize() ; i < c ; i++ ) {
			Object elem = aModel.getElementAt(i);
			if (elem != null && elem.toString() != null) {
				v = elem.toString().toLowerCase().trim();
				if ( v.length() > 0 && v.charAt(0) == aKey )
				return i;
			}
		}

		for ( i = 0 ; i < currentSelection ; i ++ ) {
			Object elem = aModel.getElementAt(i);
			if (elem != null && elem.toString() != null) {
				v = elem.toString().toLowerCase().trim();
				if ( v.length() > 0 && v.charAt(0) == aKey )
				return i;
			}
		}
		return -1;
	}
}
