/*
 * TradeView.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * The Trade Panel. Find profitable commerce to trade between bases/planets
 */

package vstrade.moduls.trade;

//Java
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

//Glazed Lists
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.shared.GUIFactory;
import vstrade.shared.NodeListModel;
import vstrade.shared.MultiSelectionList;
import vstrade.shared.ModuleView;
import vstrade.shared.IntegerKeyListener;

public class TradeView extends ModuleView implements ActionListener, MouseListener, KeyListener {
	private final String ACTION_SEARCH = "FindBaseToBase";
	private final String ACTION_CLEAR = "ClearBasesTable";
	private final String ACTION_BUY_TYPE = "basesFromType"; 
	private final String ACTION_BUY_ADD = "AddBuyBase";
	private final String ACTION_SELL_TYPE = "basesToType";
	private final String ACTION_SELL_ADD = "AddSellBase";
	private final String ACTION_SYNC = "SyncBases";
	private final String ACTION_BUY_ADD_SELECTED = "AddSelectedToSellBase";
	private final String ACTION_BUY_ADD_ALL = "AddAllToSellBase";
	private final String ACTION_BUY_CLEAR_LIST = "ClearBuyList";
	private final String ACTION_SELL_ADD_SELECTED = "AddSelectedToBuyBase";
	private final String ACTION_SELL_ADD_ALL = "AddAllToBuyBase";
	private final String ACTION_SELL_CLEAR_LIST = "ClearSellList";
	private final String ACTION_BUY_SELECT_ALL = "SelectBuyList";
 	private final String ACTION_BUY_DESELECT_ALL = "DeselectBuyList";
 	private final String ACTION_SELL_SELECT_ALL = "SelectSellList";
 	private final String ACTION_SELL_DESELECT_ALL = "DeselectSellList";
	
//BuyBases
	//Buttons
	private JButton jBuyAddSelected;
	private JButton jBuyAddAll;
	private JButton jBuyClear;
	private JCheckBox jBuySync;
	private JPanel jBuyTPanel;	
	//List
	private MultiSelectionList jBuyBases;
	private NodeListModel jBuyBasesModel;
	//Select
	private JButton jBuySelectAll;
	private JButton jBuyDeselectAll;
	//Add
	private JComboBox jBuyType;
	private JComboBox jBuyAdd;
	private JButton jBuyAddButton;
//Sell Bases
	//Buttons
	private JButton jSellAddSelected;
	private JButton jSellAddAll;
	private JButton jSellClear;
	private JPanel jSellTPanel;
	//List
	private MultiSelectionList jSellBases;
	private NodeListModel jSellBasesModel;
 	//Select
 	private JButton jSellSelectAll;
 	private JButton jSellDeselectAll;
	//Add
	private JComboBox jSellType;
	private JComboBox jSellAdd;
	private JButton jSellAddButton;
//Minimums
	private JTextField jPercentProfit;
	private JPanel jPercentProfitTPanel;
	private JTextField jCashProfit;
	private JPanel jCashProfitTPanel;
//Switches
	private JCheckBox jRisk;
	private JLabel jRiskLabel;
	private JLabel jBestTradeLabel;
	private JRadioButton jBestTrade;
	private JLabel jNormalSearchLabel;
	private JRadioButton jNormalSearch;
	private JLabel jBestCargoTradeLabel;
 	private JRadioButton jBestCargoTrade;
	private JPanel jSwitchTPanel;
	
//Buttons
	private JButton jClear;
	private JButton jSearch;
	private JPanel jSearchTPanel;
//Table
	private JTable jTable;
	private TradeTableFormat tradeTableFormat;
	private EventTableModel<TradeTableRow> tradeTableModel;
	private EventList<TradeTableRow> tradeEventList;
	private SortedList<TradeTableRow> tradeSortedList;
	//Table PopupMenu
	TradeTablePopupMenu jTradeTablePopupMenu;
	
	private IntegerKeyListener textListener;
	
	//Data
	private String sAlt;
	
	//Params
	private Program program;
	
	public TradeView(Program program) {
		this.program = program;

		textListener = new IntegerKeyListener();

		jTradeTablePopupMenu = new TradeTablePopupMenu(program, this);

//Buy Base
		//Buttons
		jBuySelectAll = GUIFactory.jButtonSmall(this, ACTION_BUY_SELECT_ALL);
 		jBuyDeselectAll = GUIFactory.jButtonSmall(this, ACTION_BUY_DESELECT_ALL);
		jBuyAddSelected = GUIFactory.jButtonSmall(this, ACTION_BUY_ADD_SELECTED);
		jBuyAddAll = GUIFactory.jButtonSmall(this, ACTION_BUY_ADD_ALL);
		jBuyClear = GUIFactory.jButtonSmall(this, ACTION_BUY_CLEAR_LIST);
		jBuySync = GUIFactory.jCheckBox(this, ACTION_SYNC);
		JPanel jBuyButtonPanel = GUIFactory.jPButton(jBuySelectAll, jBuyDeselectAll, jBuyAddSelected, jBuyAddAll, jBuyClear, jBuySync);
		//JPanel jBuyButtonPanel = GUIFactory.jPButton(jBuySelectAll, jBuyDeselectAll, jBuyAddSelected, jBuyAddAll, jBuyClear);
		
		//List
		jBuyBasesModel = new NodeListModel();
		jBuyBases = GUIFactory.jMultiSelectionList(jBuyBasesModel, this, this);
		
 		//Select
 		
 		//JPanel jBuySelectPanel = GUIFactory.jPButton(jBuySelectAll, jBuyDeselectAll);

		//Add
		jBuyType = GUIFactory.jComboBox(this, ACTION_BUY_TYPE); 
		jBuyAdd = GUIFactory.jComboBoxSmall(null, "", this);
		jBuyAddButton =  GUIFactory.jButtonSmall(this, ACTION_BUY_ADD);
		JPanel jBuyAddPanel = GUIFactory.jPButton(jBuyAdd, jBuyAddButton);
		
		//Panel
		jBuyTPanel = GUIFactory.jPTitle(GUIFactory.PAGE_AXIS, jBuyButtonPanel, GUIFactory.jScrollPanel(jBuyBases, 4), jBuyType, jBuyAddPanel);

	//Sell Base
		//Buttons
		jSellSelectAll = GUIFactory.jButtonSmall(this, ACTION_SELL_SELECT_ALL);
 		jSellDeselectAll = GUIFactory.jButtonSmall(this, ACTION_SELL_DESELECT_ALL);
		jSellAddSelected = GUIFactory.jButtonSmall(this, ACTION_SELL_ADD_SELECTED);
		jSellAddAll = GUIFactory.jButtonSmall(this, ACTION_SELL_ADD_ALL);
		jSellClear = GUIFactory.jButtonSmall(this, ACTION_SELL_CLEAR_LIST);
		JPanel jSellButtonPanel = GUIFactory.jPButton(jSellSelectAll, jSellDeselectAll, jSellAddSelected, jSellAddAll, jSellClear);
		
		//List
		jSellBasesModel = new NodeListModel();
		jSellBases = GUIFactory.jMultiSelectionList(jSellBasesModel, this, this);
	
		//Add
		jSellType = GUIFactory.jComboBox(this, ACTION_SELL_TYPE);
		jSellAdd = GUIFactory.jComboBoxSmall(null, ACTION_SELL_ADD, this);
		jSellAddButton =  GUIFactory.jButtonSmall(this, ACTION_SELL_ADD);
		JPanel jSellAddPanel = GUIFactory.jPButton(jSellAdd, jSellAddButton);
		
		//Panel
		jSellTPanel = GUIFactory.jPTitle(GUIFactory.PAGE_AXIS, jSellButtonPanel, GUIFactory.jScrollPanel(jSellBases, 4), jSellType, jSellAddPanel);
		
		//Buy Sell Panel
		JPanel jbasesRPanel = GUIFactory.jPRow(jBuyTPanel, jSellTPanel);

		//Risk
		
		jRiskLabel = GUIFactory.jLabel(this);
		jRisk = GUIFactory.jCheckBox();
		
		jNormalSearchLabel = GUIFactory.jLabel(this);
		jNormalSearch = GUIFactory.jRadioButton();
		jNormalSearch.setSelected(true);
		//jNormalSearchLabel.setText("Normal");
		
		jBestTradeLabel = GUIFactory.jLabel(this);
		jBestTrade = GUIFactory.jRadioButton();
 		jBestCargoTradeLabel = GUIFactory.jLabel(this);
 		//jBestCargoTrade = GUIFactory.jRadioButton(this, ACTION_BEST_CARGO_TRADE);
		jBestCargoTrade = GUIFactory.jRadioButton();
		
		ButtonGroup group = new ButtonGroup();
		group.add(jNormalSearch);
		group.add(jBestTrade);
		group.add(jBestCargoTrade);
		
		//jSwitchTPanel = GUIFactory.jPTitle(GUIFactory.PAGE_AXIS, GUIFactory.jPCheckBox(jRisk, jRiskLabel), GUIFactory.jPCheckBox(jBestTrade, jBestTradeLabel) );
 		jSwitchTPanel = GUIFactory.jPTitle(GUIFactory.PAGE_AXIS,
											GUIFactory.jPCheckBox(jRisk, jRiskLabel),
											GUIFactory.jPRadioButton(jNormalSearch, jNormalSearchLabel),
											GUIFactory.jPRadioButton(jBestTrade, jBestTradeLabel),
											GUIFactory.jPRadioButton(jBestCargoTrade, jBestCargoTradeLabel)
										);
	//Minimum Revenue	
		jPercentProfit = GUIFactory.jTextField(textListener);
		jPercentProfitTPanel = GUIFactory.jPTitle(jPercentProfit);

		jCashProfit = GUIFactory.jTextField(textListener);
		jCashProfitTPanel = GUIFactory.jPTitle(jCashProfit);
//Search
		jClear = GUIFactory.jButton(this, ACTION_CLEAR);
		jSearch = GUIFactory.jButton(this, ACTION_SEARCH);
		JPanel jSearchBPanel = GUIFactory.jPButton(jClear, jSearch);
		jSearchTPanel = GUIFactory.jPTitle(GUIFactory.LINE_AXIS, jSearchBPanel);
		JPanel jSearchCPanel = GUIFactory.jPColumn(jPercentProfitTPanel, jCashProfitTPanel, jSearchTPanel);

		JPanel jActionRPanel = GUIFactory.jPRow(jSwitchTPanel, jSearchCPanel);
		

//Table	
		tradeEventList = new BasicEventList<TradeTableRow>();
		tradeSortedList = new SortedList<TradeTableRow>(tradeEventList);
		tradeTableFormat = new TradeTableFormat(program);
		tradeTableModel = new EventTableModel<TradeTableRow>(tradeSortedList, tradeTableFormat);
		jTable = new TradeTable(tradeTableModel, tradeSortedList);
		jTable.addMouseListener(this);
		jTable.addMouseListener(program);
		TableComparatorChooser<TradeTableRow> tableSorter = new TableComparatorChooser<TradeTableRow>(jTable, tradeSortedList, true);
		
		JScrollPane jTableSPanel = new JScrollPane(jTable);
		jTableSPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5,0,0,0), BorderFactory.createEtchedBorder(EtchedBorder.LOWERED)) );

//Input Panel
		JPanel jInputPanel = new JPanel();
		jInputPanel.setBorder( BorderFactory.createEmptyBorder(0,0,5,0));
		jInputPanel.setLayout( new BoxLayout(jInputPanel, BoxLayout.PAGE_AXIS) ); 
		jInputPanel.add( jbasesRPanel );
		//jInputPanel.add( jMinimumRPanel );
		jInputPanel.add( jActionRPanel  );

//Main Panel
		JSplitPane jPanel = new JSplitPane(JSplitPane.VERTICAL_SPLIT, jInputPanel, jTableSPanel);
		jPanel.setBorder(null);
		jPanel.setOneTouchExpandable(true);
		jPanel.setEnabled(false);
		jPanel.setDividerSize(10);

		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.add(jPanel);
	}
	
	@Override
	public void setData() {
		updateLanguage();
		boolean bEnabled = program.getBases().isLoaded();
		if (bEnabled){
			jBuyType.setModel( new DefaultComboBoxModel(getTypeList()));
			jBuyAdd.setModel( new DefaultComboBoxModel(getBaseList()));
			jSellType.setModel( new DefaultComboBoxModel(getTypeList()));
			jSellAdd.setModel( new DefaultComboBoxModel(getBaseList()));
		}
		//Enable-Disable Components
	//Buy Base
		//Buttons
		jBuySync.setEnabled(bEnabled);
		jBuyAddSelected.setEnabled(bEnabled);
		jBuyAddAll.setEnabled(bEnabled);
		jBuyClear.setEnabled(bEnabled);
		//List
		jBuyBases.setEnabled(bEnabled);
		//Select
 		jBuySelectAll.setEnabled(bEnabled);
 		jBuyDeselectAll.setEnabled(bEnabled);
		//Add
		jBuyType.setEnabled(bEnabled);
		jBuyAdd.setEnabled(bEnabled);
		jBuyAddButton.setEnabled(bEnabled);
	//Sell Base
		//Buttons
		jSellAddSelected.setEnabled(bEnabled);
		jSellAddAll.setEnabled(bEnabled);
		jSellClear.setEnabled(bEnabled);
		//List
		jSellBases.setEnabled(bEnabled);
		//Select
 		jSellSelectAll.setEnabled(bEnabled);
 		jSellDeselectAll.setEnabled(bEnabled);
		//Clear list
		jSellBasesModel.clear();
		//Add
		jSellAddButton.setEnabled(bEnabled);
		jSellType.setEnabled(bEnabled);
		jSellAdd.setEnabled(bEnabled);
	//Minimums
		jCashProfit.setEnabled(bEnabled);
		jPercentProfit.setEnabled(bEnabled);
	//Switchers
		jRisk.setEnabled(bEnabled);
		jRiskLabel.setEnabled(bEnabled);
		jNormalSearchLabel.setEnabled(bEnabled);
		jNormalSearch.setEnabled(bEnabled);
		jBestTradeLabel.setEnabled(bEnabled);
		jBestTrade.setEnabled(bEnabled);
		jBestCargoTradeLabel.setEnabled(bEnabled);
 		jBestCargoTrade.setEnabled(bEnabled);
	//Search
		jSearch.setEnabled(bEnabled);
		jClear.setEnabled(bEnabled);
	}
	
	@Override
	public void clearData() {
		String[] arrBases = {program.getSettings().getLanguageSettings().getString("NoBases", "trade")};
		String[] arrTypes = {program.getSettings().getLanguageSettings().getString("NoTypes", "trade")};
	//Buy Base
		//Clear ComboBoxes
		jBuyType.setModel( new DefaultComboBoxModel(arrTypes));
		jBuyAdd.setModel( new DefaultComboBoxModel(arrBases));
		//Clear list
		jBuyBasesModel.clear();
	//Sell Base
		//Clear ComboBoxes
		jSellType.setModel( new DefaultComboBoxModel(arrTypes));
		jSellAdd.setModel( new DefaultComboBoxModel(arrBases));
		//Clear list
		jSellBasesModel.clear();
	//Table
		//Clear table results
		tradeEventList.getReadWriteLock().writeLock().lock();
		tradeEventList.clear(); //Remove current rows
		tradeEventList.getReadWriteLock().writeLock().unlock();
		program.getStatusView().setTradeResults("-");		
	}
	
	@Override
	public void updateLanguage(){
		sAlt = program.getSettings().getLanguageSettings().getString("All", "trade");
		sTitle = program.getSettings().getLanguageSettings().getString("Title", "trade");
	//Buy Base
		//Buttons
		jBuyAddSelected.setText("");
		jBuyAddSelected.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyAddSelectedTT", "trade"));
		jBuyAddAll.setText("");
		jBuyAddAll.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyAddAllTT", "trade"));
		jBuyClear.setText("!");//
		jBuyClear.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyClearListTT", "trade"));
		jBuySync.setToolTipText(program.getSettings().getLanguageSettings().getString("SyncLists", "trade"));
			//Select
 		//jBuySelectAll.setText(program.getSettings().getLanguageSettings().getString("BuySelectAll", "trade"));
		jBuySelectAll.setText("+");
 		jBuySelectAll.setToolTipText(program.getSettings().getLanguageSettings().getString("BuySelectAllTT", "trade"));
 		//jBuyDeselectAll.setText(program.getSettings().getLanguageSettings().getString("BuyDeselectAll", "trade"));
		jBuyDeselectAll.setText("-");
 		jBuyDeselectAll.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyDeselectAllTT", "trade"));
		//List
		jBuyBases.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyBasesTT", "trade"));
		
		//Add
		jBuyType.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyTypeTT", "trade"));
		jBuyAdd.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyAddTT", "trade"));
		jBuyAddButton.setText(program.getSettings().getLanguageSettings().getString("BuyAddButton", "trade"));
		jBuyAddButton.setToolTipText(program.getSettings().getLanguageSettings().getString("BuyAddButtonTT", "trade"));
		//Title Panel
		GUIFactory.setBorderTitle(jBuyTPanel, program.getSettings().getLanguageSettings().getString("BuyBase", "trade"));
	//Sell Base
		//Buttons
			//Select
 		//jSellSelectAll.setText(program.getSettings().getLanguageSettings().getString("SellSelectAll", "trade"));
		jSellSelectAll.setText("+");
 		jSellSelectAll.setToolTipText(program.getSettings().getLanguageSettings().getString("SellSelectAllTT", "trade"));
 		//jSellDeselectAll.setText(program.getSettings().getLanguageSettings().getString("SellDeselectAll", "trade"));
		jSellDeselectAll.setText("-");
 		jSellDeselectAll.setToolTipText(program.getSettings().getLanguageSettings().getString("SellDeselectAllTT", "trade"));
		jSellAddSelected.setText("");
		jSellAddSelected.setToolTipText(program.getSettings().getLanguageSettings().getString("SellAddSelectedTT", "trade"));
		jSellAddAll.setText("");
		jSellAddAll.setToolTipText(program.getSettings().getLanguageSettings().getString("SellAddAllTT", "trade"));
		jSellClear.setText("!");//
		jSellClear.setToolTipText(program.getSettings().getLanguageSettings().getString("SellClearListTT", "trade"));
		
		//List
		jSellBases.setToolTipText(program.getSettings().getLanguageSettings().getString("SellBasesTT", "trade"));
		
		//Add
		jSellType.setToolTipText(program.getSettings().getLanguageSettings().getString("SellTypeTT", "trade"));
		jSellAdd.setToolTipText(program.getSettings().getLanguageSettings().getString("SellAddTT", "trade"));
		jSellAddButton.setText(program.getSettings().getLanguageSettings().getString("SellAddButton", "trade"));
		jSellAddButton.setToolTipText(program.getSettings().getLanguageSettings().getString("SellAddButtonTT", "trade"));
		//Panel
		GUIFactory.setBorderTitle(jSellTPanel, program.getSettings().getLanguageSettings().getString("SellBase", "trade"));
	//Minimums
		jPercentProfit.setToolTipText(program.getSettings().getLanguageSettings().getString("MinPercentProfitTT", "trade"));
		GUIFactory.setBorderTitle(jPercentProfitTPanel, program.getSettings().getLanguageSettings().getString("MinPercentProfit", "trade"));
		jCashProfit.setToolTipText(program.getSettings().getLanguageSettings().getString("MinCashProfitTT", "trade"));
		GUIFactory.setBorderTitle(jCashProfitTPanel, program.getSettings().getLanguageSettings().getString("MinCashProfit", "trade"));
	//Switchers
		jRiskLabel.setText(program.getSettings().getLanguageSettings().getString("RiskTaker", "trade"));
		jRiskLabel.setToolTipText(program.getSettings().getLanguageSettings().getString("RiskTakerTT", "trade"));
		jRisk.setToolTipText(program.getSettings().getLanguageSettings().getString("RiskTakerTT", "trade"));
		jNormalSearchLabel.setText(program.getSettings().getLanguageSettings().getString("NormalSearch", "trade"));
		jNormalSearchLabel.setToolTipText(program.getSettings().getLanguageSettings().getString("NormalSearchTT", "trade"));
		jNormalSearch.setToolTipText(program.getSettings().getLanguageSettings().getString("NormalSearchTT", "trade"));
		jBestTradeLabel.setText(program.getSettings().getLanguageSettings().getString("BestTrade", "trade"));
		jBestTradeLabel.setToolTipText(program.getSettings().getLanguageSettings().getString("BestTradeTT", "trade"));
		jBestTrade.setToolTipText(program.getSettings().getLanguageSettings().getString("BestTradeTT", "trade"));
		jBestCargoTradeLabel.setText(program.getSettings().getLanguageSettings().getString("BestCargoTrade", "trade"));
		jBestCargoTradeLabel.setToolTipText(program.getSettings().getLanguageSettings().getString("BestCargoTradeTT", "trade"));
 		jBestCargoTrade.setToolTipText(program.getSettings().getLanguageSettings().getString("BestCargoTradeTT", "trade"));
		GUIFactory.setBorderTitle(jSwitchTPanel, program.getSettings().getLanguageSettings().getString("Switches", "trade"));
	//Search
		jClear.setText(program.getSettings().getLanguageSettings().getString("Clear", "trade"));
		jClear.setToolTipText(program.getSettings().getLanguageSettings().getString("ClearTT", "trade"));
		jSearch.setText(program.getSettings().getLanguageSettings().getString("Search", "trade"));
		jSearch.setToolTipText(program.getSettings().getLanguageSettings().getString("SearchTT", "trade"));
		GUIFactory.setBorderTitle(jSearchTPanel, program.getSettings().getLanguageSettings().getString("Search", "trade"));
	//PopUpMenu
		jTradeTablePopupMenu.updateLanguage();
	//Table
		tradeTableModel.fireTableStructureChanged();
	}
	public void selectAllBuy(){
 		if (!jBuyBasesModel.isEmpty()){
 			int[] indices = new int[jBuyBasesModel.size()];
 			for (int index = 0; index < indices.length; ++index) {
 				indices[index] = index;
 			}
 			jBuyBases.setSelectedIndices(indices);
 		}
 	}
 	public void deselectAllBuy(){
 		if (!jBuyBasesModel.isEmpty()){
 			jBuyBases.clearSelection();
 		}
 	}
 	public void selectAllSell(){
 		if (!jSellBasesModel.isEmpty()){
 			int[] indices = new int[jSellBasesModel.size()];
 			for (int index = 0; index < indices.length; ++index) {
 				indices[index] = index;
 			}
 			jSellBases.setSelectedIndices(indices);
 		}
 	}
 	public void deselectAllSell(){
 		if (!jSellBasesModel.isEmpty()){
 			jSellBases.clearSelection();
 		}
 	}
	public void addBuyBase(Base base){
		jBuyBasesModel.add(base);
		jBuyBases.addSelection(jBuyBasesModel.indexOf(base), true);
	}
	public void addSellBase(Base base){
		jSellBasesModel.add(base);
		jSellBases.addSelection(jSellBasesModel.indexOf(base), true);
	}
	public Cargo getSelectedCargo(){
		int row = jTable.getSelectedRow();
		if (row < 0) return null;
		TradeTableRow tradeTableRow = tradeTableModel.getElementAt(row);
		Cargo cargo = tradeTableRow.getCargo();
		return cargo;
	}
	public Base getSelectedBuyBase(){
		int row = jTable.getSelectedRow();
		if (row < 0) return null;
		TradeTableRow tradeTableRow = tradeTableModel.getElementAt(row);
		Base base = tradeTableRow.getBuyBase();
		return base;
	}
	public Base getSelectedSellBase(){
		int row = jTable.getSelectedRow();
		if (row < 0) return null;
		TradeTableRow tradeTableRow = tradeTableModel.getElementAt(row);
		Base base = tradeTableRow.getSellBase();
		return base;
	}
	
	@Override
	public void actionPerformed(ActionEvent e) {
		//Buy Type
		if (ACTION_BUY_TYPE.equals(e.getActionCommand())) {
			Vector<Node> basesList;
			String sType = (String) jBuyType.getSelectedItem();
			if (sType.equals(getAll())){ //If All is selected
				basesList = getBaseList();
			} else {
				basesList = getBaseList(sType);
			}
			jBuyAdd.setModel( new DefaultComboBoxModel(basesList));
		}
		//Buy Add
		if (ACTION_BUY_ADD.equals(e.getActionCommand())) {
			addBaseToList(jBuyAdd, jBuyType, jBuyBases, jBuyBasesModel);
			if (jBuySync.isSelected()) addBaseToList(jBuyAdd, jBuyType, jSellBases, jSellBasesModel);
		}
		//Add selected buy bases to sell list
		if (ACTION_BUY_ADD_SELECTED.equals(e.getActionCommand())) {
			addSelectedToList(jBuyBases, jBuyBasesModel, jSellBases, jSellBasesModel);
		}
		//Add all buy bases to sell list
		if (ACTION_BUY_ADD_ALL.equals(e.getActionCommand())) {
			addAllToList(jBuyBases, jBuyBasesModel, jSellBases, jSellBasesModel);
		}
		//Clear buy list
		if (ACTION_BUY_CLEAR_LIST.equals(e.getActionCommand())) {
			jBuyBasesModel.clear();
			if (jBuySync.isSelected()){ //If sync is active, also delete all sell bases
				jSellBasesModel.clear();
			}
		}
		//Sell Type
		if (ACTION_SELL_TYPE.equals(e.getActionCommand())) {
			Vector<Node> basesList;
			String sType = (String) jSellType.getSelectedItem(); //Get Selected Type
			if (sType.equals(getAll())){ //If All is selected
				basesList = getBaseList();
			} else { 
				basesList = getBaseList(sType); //
			}
			jSellAdd.setModel( new DefaultComboBoxModel(basesList)); //Input the new data
			//jSellBase.setSelectedIndex(0);
		}
		//Sell Add
		if (ACTION_SELL_ADD.equals(e.getActionCommand())) {
			if (e.getModifiers() > 0){
				addBaseToList(jSellAdd, jSellType, jSellBases, jSellBasesModel);
			}
		}
		// Add selected sell bases to buy list
		if (ACTION_SELL_ADD_SELECTED.equals(e.getActionCommand())) {
			addSelectedToList(jSellBases, jSellBasesModel, jBuyBases, jBuyBasesModel);
		}
		//add all sell bases to buy list
		if (ACTION_SELL_ADD_ALL.equals(e.getActionCommand())) {
			addAllToList(jSellBases, jSellBasesModel, jBuyBases, jBuyBasesModel);
		}
		//clear sell list
		if (ACTION_SELL_CLEAR_LIST.equals(e.getActionCommand())) {
			jSellBasesModel.clear();
		}
		//Sync
		if (ACTION_SYNC.equals(e.getActionCommand())) {
			boolean bSynkSelected = jBuySync.isSelected();
			jSellType.setEnabled(!bSynkSelected);
			jSellAdd.setEnabled(!bSynkSelected);
			jBuyAddSelected.setEnabled(!bSynkSelected);
			jBuyAddAll.setEnabled(!bSynkSelected);
			//jBuyClear.setEnabled(!bSynkSelected);
			jSellAddSelected.setEnabled(!bSynkSelected);
			jSellAddAll.setEnabled(!bSynkSelected);
			jSellClear.setEnabled(!bSynkSelected);
			jSellAddButton.setEnabled(!bSynkSelected);
			if (bSynkSelected){
				//statusView.setStatusbarText("Trade - Lists Synchronized");
				addAllToList(jBuyBases, jBuyBasesModel, jSellBases, jSellBasesModel);
				addAllToList(jSellBases, jSellBasesModel, jBuyBases, jBuyBasesModel);
			} else {
				//statusView.setStatusbarText("Trade - Lists Desynchronized");
			}

		}
		//Select lists
 		if (ACTION_BUY_SELECT_ALL.equals(e.getActionCommand())) {
 			selectAllBuy();
 		}
 		if (ACTION_BUY_DESELECT_ALL.equals(e.getActionCommand())) {
 			deselectAllBuy();
 		}
 		if (ACTION_SELL_SELECT_ALL.equals(e.getActionCommand())) {
 			selectAllSell();
 		}
 		if (ACTION_SELL_DESELECT_ALL.equals(e.getActionCommand())) {
 			deselectAllSell();
  		}
		//Clear Table
		if (ACTION_CLEAR.equals(e.getActionCommand())) {
			tradeEventList.getReadWriteLock().writeLock().lock();
			tradeEventList.clear(); //Remove current rows
			tradeEventList.getReadWriteLock().writeLock().unlock();
			program.getStatusView().setTradeResults("-");
		}
		//Search
		if (ACTION_SEARCH.equals(e.getActionCommand())) {
			this.search();
			//statusView.setStatusbarText("Trade - Search");
		}
		//Table Popup Menu
		if (jTradeTablePopupMenu.ACTION_TRADE_ADD_BUY_TO_BUY.equals(e.getActionCommand())){
			int i = jTable.getSelectedRow();
			TradeTableRow row = tradeSortedList.get(i);
			Node node = row.getBuyBase();
			jBuyBasesModel.add(node);
			jBuyBases.addSelection(jBuyBasesModel.indexOf(node), true);
		}
		if (jTradeTablePopupMenu.ACTION_TRADE_ADD_BUY_TO_SELL.equals(e.getActionCommand())){
			int i = jTable.getSelectedRow();
			TradeTableRow row = tradeSortedList.get(i);
			Node node = row.getBuyBase();
			jSellBasesModel.add(node);
			jSellBases.addSelection(jSellBasesModel.indexOf(node), true);
		}
		if (jTradeTablePopupMenu.ACTION_TRADE_ADD_SELL_TO_SELL.equals(e.getActionCommand())){
			int i = jTable.getSelectedRow();
			TradeTableRow row = tradeSortedList.get(i);
			Node node = row.getSellBase();
			jSellBasesModel.add(node);
			jSellBases.addSelection(jSellBasesModel.indexOf(node), true);
		}
		if (jTradeTablePopupMenu.ACTION_TRADE_ADD_SELL_TO_BUY.equals(e.getActionCommand())){
			int i = jTable.getSelectedRow();
			TradeTableRow row = tradeSortedList.get(i);
			Node node = row.getSellBase();
			jBuyBasesModel.add(node);
			jBuyBases.addSelection(jBuyBasesModel.indexOf(node), true);
		}
	}
	
	@Override
	public void mouseClicked(MouseEvent e) {
		//Remove buy base - if right mouse button is click
		if (e.getSource().equals(jBuyBases) && e.getButton() == MouseEvent.BUTTON3){ 
			int index = jBuyBases.locationToIndex(e.getPoint());
			jBuyBasesModel.remove(index);
			if (jBuySync.isSelected()) jSellBasesModel.remove(index);
		}
		//Remove sell base - if right mouse button is click
		if (e.getSource().equals(jSellBases) && e.getButton() == MouseEvent.BUTTON3 && !jBuySync.isSelected()){
			jSellBasesModel.remove(jSellBases.locationToIndex(e.getPoint()));
		}
		//Switches (Select / deselect on lable click
		if (e.getSource().equals(jRiskLabel) && jRiskLabel.isEnabled()){
			jRisk.setSelected( !jRisk.isSelected());
		}
		if (e.getSource().equals(jNormalSearchLabel) && jNormalSearchLabel.isEnabled()){
			if (!jNormalSearch.isSelected()) jNormalSearch.setSelected(true);
 			//jNormalSearch.setSelected( !jNormalSearch.isSelected());
  		}
		if (e.getSource().equals(jBestTradeLabel) && jBestTradeLabel.isEnabled()){
			if (!jBestTrade.isSelected()) jBestTrade.setSelected(true);
  			//jBestTrade.setSelected( !jBestTrade.isSelected());
 		}
 		if (e.getSource().equals(jBestCargoTradeLabel) && jBestCargoTradeLabel.isEnabled()){
			if (!jBestCargoTrade.isSelected()) jBestCargoTrade.setSelected(true);
 			//jBestCargoTrade.setSelected( !jBestCargoTrade.isSelected());
  		}
		
		//Table PopupMenu
		if (e.getSource().equals(jTable)){
			if (e.getButton() == MouseEvent.BUTTON3){
				int i = jTable.rowAtPoint(e.getPoint());
				jTable.setRowSelectionInterval(i, i);
				jTradeTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
			}
		}

	}
	
	@Override
	public void mousePressed(MouseEvent e) {}
	
	@Override
	public void mouseReleased(MouseEvent e) {}
	
	@Override
	public void mouseEntered(MouseEvent e) {}
	
	@Override
	public void mouseExited(MouseEvent e) {}
	
	@Override
	public void keyTyped(KeyEvent e) {}
	
	@Override
	public void keyPressed(KeyEvent e) {
		//Add sell base - if enter or space is pressed
		if (e.getSource().equals(jSellAdd) && (e.getKeyCode() == KeyEvent.VK_ENTER || e.getKeyCode() == KeyEvent.VK_SPACE) ){
			addBaseToList(jSellAdd, jSellType, jSellBases, jSellBasesModel);
		}
		//Remove sell base - if delete is pressed
		if (e.getSource().equals(jSellBases) && e.getKeyCode() == KeyEvent.VK_DELETE){ 
			jSellBasesModel.remove(jSellBases.getAnchorSelectionIndex());
		}
		//Add buy base - if enter or space is pressed
		if (e.getSource().equals(jBuyAdd) && (e.getKeyCode() == KeyEvent.VK_ENTER || e.getKeyCode() == KeyEvent.VK_SPACE) ){
			addBaseToList(jBuyAdd, jBuyType, jBuyBases, jBuyBasesModel);
			if (jBuySync.isSelected()) addBaseToList(jBuyAdd, jBuyType, jSellBases, jSellBasesModel);

		}
		//Remove buy base - if delete is pressed
		if (e.getSource().equals(jBuyBases) && e.getKeyCode() == KeyEvent.VK_DELETE){ 
			jBuyBasesModel.remove(jBuyBases.getAnchorSelectionIndex());
			if (jBuySync.isSelected()) jSellBasesModel.remove(jBuyBases.getAnchorSelectionIndex());
		}
	}
	
	@Override
	public void keyReleased(KeyEvent e) {}
	
//Search
	private void search(){
		Integer nCashProfit;
		String sCashProfit;
		Integer nPercentProfit;
		String sPercentProfit;
		boolean bRisk;
		boolean bBestTrade;
		boolean bBestCargoTrade;
		Vector<Node> sellBases;
		Vector<Node> buyBases;
		//Initializing
		//Get selected buy base(s)
		if (jBuyBasesModel.isEmpty()) return;
		buyBases = jBuyBasesModel.getSelectedNodes(jBuyBases);

		//Get selected sell base(s)
		if (jSellBasesModel.isEmpty()) return;
		sellBases = jSellBasesModel.getSelectedNodes(jSellBases);

		//Get Risk
		bRisk = jRisk.isSelected(); 

		//Get Best Sell
		bBestTrade = jBestTrade.isSelected();

 		//Get Best Cargo
 		bBestCargoTrade = jBestCargoTrade.isSelected();
		
		//Get Percent Profit
		sPercentProfit = jPercentProfit.getText();
		try { //Convert String to Integer
			nPercentProfit = Integer.valueOf(sPercentProfit);
		} catch (NumberFormatException ex) {
			//msg.printDebug("NaN error (Attempt to convert String \"sPercentProfit@"+sPercentProfit+"\" to Integer failed)", this.getClass(), "search()", msg.WARNING);
			nPercentProfit = 0; //NaN or no text. Safe to assume zero
		}
		//Get Cash Profit
		sCashProfit = jCashProfit.getText();
		try { //Convert String to Integer
			nCashProfit = Integer.valueOf(sCashProfit);
		} catch (NumberFormatException ex) {
			//msg.printDebug("NaN error (Attempt to convert String \"sCashProfit@"+sCashProfit+"\" to Integer failed)", this.getClass(), "search()", msg.WARNING);
			nCashProfit = 0; //NaN or no text. Safe to assume zero
		}

		//Search
		//TradeSearch tradeSearch = new TradeSearch(program, jClear, jSearch, tradeEventList, buyBases, sellBases, nPercentProfit, nCashProfit, bRisk, bBestTrade);
		TradeSearch tradeSearch = new TradeSearch(program, jClear, jSearch, tradeEventList, buyBases, sellBases, nPercentProfit, nCashProfit, bRisk, bBestTrade, bBestCargoTrade);
		tradeSearch.start();
	}
	private void addBaseToList(JComboBox addCombo, JComboBox typeCombo, MultiSelectionList list, NodeListModel listModel){
		Node node;

		node = (Node) addCombo.getSelectedItem();
		if (node.getName().contains(sAlt)){
			Vector<Node> nodes;
			if (node.getName().equals(getAll())){
				nodes = getBaseList();
			} else {
				nodes = getBaseList((String)typeCombo.getSelectedItem());
			}
			for (int a = 0; a < nodes.size(); a++){
				node = nodes.get(a);
				listModel.add(node);
				list.addSelection(listModel.indexOf(node), true);
			}
		} else if (!listModel.contains(node)){
				listModel.add(node);
				list.addSelection(listModel.indexOf(node), true);
		}
	}
	private void addAllToList(MultiSelectionList fromList, NodeListModel fromListModel, MultiSelectionList toList, NodeListModel toListModel){
		Vector<Node> nodeList = fromListModel.getItems();
		Node node;
		for (int a = 0; a < nodeList.size(); a++){
			node = nodeList.get(a);
			boolean bSelected = fromList.isSelectedIndex(a);
			if (!toListModel.contains(node)){
				toListModel.add(node);
				toList.addSelection(toListModel.indexOf(node), bSelected);
			}
		}
	}
	private void addSelectedToList(MultiSelectionList fromList, NodeListModel fromListModel, MultiSelectionList toList, NodeListModel toListModel){
		Vector<Node> nodeList = fromListModel.getItems();
		Node node;
		for (int a = 0; a < nodeList.size(); a++){
			node = nodeList.get(a);
			if (!toListModel.contains(node) && fromList.isSelectedIndex(a)){
				toListModel.add(node);
				toList.addSelection(toListModel.indexOf(node), true);
			}
		}
	}
	private Vector<String> getTypeList(){
		Vector<String> typeVector = program.getBases().getTypeList();
		typeVector.add(0, getAll());
		return typeVector;
	}
	private Vector<Node> getBaseList(){
		Vector<Node> baseVector = program.getBases().getBaseList();
		baseVector.add(0, new Base(getAll(), ""));
		return baseVector;
	}
	private Vector<Node> getBaseList(String sType){
		Vector<Node> baseVector = program.getBases().getBaseList(sType);
		//baseVector.add(0, new Base(getAll(), ""));
		//baseVector.add(1, new Base(getAllType(sType), ""));
		baseVector.add(0, new Base(getAllType(sType), ""));
		return baseVector;
	}
	private String getAll(){
		return "["+sAlt+"]";
	}
	private String getAllType(String sType){
		return "["+sAlt+" "+sType+"]";
	}
}
