/*
 * TradeTablePopupMenu.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Trade table pop-up menu
 */

package vstrade.moduls.trade;

//Java
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

//VSTrade
import vstrade.Program;

public class TradeTablePopupMenu extends JPopupMenu{
	
	public final String ACTION_TRADE_ADD_BUY_TO_BUY = "TradeAddBuyToBuy";
	public final String ACTION_TRADE_ADD_BUY_TO_SELL = "TradeAddBuyToSell";
	public final String ACTION_TRADE_ADD_SELL_TO_SELL = "TradeAddSellToSell";
	public final String ACTION_TRADE_ADD_SELL_TO_BUY = "TradeAddSellToBuy";
	
	private JMenuItem jTradeBuyList;
	private JMenuItem jTradeBuyListAddBuyBase;
	private JMenuItem jTradeBuyListAddSellBase;
	private JMenuItem jTradeSellList;
	private JMenuItem jTradeSellListAddBuyBase;
	private JMenuItem jTradeSellListAddSellBase;
	private JMenuItem jPrice;
	private JMenuItem jPriceAddBuyBase;
	private JMenuItem jPriceAddSellBase;
	private JMenuItem jPriceSetCargo;
	private JMenuItem jCargo;
	private JMenuItem jCargoSetCargo;
	
	private Program program;
	
	/** Creates a new instance of TradeTablePopupMenu */
	public TradeTablePopupMenu(Program program, ActionListener tradeListener) {
		this.program = program;
		//JMenuItem menuItem;
		
		jTradeBuyList = new JMenuItem();
		jTradeBuyList.setEnabled(false);
		add(jTradeBuyList);
		jTradeBuyListAddBuyBase = new JMenuItem();
		jTradeBuyListAddBuyBase.setActionCommand(ACTION_TRADE_ADD_BUY_TO_BUY);
		jTradeBuyListAddBuyBase.addActionListener(tradeListener);
		add(jTradeBuyListAddBuyBase);
		jTradeBuyListAddSellBase = new JMenuItem();
		jTradeBuyListAddSellBase.setActionCommand(ACTION_TRADE_ADD_SELL_TO_BUY);
		jTradeBuyListAddSellBase.addActionListener(tradeListener);
		add(jTradeBuyListAddSellBase);
		//this.addSeparator();
		jTradeSellList = new JMenuItem();
		jTradeSellList.setEnabled(false);
		add(jTradeSellList);
		jTradeSellListAddBuyBase = new JMenuItem();
		jTradeSellListAddBuyBase.setActionCommand(ACTION_TRADE_ADD_BUY_TO_SELL);
		jTradeSellListAddBuyBase.addActionListener(tradeListener);
		add(jTradeSellListAddBuyBase);
		jTradeSellListAddSellBase = new JMenuItem();
		jTradeSellListAddSellBase.setActionCommand(ACTION_TRADE_ADD_SELL_TO_SELL);
		jTradeSellListAddSellBase.addActionListener(tradeListener);
		add(jTradeSellListAddSellBase);
		this.addSeparator();
		jPrice = new JMenuItem();
		jPrice.setEnabled(false);
		add(jPrice);
		jPriceAddBuyBase = new JMenuItem();
		jPriceAddBuyBase.setActionCommand(Program.ACTION_TRADE_PRICE_ADD_BUY_BASE);
		jPriceAddBuyBase.addActionListener(program);
		add(jPriceAddBuyBase);
		jPriceAddSellBase = new JMenuItem();
		jPriceAddSellBase.setActionCommand(Program.ACTION_TRADE_PRICE_ADD_SELL_BASE);
		jPriceAddSellBase.addActionListener(program);
		add(jPriceAddSellBase);
		jPriceSetCargo = new JMenuItem();
		jPriceSetCargo.setActionCommand(Program.ACTION_TRADE_PRICE_SET_CARGO);
		jPriceSetCargo.addActionListener(program);
		add(jPriceSetCargo);
		this.addSeparator();
		jCargo = new JMenuItem();
		jCargo.setEnabled(false);
		add(jCargo);
		jCargoSetCargo = new JMenuItem();
		jCargoSetCargo.setActionCommand(Program.ACTION_TRADE_CARGO_SET_CARGO);
		jCargoSetCargo.addActionListener(program);
		add(jCargoSetCargo);
	}
	public void updateLanguage() {
		jTradeBuyList.setText(program.getSettings().getLanguageSettings().getString("MenuTradeBuyList", "trade"));
		jTradeBuyListAddBuyBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddBuyBase", "trade"));
		jTradeBuyListAddSellBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddSellBase", "trade"));
		jTradeSellList.setText(program.getSettings().getLanguageSettings().getString("MenuTradeSellList", "trade"));
		jTradeSellListAddBuyBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddBuyBase", "trade"));
		jTradeSellListAddSellBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddSellBase", "trade"));
		jPrice.setText(program.getSettings().getLanguageSettings().getString("MenuPrice", "trade"));
		jPriceAddBuyBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddBuyBase", "trade"));
		jPriceAddSellBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddSellBase", "trade"));
		jPriceSetCargo.setText(program.getSettings().getLanguageSettings().getString("MenuSetCargo", "trade"));
		jCargo.setText(program.getSettings().getLanguageSettings().getString("MenuCargo", "trade"));
		jCargoSetCargo.setText(program.getSettings().getLanguageSettings().getString("MenuSetCargo", "trade"));
	}
	
}
