/*
 * BaseTable.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * JTable that paint each row that has negative cash profit gray
 */

package vstrade.moduls.trade;

//Java
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

//Glazed Lists
import ca.odell.glazedlists.SortedList;

public class TradeTable extends JTable {
	
	SortedList<TradeTableRow> tradeSortedList;
    public TradeTable(TableModel dm, SortedList<TradeTableRow> tradeSortedList) {
        setModel(dm);
		this.tradeSortedList = tradeSortedList;
    }
	
	@Override
	public Component prepareRenderer(TableCellRenderer renderer, int row, int column){
			Component c = super.prepareRenderer(renderer, row, column);
			if (!tradeSortedList.isEmpty()) {
				TradeTableRow tradeTableRow = tradeSortedList.get(row);
				if (!isRowSelected(row)) c.setBackground(tradeTableRow.getCashProfitMin() < 0 ? new Color(230,230,230) : Color.WHITE );
			}
		return c;
	}
}
