/*
 * VegaFileChooser.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * JFileChooser that only allow a valid folder to be opened
 * If open is pressed on a folder that is not valid, the folder is simply opened in the JFileChooser
 * If the folder is a valid vega strike folder, the dialog closed.
 * Also happens when opening a folder (wiht the mouse or keyboard)
 */

package vstrade.moduls.settings;

//Java
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;

//VSTrade
import vstrade.data.settings.FileSettings;

public class VegaFileChooser extends JFileChooser implements PropertyChangeListener {
	
	private FileSettings paths;
	
	/** Creates a new instance of VegaFileChooser */
	public VegaFileChooser(FileSettings paths) {
		this.paths = paths;
		setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		setMultiSelectionEnabled(false);
		//fileChooser.setControlButtonsAreShown(false);
		
		addPropertyChangeListener(this);	
	}
	
	@Override
	public void approveSelection(){
		File selectedFile = this.getSelectedFile();
		if (selectedFile != null){
			if (paths.isValidPath(selectedFile.getAbsolutePath()) ){
				super.approveSelection();
				//super.setCurrentDirectory(selectedFile);
			} else {
				super.setCurrentDirectory(selectedFile);
			}
		}
    }

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		 String prop = evt.getPropertyName();
		if (prop.equals(JFileChooser.DIRECTORY_CHANGED_PROPERTY)){
			this.approveSelection();
		}
	}
	/*
	 *  Workaround, for JFileChooser bug...
	 */
	@Override
	public void updateUI() {
		putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
		super.updateUI();
	}
}
