/*
 * PriceTableRow.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Used by the price table (part of the Glazed Lists implementation)
 */

package vstrade.moduls.price;

import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;

public class PriceTableRow implements Comparable<PriceTableRow>{
	
	private Base base;
	private Cargo cargo;
	private String baseName;
	private String cargoName;
	private int nQuantityMaximum;
	private int nQuantityAverage;
	private int nQuantityMinimum;
	private float nCargoVolume;
	private int nPriceMaximum;
	private int nPriceAverage;
	private int nPriceMinimum;
	private int nPricePercent;
	
	/** Creates a new instance of PriceTableRow */
	public PriceTableRow(Base base, Cargo cargo) {
		this.base = base;
		this.cargo = cargo;
		
		baseName = base.getName();
		cargoName = cargo.getName();
		nCargoVolume = cargo.getCargoVolume();
		
		nQuantityMaximum = cargo.getQuantityMaximum();
		nQuantityAverage = cargo.getQuantityAverage();
		nQuantityMinimum = cargo.getQuantityMinimum();
		nPriceMaximum = cargo.getPriceMaximum();
		nPriceAverage = cargo.getPriceAverage();
		nPriceMinimum = cargo.getPriceMinimum();
		nPricePercent = cargo.getPricePercent();
	}
	
	@Override
	public int compareTo(PriceTableRow o) {
		return 0;
	}
	
	public Base getBase() {
		return base;
	}
	
	public Cargo getCargo() {
		return cargo;
	}
	
	public String getBaseName() {
		return baseName;
	}
	
	public String getCargoName() {
		return cargoName;
	}
	
	public int getQuantityMaximum() {
		return nQuantityMaximum;
	}
	
	public int getQuantityAverage() {
		return nQuantityAverage;
	}
	
	public int getQuantityMinimum() {
		return nQuantityMinimum;
	}
	
	public float getCargoVolume() {
		return nCargoVolume;
	}
	
	public int getPriceMaximum() {
		return nPriceMaximum;
	}

	public int getPriceAverage() {
		return nPriceAverage;
	}
	
	public int getPriceMinimum() {
		return nPriceMinimum;
	}
	
	public int getPricePercent() {
		return nPricePercent;
	}
}
