/*
 * PriceTablePopupMenu.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Price table pop-up menu
 */

package vstrade.moduls.price;

//Java
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

//VSTrade
import vstrade.Program;

public class PriceTablePopupMenu extends JPopupMenu {
	
	public final String ACTION_PRICE_ADD_BASE = "MenuAddBase";
	public final String ACTION_PRICE_SET_CARGO = "MenuSetCargo";
	
	private JMenuItem jPrice;
	private JMenuItem jPriceAddBase;
	private JMenuItem jPriceSetCargo;
	private JMenuItem jTrade;
	private JMenuItem jTradeAddAsBuyBase;
	private JMenuItem jTradeAddAsSellBase;
	private JMenuItem jCargo;
	private JMenuItem jCargoSetCargo;
	
	private Program program;
	
	/** Creates a new instance of PriceTablePopupMenu */
	public PriceTablePopupMenu(Program program, ActionListener priceListener) {
		this.program = program;
		jPrice = new JMenuItem();
		jPrice.setEnabled(false);
		add(jPrice);
		jPriceAddBase = new JMenuItem();
		jPriceAddBase.setActionCommand(ACTION_PRICE_ADD_BASE);
		jPriceAddBase.addActionListener(priceListener);
		add(jPriceAddBase);
		jPriceSetCargo = new JMenuItem();
		jPriceSetCargo.setActionCommand(ACTION_PRICE_SET_CARGO);
		jPriceSetCargo.addActionListener(priceListener);
		add(jPriceSetCargo);
		this.addSeparator();
		jTrade = new JMenuItem();
		jTrade.setEnabled(false);
		add(jTrade);
		jTradeAddAsBuyBase = new JMenuItem();
		jTradeAddAsBuyBase.setActionCommand(Program.ACTION_PRICE_TRADE_ADD_AS_BUY_BASE);
		jTradeAddAsBuyBase.addActionListener(program);
		add(jTradeAddAsBuyBase);
		jTradeAddAsSellBase = new JMenuItem();
		jTradeAddAsSellBase.setActionCommand(Program.ACTION_PRICE_TRADE_ADD_AS_SELL_BASE);
		jTradeAddAsSellBase.addActionListener(program);
		add(jTradeAddAsSellBase);
		this.addSeparator();
		jCargo = new JMenuItem();
		jCargo.setEnabled(false);
		add(jCargo);
		jCargoSetCargo = new JMenuItem();
		jCargoSetCargo.setActionCommand(Program.ACTION_PRICE_CARGO_SET_CARGO);
		jCargoSetCargo.addActionListener(program);
		add(jCargoSetCargo);
	}
	public void updateLanguage(){
		jPrice.setText(program.getSettings().getLanguageSettings().getString("MenuPrice", "price"));
		jPriceAddBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddBase", "price"));
		jPriceSetCargo.setText(program.getSettings().getLanguageSettings().getString("MenuSetCargo", "price"));
		jTrade.setText(program.getSettings().getLanguageSettings().getString("MenuTrade", "price"));
		jTradeAddAsBuyBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddAsBuyBase", "price"));
		jTradeAddAsSellBase.setText(program.getSettings().getLanguageSettings().getString("MenuAddAsSellBase", "price"));
		jCargo.setText(program.getSettings().getLanguageSettings().getString("MenuCargo", "price"));
		jCargoSetCargo.setText(program.getSettings().getLanguageSettings().getString("MenuSetCargo", "price"));
	}
	
}
