/*
 * HelpView.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * The HelpView show helpme files
 */
package vstrade.moduls.help;

//VSTrade
import vstrade.Program;
import vstrade.shared.ModuleView;

public class HelpView extends ModuleView {
	
	private Program program;
	
	/** Creates a new instance of HelpView */
	public HelpView(Program program) {
		this.program = program;
	}
	
	@Override
	public String getTitle(){
		return sTitle;
	}
	
	public void settingsUpdated(){}
	
	@Override
	public void setData() {
		updateLanguage();
	}
	
	@Override
	public void clearData() {}
	
	@Override
	public void updateLanguage() {
		sTitle = program.getSettings().getLanguageSettings().getString("Title", "help");
	}

	
	
}
