/*
 * TabFrame.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * The JFrame and tab JPanel
 */

package vstrade.moduls.frame;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import vstrade.io.Log;
import vstrade.shared.Module;
import vstrade.shared.ModuleView;
import java.awt.Dimension;
import java.util.List;
//import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
import vstrade.moduls.cargo.CargoView;
import vstrade.moduls.map.MapView;
import vstrade.moduls.price.PriceView;
import vstrade.moduls.settings.SettingsView;
import vstrade.moduls.trade.TradeView;
 */


public class TabFrame implements WindowListener, MouseListener, Module {
	
	public static final int WINDOW_WIDTH = 800;
	public static final int WINDOW_HEIGHT = 600;
	
	//Frame
	private JFrame jFrame;
	
	//Tabs
	private JTabbedPane jTabbedPanel;
	private List<ModuleView> tabs;
	
	private JPanel jMainPanel;
	
	/** Creates a new instance of Frame */
	public TabFrame() {
		tabs = new Vector<ModuleView>();
		
		//Tabbed Panel
		jTabbedPanel = new JTabbedPane();
		jTabbedPanel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
		jTabbedPanel.addMouseListener(this);
		//Main Panel	
		jMainPanel = new JPanel();
		jMainPanel.setLayout( new BoxLayout(jMainPanel, BoxLayout.PAGE_AXIS) ); 
		jMainPanel.add( jTabbedPanel );
		
		//Frame
		jFrame = new JFrame("VSTrade");
		jFrame.setSize(new Dimension(WINDOW_WIDTH, WINDOW_HEIGHT)); //800, 600
		jFrame.addWindowListener(this);
		jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		jFrame.getContentPane().add(jMainPanel);
	}
    
    @Override
	public void setData(){
		 updateLanguage();
	}
	@Override
	public void clearData() {}
	
	@Override
	public void updateLanguage() {
		for(int a = 0; a < tabs.size(); a++){
			jTabbedPanel.setTitleAt(a, tabs.get(a).getTitle());
		}
	}
	
	public void addTab(ModuleView jPanel){
		jTabbedPanel.addTab("", jPanel);
		tabs.add(jPanel);
	}
	public void setStatusbar(JComponent jToolBar){
		jMainPanel.add(jToolBar);
	}
	public void show(){
		jFrame.setVisible(true);
	}
	public void setSelectedComponent(ModuleView panel){
		jTabbedPanel.setSelectedComponent(panel);
	}
    
    
    @Override
	public void windowClosing(WindowEvent e) {
		Log.info("VSTrade closing");
	}
	
    @Override
	public void windowOpened(WindowEvent e) {}
    
    @Override
	public void windowClosed(WindowEvent e) {}
    
    @Override
	public void windowIconified(WindowEvent e) {}
    
    @Override
	public void windowDeiconified(WindowEvent e) {}
    
    @Override
	public void windowActivated(WindowEvent e) {}
    
    @Override
	public void windowDeactivated(WindowEvent e) {}

	protected void enabled(boolean bEnable) {}

    @Override
	public void mouseClicked(MouseEvent e) {}
	
    @Override
	public void mousePressed(MouseEvent e) {
		if (e.getSource() instanceof JTabbedPane){
			JTabbedPane jTabbedPane = (JTabbedPane) e.getSource();
			jTabbedPane.transferFocus();
		}
	}
    
    @Override
	public void mouseReleased(MouseEvent e) {}

    @Override
	public void mouseEntered(MouseEvent e) {}
	
	@Override
	public void mouseExited(MouseEvent e) {}
}
