/*
 * ReadmeReader.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Read the readme file
 */

package vstrade.moduls.about;

//Java
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import vstrade.io.Log;

public class ReadmeReader {
	
	private FileReader fileReader;
	private BufferedReader bufferedReader;
	
	private String result;
	
	/** Creates a new instance of ReadmeReader */
	public ReadmeReader() {
		
	}
	public String load(String filename){ 
		result = "";
		boolean bSucceed;
		bSucceed = open( new File(filename) );
		if (bSucceed) read();
		if (bSucceed) close();
		if (bSucceed) Log.info("Readme loaded");
		return result;
	}
	//Open the file for reading
	private boolean open(File filename){
		try{
			fileReader = new FileReader(filename); 
			bufferedReader = new BufferedReader(fileReader); 
		} catch (IOException t){
			Log.warning("Readme not loaded (OPEN FAILED: \""+filename+"\")");
			return false;
		}
		return true;
	}
	//Close the file
	private boolean close(){
		try{
			fileReader.close();
		} catch (IOException t){
			Log.error("Readme not loaded (CLOSE FAILED)", t);
			return false;
		}
		return true;
	}
	//Read each Line in the file
	private void read(){
		String record = new String(); //The unprocessed line
		try {
			bufferedReader.readLine(); //Skip the first line (only contains description of fields)
			while ((record = bufferedReader.readLine()) != null) { //Read each line in the file
				result = result + record + "\n";
			}
		} catch (IOException e) { 
			Log.error("Readme not loaded (READ FAILED)", e);
		}
	}
	
}
