/*
 * AboutView.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * AboutView show the readme file in the program
 */

package vstrade.moduls.about;

//Java
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

//VSTrade
import vstrade.Program;
import vstrade.shared.GUIFactory;
import vstrade.shared.ModuleView;

public class AboutView extends ModuleView {
	
	private JPanel jReadmeTPanel;
	
	private Program program;
	
	/** Creates a new instance of AboutView */
	public AboutView(Program program) {
		this.program = program;
		
		ReadmeReader readmeReader = new ReadmeReader();
		String sReadme = readmeReader.load(program.getSettings().getFileSettings().getReadmePath());
		
		JTextPane jReadme = new JTextPane();
		jReadme.setFont( new Font(Font.MONOSPACED, Font.PLAIN, 12));
		jReadme.setText(sReadme);
		jReadme.setEditable(false);
		jReadme.setDisabledTextColor(Color.BLACK);
		jReadme.setCaretPosition(0);
		//jReadme.setBackground(Color.WHITE);
		//jReadme.setEnabled(false);
		//jReadme.setBackground(null);
		
		JScrollPane jReadmePanel = new JScrollPane(jReadme);
		jReadmePanel.setBorder(null);
		//jReadmeTPanel.setViewportView(jReadme);
		jReadmePanel.setBorder( BorderFactory.createEmptyBorder(0, 5, 5, 5));
		

		this.jReadmeTPanel = new JPanel();
		
		this.jReadmeTPanel.setBorder( BorderFactory.createTitledBorder("") );
		this.jReadmeTPanel.setLayout( new BoxLayout(this.jReadmeTPanel, BoxLayout.PAGE_AXIS) ); 
		this.jReadmeTPanel.add(jReadmePanel);

		this.setLayout(new BoxLayout(this, BoxLayout.PAGE_AXIS));
		this.add(this.jReadmeTPanel);
	}
    
    @Override
	public void setData() {
		updateLanguage();
	}
	
	@Override
	public void clearData() {}
	
    @Override
	public void updateLanguage() {
		sTitle = program.getSettings().getLanguageSettings().getString("Title", "about");
		GUIFactory.setBorderTitle(this.jReadmeTPanel, program.getSettings().getLanguageSettings().getString("Readme", "about"));
	}

    
	
}
