/*
 * LocaleItem.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Wrapper for Locale (with to toString)
 */
package vstrade.language;

//Java
import java.util.Locale;

public class LocaleItem {
	
	private Locale locale;
	private String sLanguage;
	private String sContry;
	/** Creates a new instance of LocaleItem */
	
	public LocaleItem(String sLanguage, String sContry) {
		this.locale = new Locale(sLanguage, sContry);
	}
	
	public LocaleItem(Locale locale) {
		this.locale = locale;
	}
	
    @Override
	public String toString(){
		if (locale == null) return "Keys";
		return locale.getDisplayLanguage()+" ("+locale.getDisplayCountry()+")";
	}
	
    @Override
	public boolean equals(Object o){
		if (o instanceof LocaleItem){
			LocaleItem localeItem = (LocaleItem) o;
			return localeItem.equals(this);
		}
		return false;
	}
	public boolean equals(LocaleItem localeItem){
		return (this.getCountry().equals(localeItem.getCountry()) && this.getLanguage().equals(localeItem.getLanguage()));
	}
	public String getCountry(){
		if (locale == null) return sContry;
		return locale.getCountry();
	}
	public String getLanguage(){
		if (locale == null) return sLanguage;
		return locale.getLanguage();
	}
}
