/*
 * Log.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Write to vstrade_log.txt. Only got static methods
 */

package vstrade.io;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;

public class Log {
	
	public static final String FILENAME = "vstrade_log.txt";
	public static FileWriter fileWriter;
	public static boolean bInitialized = false;
	
	/** Creates a new instance of Log */
	private Log() {
	}
	
	public static void write(String s){
		print(s);
	}
	public static void debug(String s){
		print("(Debug) "+s);
	}
	public static void error(Throwable e){
		String s = "An unknown error has occurred!\n\nPlease report this error at:\nhttp://vegastrike.sourceforge.net/forums/viewtopic.php?t=6286\n\nPlease include vstrade_log.txt in your post and a brife explanation of what you were doing at the time of the crash";
		printErrorToScreen(s);
		print("(Error) "+s, true, e);
		System.exit(1);
	}
	public static void error(String s, Throwable e){
		printErrorToScreen(s);
		print("(Error) "+s, true, e);
		System.exit(1);
	}
	public static void error(String s){
		printErrorToScreen(s);
		print("(Error) "+s, true, null);
		System.exit(1);
	}
	public static void info(String s){
		print("(Info) "+s);
	}
	public static void warning(String s){
		print("(Warning) "+s);
	}
	public static void showWarning(String s){
		printWarningToScreen(s);
	}
	
	private static void print(String s){
		print(s, false, null);
	}
	private static void print(String s, boolean e, Throwable t){
		// Output to consol
		if(e){
			System.err.println(s);
		} else {
			System.out.println(s);
		}
		//open file
		open(); 
		// Output to file
		try {
			fileWriter.write(s+"\r\n");
		} catch (IOException xe) {
			xe.printStackTrace();
		}
		// Print Stack Trace
		if(t != null){ 
			PrintWriter printWriter = new PrintWriter(fileWriter);
			t.printStackTrace(printWriter);
		}
		// close file
		close(); 

	}
	private static void printErrorToScreen(String s){
		JOptionPane.showMessageDialog(null, s, "Error", JOptionPane.ERROR_MESSAGE);
	}
	private static void printWarningToScreen(String s){
		JOptionPane.showMessageDialog(null, s, "Warning", JOptionPane.WARNING_MESSAGE);
	}
	private static void init(){
		bInitialized = true;
		try {
			fileWriter = new FileWriter(FILENAME, false);
			fileWriter.write("");
			fileWriter.close();
			//fileWriter = new FileWriter(FILENAME, true);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
	private static void open(){
		if (!bInitialized) init();
		try {
			fileWriter = new FileWriter(FILENAME, true);
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
	
	private static void close(){
		try {
			fileWriter.close();
		} catch (IOException ex) {
			ex.printStackTrace();
		}
	}
}
