/*
 * DataCreater.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Create (and load) all the data (in thread)
 */

package vstrade.io;

//VSTrade
import vstrade.Program;
import vstrade.SplashUpdater;
import vstrade.data.bases.Bases;
import vstrade.data.galaxy.Galaxy;

public class DataCreater extends Thread {
	
	private Program program;
	
	/** Creates a new instance of DataCreater */
	public DataCreater(Program program) {
		this.program = program;
		this.setName("DataCreater");
	}
	
    @Override
	public void run() {
		Bases bases = new Bases(program);
		program.getStatusView().setSettingsSaveProgress(50);
		SplashUpdater.setProgress(70);
		Galaxy galaxy = new Galaxy(program, bases);
		SplashUpdater.setProgress(90);
		program.getStatusView().setSettingsSaveProgress(90);
		SplashUpdater.setProgress(100);
		program.setGalaxy(galaxy);
		program.setBases(bases);
		program.setData();
		program.getStatusView().setSettingsSaveProgress(100);
		return;
	}
	
}
