/*
 * Settings.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Hold the settings for the Program
 */

package vstrade.data.settings;

import vstrade.language.ResourceBundleManager;

public class Settings {
	
	//Paths
	private FileSettings fileSettings;
	private MapSettings mapSettings;
	private TradeSettings tradeSettings;
	private PriceSettings priceSettings;
	
	private boolean bDefaultSettings;
	
	private boolean bAutoConfig;
	
	//Switch component when date is set from another component
	private boolean bSwitchComponent;
	
	//private Locale currentLocale;
	
	private SettingsReader settingsReader;
	private SettingsWriter settingsWriter;
	private ResourceBundleManager resourceBundleManager;
	
	/** Creates a new instance of Settings */
	public Settings() {
		//init
		settingsReader = new SettingsReader();
		settingsWriter = new SettingsWriter();
		
		fileSettings = new FileSettings();
		mapSettings = new MapSettings();
		tradeSettings = new TradeSettings();
		priceSettings = new PriceSettings();
		resourceBundleManager = new ResourceBundleManager();
		
		//Loading settings from file
		bDefaultSettings = !settingsReader.load(this);
		
		//If no file is found, using default settings // Default Settings (if no settings exist)
		if (bDefaultSettings){
			bAutoConfig = true;
			bSwitchComponent = true;
			
			mapSettings.showJumpsLines(false);
			mapSettings.showJumplessSystems(false);
			mapSettings.showNames(true);
			mapSettings.showFactions(false);
			mapSettings.showSectors(false);
			mapSettings.showSectorBoxes(false);
			mapSettings.showYaxis(true);
			mapSettings.enableAutoCenter(true);
			
			tradeSettings.addTradeTableColumn("TableBuyBase");
			tradeSettings.addTradeTableColumn("TableSellBase");
			tradeSettings.addTradeTableColumn("TableCommerce");
			//tradeSettings.addTradeTableColumn("TableMaxQuantity");
			tradeSettings.addTradeTableColumn("TableAvgQuantity");
			//tradeSettings.addTradeTableColumn("TableMinQuantity");
			//tradeSettings.addTradeTableColumn("TableVolume");
			//tradeSettings.addTradeTableColumn("TableMaxPercent");
			tradeSettings.addTradeTableColumn("TableAvgPercent");
			//tradeSettings.addTradeTableColumn("TableMinPercent");
			//tradeSettings.addTradeTableColumn("TableMaxCash");
			tradeSettings.addTradeTableColumn("TableAvgCash");
			//tradeSettings.addTradeTableColumn("TableMinCash");
			
			priceSettings.addPriceTableColumn("TableBase");
			priceSettings.addPriceTableColumn("TableCommerce");
			//priceSettings.addPriceTableColumn("TableMaxQuantity");
			priceSettings.addPriceTableColumn("TableAvgQuantity");
			//priceSettings.addPriceTableColumn("TableMinQuantity");
			//priceSettings.addPriceTableColumn("TableVolume");
			priceSettings.addPriceTableColumn("TableMaxPrice");
			priceSettings.addPriceTableColumn("TableAvgPrice");
			priceSettings.addPriceTableColumn("TableMinPrice");
			priceSettings.addPriceTableColumn("TablePercentPrice");
		}
	}
	public FileSettings getFileSettings(){
		return fileSettings;
	}
	public MapSettings getMapSettings(){
		return mapSettings;
	}
	public TradeSettings getTradeSettings(){
		return tradeSettings;
	}
	public PriceSettings getPriceSettings(){
		return priceSettings;
	}
	public ResourceBundleManager getLanguageSettings(){
		return resourceBundleManager;
	}
	public boolean getAutoConfig(){
		return bAutoConfig;
	}
	public void setAutoConfig(boolean bAutoConfig){
		this.bAutoConfig = bAutoConfig;
	}
	public boolean getSwitchComponent(){
		return bSwitchComponent;
	}
	public void setSwitchComponent(boolean bSwitchComponent){
		this.bSwitchComponent = bSwitchComponent;
	}
	public void saveSettings(){
		settingsWriter.save(this);
		fileSettings.isVegaStrikePathUpdated(false);
	}
}
