/*
 * PathsParser.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * parse the files.xml file, holding the location of the files in the vegastrike directory...
 */

package vstrade.data.settings;

//Java
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

//VSTrade
import vstrade.io.Log;


public class FileSettingsParser {
	
	private FileSettings files;
	
	/**
	 * Creates a new instance of PathsParser
	 */
	public FileSettingsParser() { }
	public boolean load(FileSettings files, String filename){
		this.files = files;
		FileInputStream input = null;
		try {
			input = new FileInputStream(new File(filename));
		} catch (Exception ex) {
			Log.error("\""+filename+"\" is missing from the working directory.\nPlease see vstrade_faq.txt for more information.");
			return false;
		}
		try {
			loadMod(input);
		} catch (FileSettingsLoadException ex) {
			Log.error("No paths loaded (PARSER ERROR: \""+filename+"\")", ex);
			return false;
		}
		//resolveJumps();
		Log.info("Paths loaded");
		return true;
	}
	
	private void loadMod(InputStream is) throws FileSettingsLoadException {
		DocumentBuilderFactory factory = null;
		DocumentBuilder builder = null;
		Document doc = null;

		try {
			factory = DocumentBuilderFactory.newInstance();
			builder = factory.newDocumentBuilder();

			doc = builder.parse(is);
			is.close();
		} catch (Exception e) {
			throw new FileSettingsLoadException(e);
		}

		Element element = doc.getDocumentElement();

		parseMods(element);
	}
	
	private void parseMods(Element element) throws FileSettingsLoadException {
		if (!element.getNodeName().equals("files")) {
			throw new FileSettingsLoadException("Wrong root element name.");
		}
		
		NodeList varList = element.getElementsByTagName("var");
		for (int i = 0; i < varList.getLength(); i++) {
			Element child = (Element)varList.item(i);
			parseVar(child);
		}
	}
	private void parseVar(Element element) {
		String sKey = element.getAttribute("key");
		String sValue = element.getAttribute("value");
		if (sKey.equals("") || sValue.equals("")){
			Log.warning("Ill formed XML (files.xml)");
			return;
		}
		addVar(sKey, sValue);
	}
	private void addVar(String sKey, String sValue) {
		files.add(sKey, sValue);
	}
	
}
