/*
 * GalaxySystem.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * Original code by: weaselflink
 * Modified by: Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * a System with Its jumps (that are Systems as well)
 */

package vstrade.data.galaxy;

import vstrade.data.Node;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import vstrade.io.Log;


public class GalaxySystem extends Node {
	
	private String sFaction = "";
	private Point3D pos;
	private List<String> jumpStrings;
	
	/** Creates a new instance of System */
	public GalaxySystem(String sName, Point3D pos, String sFaction) {
		this.sName = sName;
		this.pos = pos;
		this.sFaction = sFaction;
		
		jumpStrings = new Vector<String>();
	}
	
    @Override
	public void add(Node n){
		if (nodes.containsKey(n.getName()) ){
			Log.warning(n.getName()+" already exist in nodes");
		}
		nodes.put(n.getName(), n);
		values.add(n);
	}
	public String getFullName() {
        return parent.getName() + "/" + getName();
    }
    
    public Point3D getPos() {
        return pos;
    }
    
    public String getFaction() {
        return sFaction;
    }
    public List<String> getJumpStrings() {
        return jumpStrings;
    }
    
    public void addJumpString(String jump) {
        jumpStrings.add(jump);
    }
    public void clearJumpStrings() {
        jumpStrings.clear();
    }
    @Override
    protected void printAdv(int nLevel){
		
	}
    @Override
	protected void print(int nLevel, String sPath){
		String sJumps = "";
		String sJumpsString = "";
		if (nLevel != 0){
			sPath = sPath+"/"  + this.getName(); // and itself to the path
		} else {
			sPath = this.getName(); //Root, and itself
		}
		
		Enumeration<String> keys = nodes.keys(); //Get keys for nodes
		while (keys.hasMoreElements()){
			sJumps = sJumps +"|"+ nodes.get(keys.nextElement()).getName();
		}
		for (int a = 0; a < jumpStrings.size(); a++){
			sJumpsString = sJumpsString + jumpStrings.get(a);
		}
		System.out.println(sPath+"	"+sJumps+"	"+sJumpsString); //Print the path
	}
	@Override
	public void clear(){
		//super.clear();
		jumpStrings.clear();
		nodes.clear();
		values.clear();
	}
	
}
