/*
 * GalaxySector.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * a Sector (with Point3D max/min)
 */

package vstrade.data.galaxy;

//Java
import java.util.Collections;
import java.util.Vector;

//VSTrade
import vstrade.data.Node;

public class GalaxySector extends Node {
	
	private Point3D min;
    private Point3D max;
	
	/** Creates a new instance of Sector */
	public GalaxySector(String sName) {
		this.sName = sName;
	}
    @Override
	public void add(Node n){
		super.add(n);
		Point3D pos = ((GalaxySystem)n).getPos();
		if (min == null) {
			min = new Point3D(pos);
			max = new Point3D(pos);
			return;
		}

		if (pos.x < min.x) {
			min.x = pos.x;
		}
		if (pos.y < min.y) {
			min.y = pos.y;
		}
		if (pos.z < min.z) {
			min.z = pos.z;
		}
		if (pos.x > max.x) {
			max.x = pos.x;
		}
		if (pos.y > max.y) {
			max.y = pos.y;
		}
		if (pos.z > max.z) {
			max.z = pos.z;
		}
	}
	public Point3D getMin() {
		return min;
	}

	public Point3D getMax() {
		return max;
	}
	public Vector<Node> getList(){
		Vector<Node> vector = new Vector<Node>(nodes.values());
		Collections.sort(vector);
		return vector;
	}
}
