/*
 * Galaxy.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * The Root of the sector > system, data tree
 */

package vstrade.data.galaxy;

import vstrade.data.Node;
import java.util.Vector;
import vstrade.Program;
import vstrade.data.bases.Bases;


public class Galaxy extends Node {
	
	private MilkyWayReader milkyWayReader;
	private boolean isLoaded;
	private Vector<Node> allSystems;
	
	private Point3D min;
    private Point3D max;
	
	/** Creates a new instance of Galaxy */
	public Galaxy(Program program, Bases bases) {
		milkyWayReader = new MilkyWayReader();
		//Hold all systems
		allSystems = new Vector<Node>();
		sName = "galaxy";
		
		isLoaded = milkyWayReader.load(program.getSettings().getFileSettings().getMilkyWayPath(), bases, this);
	}
	
    @Override
	public void add(Node n){
		super.add(n);
		GalaxySector sector = (GalaxySector) n;
		//Add all sub systems...
		allSystems.addAll(sector.getList());
		
		Point3D posMin = sector.getMin();
		Point3D posMax = sector.getMax();
		if (min == null) {
			min = new Point3D(posMin);
			max = new Point3D(posMax);
			return;
		}
		
		if (posMin.x < min.x) {
			min.x = posMin.x;
		}
		if (posMin.y < min.y) {
			min.y = posMin.y;
		}
		if (posMin.z < min.z) {
			min.z = posMin.z;
		}
		if (posMax.x > max.x) {
			max.x = posMax.x;
		}
		if (posMax.y > max.y) {
			max.y = posMax.y;
		}
		if (posMax.z > max.z) {
			max.z = posMax.z;
		}
	}
	public Vector<Node> getSystems(){
		return allSystems;
	}
	public boolean isLoaded(){
		return isLoaded;
	}
	public Point3D getMin() {
		return min;
	}

	public Point3D getMax() {
		return max;
	}
	@Override
	public void clear(){
		super.clear();
		allSystems.clear();
	}
}
