/*
 * Category.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * a Category item
 */

package vstrade.data.bases;

//Java
import java.util.Enumeration;
import java.util.Vector;
import vstrade.io.Log;

//VSTrade
import vstrade.data.Node;


public class Category extends Node {
	private float nQuantity = 0; //Quantity (Decimal * 1)
	private float nQuantityFluctuation = 0; //Decimal Quantity Fluctuation
	private float nPriceFluctuation = 0; //Decimal Price Fluctuation
	private float nPriceModifier = 0; //Decimal of full price
	
	/** Creates a new instance of Category */
	public Category(String sName) {
		this.sName = sName;
	}
	public Category(String sName, Node parent, boolean svnVersion) {
		this.sName = sName; 
		this.parent = parent;
		if (svnVersion) nPriceModifier = 1;
		parent.add(this);
	}
	public void setQuantity(String sQuantity){
		if (sQuantity.equals("")) return;
		float n;
		try {
			n = Float.valueOf(sQuantity);
		} catch (NumberFormatException ex) {
			Log.warning(this.getClass()+".setQuantity() :: NaN error (Attempt to convert String  \"sQuantity@"+sQuantity+"\" to Float failed)");
			return;
		}
		setQuantity(n);
	}
	public void setQuantity(float nQuantity){
		this.nQuantity = nQuantity;
	}
	public void setQuantityFluctuation(String sQuantityFluctuation){
		if (sQuantityFluctuation.equals("")) return;
		float n;
		try {
			n = Float.valueOf(sQuantityFluctuation);
		} catch (NumberFormatException ex) {
			Log.warning(this.getClass()+".setQuantityFluctuation() :: NaN error (Attempt to convert String \"sQuantityFluctuation@"+sQuantityFluctuation+"\" to Float failed)");
			return;
		}
		setQuantityFluctuation(n);
	}
	public void setQuantityFluctuation(float nQuantityFluctuation){
		this.nQuantityFluctuation = nQuantityFluctuation;
	}
	public void setPriceFluctuation(String sPriceFluctuation){
		if (sPriceFluctuation.equals("")) return;
		float n;
		try {
			n = Float.valueOf(sPriceFluctuation);
		} catch (NumberFormatException ex) {
			Log.warning(this.getClass()+".setPriceFluctuation() :: NaN error (Attempt to convert String \"sPriceFluctuation@"+sPriceFluctuation+"\" to Float failed)");
			return;
		}
		setPriceFluctuation(n);
	}
	public void setPriceFluctuation(float nPriceFluctuation){
		this.nPriceFluctuation = nPriceFluctuation;
	}
	public void setPriceModifier(String PriceModifier){
		if (PriceModifier.equals("")) return;
		float n;
		try {
			n = Float.valueOf(PriceModifier);
		} catch (NumberFormatException ex) {
			Log.warning(this.getClass()+".setPriceModifier() :: NaN error (Attempt to convert String \"PriceModifier@"+PriceModifier+"\" to Float failed)");
			return;
		}
		setPriceModifier(n);
	}
	public void setPriceModifier(float nPriceModifier){
		this.nPriceModifier = nPriceModifier;
	}
	public float getQuantity(){
		return nQuantity;
	}
	public float getQuantityFluctuation(){
		return nQuantityFluctuation;
	}
	public float getPriceFluctuation(){
		return nPriceFluctuation;
	}
	public float getPriceModifier(){
		return nPriceModifier;
	}
	public Category deepClone(){
		Category copy = new Category(this.getName());
		copy.setPriceFluctuation(this.getPriceFluctuation());
		copy.setPriceModifier(this.getPriceModifier());
		copy.setQuantity(this.getQuantity());
		copy.setQuantityFluctuation(this.getQuantityFluctuation());
		Enumeration<String> keys = nodes.keys();
		
		while (keys.hasMoreElements()){
			String key = keys.nextElement();
			if (nodes.get(key).getClass().equals(Cargo.class)){
				Cargo child =  ((Cargo) nodes.get(key)).deepClone();
				copy.add(child);
			} else {
				Category child = ((Category) nodes.get(key)).deepClone();
				copy.add(child);
			}
			
		}
		return copy;
	}
    @Override
	public String toString(){
		Vector<Node> vectorNode = this.getParents();
		String sSpace = "";
		for (int a = 2; a < vectorNode.size(); a++){
			sSpace = sSpace + "  ";
		}
		return sSpace+getName();
	}
}
