/*
 * Base.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Hold a base or planet
 */

package vstrade.data.bases;

import vstrade.data.Node;
import java.util.Enumeration;


public class Base extends Node {
	
	private String sType = "";
	/** Creates a new instance of Base */
	public Base(String sName, String sType) {
		this.sName = sName;
		this.sType = sType;
	}
	public void setType(String sType){
		this.sType = sType;
	}
	public String getType(){
		return sType;
	}
	public Base deepClone(){
		Base copy = new Base(sName, sType);
		Enumeration<String> keys = nodes.keys();
		while (keys.hasMoreElements()){
			Category child = ((Category) nodes.get(keys.nextElement())).deepClone();
			copy.add(child);
		}
		return copy;
	}
}

