/*
 * VSTrade.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Main class. Set look and feel and create Program
 */

package vstrade;

//Java
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class VSTrade {
	static String[] inputString;

	/** Creates a new instance of VSTrade (and create Program instance) */
	public VSTrade(String[] argumentsString) {
		Program program = new Program();
	}

	/** @param args the command line arguments */
	public static void main(String[] args) {
			inputString = args;
			javax.swing.SwingUtilities.invokeLater(new Runnable() {
							@Override
							public void run() {
									createAndShowGUI();
							}
					});
	}
	private static void createAndShowGUI() {
		initLookAndFeel();

		//Make sure we have nice window decorations.
		JFrame.setDefaultLookAndFeelDecorated(true);
		JDialog.setDefaultLookAndFeelDecorated(true);

		VSTrade vsTrade = new VSTrade(inputString);
	}

	private static void initLookAndFeel() {
		String lookAndFeel = null;
		lookAndFeel = UIManager.getSystemLookAndFeelClassName(); //System
		//lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName(); //Java (Any Platform)
		//lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel"; //CDE/Motif (Any Platform)
		//lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel"; //Windows (Windows Only)
		//lookAndFeel = "javax.swing.plaf.mac.MacLookAndFeel"; //Mac (Mac Only)
		//lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel"; //Java (Any Platform)
		//lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"; //GTK (Don't work on windows)
		try {
			UIManager.setLookAndFeel(lookAndFeel);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}


}
