/*
 * SplashUpdater.java - This file is part of VSTrade.
 *
 * Copyright (C) 2007 Niklas Kyster Rasmussen
 *
 * VSTrade is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * VSTrade is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with VSTrade; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * FILE DESCRIPTION:
 * Update the splash screen, only have static methods.
 */

package vstrade;

//Java
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.SplashScreen;

public class SplashUpdater {
	
	private static int nProgress = 0;
	private static String sText = "";
	
	/** Creates a new instance of SplashUpdater (Should never be called, as all functions are static) */
	private SplashUpdater() {
		
	}
	/**
	 * Set splash screen text
	 * @param s     String to show on splash screen
	 */
	public static void setText(String s){
		sText = s;
		update();
	}
	/**
	 * Set progress of splash screen progressbar in the range 0-100 
	 * @param n     Set progress in the range 0-100
	 */
	public static void setProgress(int n){
		if (n > 100) n = 100;
		nProgress = n;
		update();
	}
	private static void update(){
		SplashScreen splash = SplashScreen.getSplashScreen();
		if (splash != null){
			Graphics2D g = (Graphics2D)splash.createGraphics();
			g.setComposite(AlphaComposite.Clear);
			Dimension size = splash.getSize();
			g.fillRect(0, 0, size.width, size.height);
			g.setPaintMode();
			g.setColor(Color.WHITE);
			g.drawString(sText, 5, 254);
			g.setColor(Color.LIGHT_GRAY);
			g.drawRect(149, 243, (int) (100*2.3)+1, 13);
			g.setColor(Color.WHITE);
			g.fillRect(150, 244, (int) (nProgress*2.3), 12);
			splash.update();
		}
	}
	
}
