/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swt.EventKTableModel;
import com.publicobject.issuesbrowser.Issue;
import com.publicobject.issuesbrowser.IssueLoader;
import com.publicobject.issuesbrowser.Project;
import com.publicobject.misc.Throbber;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableModel;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class KTableDemo {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText("Issues");
        KTableDemo.createIssuesTable(shell);
        shell.setSize(600, 600);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createIssuesTable(Shell shell) {
        BasicEventList issuesEventList = new BasicEventList();
        Composite comp1 = new Composite((Composite)shell, 0);
        comp1.setLayout((Layout)new FillLayout());
        KTable table = new KTable(comp1, 1073939202);
        EventKTableModel tableModel = new EventKTableModel(table, issuesEventList, new IssuesTableFormat());
        table.setModel((KTableModel)tableModel);
        IssueLoader issueLoader = new IssueLoader(issuesEventList, (Throbber)new SimpleThrobber());
        issueLoader.start();
        issueLoader.setProject((Project)Project.getProjects().get(0));
    }

    private static final class IssuesTableFormat
    implements TableFormat {
        private IssuesTableFormat() {
        }

        public int getColumnCount() {
            return 6;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "ID";
                }
                case 1: {
                    return "Type";
                }
                case 2: {
                    return "Priority";
                }
                case 3: {
                    return "State";
                }
                case 4: {
                    return "Result";
                }
                case 5: {
                    return "Summary";
                }
            }
            throw new IllegalStateException();
        }

        public Object getColumnValue(Object baseObject, int column) {
            Issue issue = (Issue)baseObject;
            switch (column) {
                case 0: {
                    return issue.getId();
                }
                case 1: {
                    return issue.getIssueType();
                }
                case 2: {
                    return issue.getPriority();
                }
                case 3: {
                    return issue.getStatus();
                }
                case 4: {
                    return issue.getResolution();
                }
                case 5: {
                    return issue.getShortDescription();
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class SimpleThrobber
    implements Throbber {
        private SimpleThrobber() {
        }

        public void setOn() {
            System.out.println("Throb on");
        }

        public void setOff() {
            System.out.println("Throb off");
        }
    }
}

