/*
 * Decompiled with CFR 0.152.
 */
package net.nikr.dds;

public class PixelFormat {
    public static final int RGB = 64;
    public static final int ALPHAPIXELS = 1;
    public static final int FOURCC = 4;
    public static final int DXT1 = 827611204;
    public static final int DXT2 = 844388420;
    public static final int DXT3 = 861165636;
    public static final int DXT4 = 877942852;
    public static final int DXT5 = 894720068;
    public static final char FORMAT_DXT1 = '\u0001';
    public static final char FORMAT_DXT2 = '\u0002';
    public static final char FORMAT_DXT3 = '\u0003';
    public static final char FORMAT_DXT4 = '\u0004';
    public static final char FORMAT_DXT5 = '\u0005';
    public static final char FORMAT_A8R8G8B8 = '\u0006';
    public static final char FORMAT_R8G8B8 = '\u0007';
    public static final char FORMAT_X8R8G8B8 = '\b';
    private int size;
    private int flags;
    private int fourCC;
    private int rgbBitCount;
    private int rBitMask;
    private int gBitMask;
    private int bBitMask;
    private int rgbAlphaBitMask;

    public PixelFormat(int size, int flags, int fourCC, int rgbBitCount, int rBitMask, int gBitMask, int bBitMask, int rgbAlphaBitMask) {
        this.size = size;
        this.flags = flags;
        this.fourCC = fourCC;
        this.rgbBitCount = rgbBitCount;
        this.rBitMask = rBitMask;
        this.gBitMask = gBitMask;
        this.bBitMask = bBitMask;
        this.rgbAlphaBitMask = rgbAlphaBitMask;
    }

    public int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFourCC() {
        return this.fourCC;
    }

    public int getRgbBitCount() {
        return this.rgbBitCount;
    }

    public int getRedBitMask() {
        return this.rBitMask;
    }

    public int getGreenBitMask() {
        return this.gBitMask;
    }

    public int getBlueBitMask() {
        return this.bBitMask;
    }

    public int getAlphaBitMask() {
        return this.rgbAlphaBitMask;
    }

    public char getFormat() {
        if (this.isA8R8G8B8()) {
            return '\u0006';
        }
        if (this.isR8G8B8()) {
            return '\u0007';
        }
        if (this.isX8R8G8B8()) {
            return '\b';
        }
        if (this.isDXT1()) {
            return '\u0001';
        }
        if (this.isDXT2()) {
            return '\u0002';
        }
        if (this.isDXT3()) {
            return '\u0003';
        }
        if (this.isDXT4()) {
            return '\u0004';
        }
        if (this.isDXT5()) {
            return '\u0005';
        }
        return '\u0000';
    }

    public boolean isCompressed() {
        return (this.flags & 4) != 0;
    }

    public boolean isA8R8G8B8() {
        return this.getRgbBitCount() == 32 && this.getRedBitMask() == 0xFF0000 && this.getGreenBitMask() == 65280 && this.getBlueBitMask() == 255 && this.getAlphaBitMask() == -16777216;
    }

    public boolean isR8G8B8() {
        return this.getRgbBitCount() == 24 && this.getRedBitMask() == 0xFF0000 && this.getGreenBitMask() == 65280 && this.getBlueBitMask() == 255 && this.getAlphaBitMask() == -16777216;
    }

    public boolean isX8R8G8B8() {
        return this.getRgbBitCount() == 24 && this.getRedBitMask() == 0xFF0000 && this.getGreenBitMask() == 65280 && this.getBlueBitMask() == 255 && this.getAlphaBitMask() != -16777216;
    }

    public boolean isDXT1() {
        return this.fourCC == 827611204;
    }

    public boolean isDXT2() {
        return this.fourCC == 844388420;
    }

    public boolean isDXT3() {
        return this.fourCC == 861165636;
    }

    public boolean isDXT4() {
        return this.fourCC == 877942852;
    }

    public boolean isDXT5() {
        return this.fourCC == 894720068;
    }

    public void printValues() {
        this.printValues(0);
    }

    public void printValues(int nSpace) {
        String sSpace = "";
        for (int i = 0; i < nSpace; ++i) {
            sSpace = sSpace + "\t";
        }
        System.out.println(sSpace + "DDPixelFormat: ");
        System.out.println(sSpace + "\tsize: " + this.size);
        System.out.print(sSpace + "\tflags: " + this.flags);
        if ((this.flags & 0x40) != 0) {
            System.out.print(" (RGB)");
        }
        if ((this.flags & 4) != 0) {
            System.out.print(" (FOURCC)");
        }
        if ((this.flags & 1) != 0) {
            System.out.print(" (ALPHAPIXELS)");
        }
        System.out.print("\n");
        System.out.print(sSpace + "\tfourCC: " + this.fourCC);
        switch (this.fourCC) {
            case 827611204: {
                System.out.print(" (DXT1)\n");
                break;
            }
            case 844388420: {
                System.out.print(" (DXT2)\n");
                break;
            }
            case 861165636: {
                System.out.print(" (DXT3)\n");
                break;
            }
            case 877942852: {
                System.out.print(" (DXT4)\n");
                break;
            }
            case 894720068: {
                System.out.print(" (DXT5)\n");
                break;
            }
            default: {
                System.out.print(" (None)\n");
            }
        }
        System.out.println(sSpace + "\trgbBitCount: " + this.rgbBitCount);
        System.out.println(sSpace + "\trBitMask: " + Integer.toHexString(this.rBitMask));
        System.out.println(sSpace + "\tgBitMask: " + Integer.toHexString(this.gBitMask));
        System.out.println(sSpace + "\tbBitMask: " + Integer.toHexString(this.bBitMask));
        System.out.println(sSpace + "\trgbAlphaBitMask: " + Integer.toHexString(this.rgbAlphaBitMask));
        System.out.print(sSpace + "\tFormat: ");
        switch (this.fourCC) {
            case 827611204: {
                System.out.print("DXT1");
                break;
            }
            case 844388420: {
                System.out.print("DXT2");
                break;
            }
            case 861165636: {
                System.out.print("DXT3");
                break;
            }
            case 877942852: {
                System.out.print("DXT4");
                break;
            }
            case 894720068: {
                System.out.print("DXT5");
                break;
            }
            default: {
                System.out.print("RGB");
                if (!this.isA8R8G8B8()) break;
                System.out.print(" (A8R8G8B8)");
            }
        }
        System.out.print("\n");
    }
}

