/*
 * Decompiled with CFR 0.152.
 */
package net.nikr.dds;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import net.nikr.dds.DDSHeader;

public class DDSLineReader {
    private static int[][] alphamap;
    private static final int BANK_RED = 0;
    private static final int BANK_GREEN = 1;
    private static final int BANK_BLUE = 2;
    private static final int BANK_ALPHA = 3;
    private static byte[][][] linesColor;
    private static int lineNumber;
    private static final int LINES_PER_READ = 4;
    private static final int COLORS_PER_READ = 4;

    public DDSLineReader() {
        lineNumber = 0;
    }

    public void readLine(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        switch (ddsHeader.getPixelFormat().getFormat()) {
            case '\u0006': {
                this.readA8R8G8B8(stream, ddsHeader, banks);
                break;
            }
            case '\u0007': {
                throw new IOException("R8G8B8 not supported, yet!");
            }
            case '\b': {
                throw new IOException("X8R8G8B8 not supported, yet!");
            }
            case '\u0002': {
                throw new IOException("DXT2 is not supported, yet!");
            }
            case '\u0004': {
                throw new IOException("DXT4 not supported, yet!");
            }
            case '\u0001': 
            case '\u0003': 
            case '\u0005': {
                this.readDXT(stream, ddsHeader, banks);
                break;
            }
            default: {
                throw new IOException("Not a supported format!");
            }
        }
    }

    private void readA8R8G8B8(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        for (int x = 0; x < ddsHeader.getWidth(); ++x) {
            int arbg = stream.readInt();
            int a = arbg >> 24 & 0xFF;
            int r = arbg >> 16 & 0xFF;
            int g = arbg >> 8 & 0xFF;
            int b = arbg & 0xFF;
            banks[0][x] = (byte)r;
            banks[1][x] = (byte)g;
            banks[2][x] = (byte)b;
            banks[3][x] = (byte)a;
        }
    }

    private void readDXT(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        int x;
        if (lineNumber >= 4) {
            lineNumber = 0;
        }
        if (lineNumber == 0) {
            linesColor = new byte[4][ddsHeader.getWidth()][4];
            for (x = 0; x < ddsHeader.getWidth(); x += 4) {
                if (ddsHeader.getPixelFormat().isDXT3()) {
                    this.decodeDXT3AlphaBlock(stream, ddsHeader, x);
                }
                if (ddsHeader.getPixelFormat().isDXT5()) {
                    this.decodeDXT5AlphaBlock(stream, ddsHeader, x);
                }
                this.decodeColorBlock(stream, ddsHeader, banks, x);
            }
        }
        for (x = 0; x < ddsHeader.getWidth(); ++x) {
            banks[0][x] = linesColor[lineNumber][x][0];
            banks[1][x] = linesColor[lineNumber][x][1];
            banks[2][x] = linesColor[lineNumber][x][2];
            banks[3][x] = linesColor[lineNumber][x][3];
        }
        ++lineNumber;
    }

    private void readDXT1(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        int x;
        if (lineNumber >= 4) {
            lineNumber = 0;
        }
        if (lineNumber == 0) {
            linesColor = new byte[4][ddsHeader.getWidth()][4];
            for (x = 0; x < ddsHeader.getWidth(); x += 4) {
                this.decodeColorBlock(stream, ddsHeader, banks, x);
            }
        }
        for (x = 0; x < ddsHeader.getWidth(); ++x) {
            banks[0][x] = linesColor[lineNumber][x][0];
            banks[1][x] = linesColor[lineNumber][x][1];
            banks[2][x] = linesColor[lineNumber][x][2];
            banks[3][x] = linesColor[lineNumber][x][3];
        }
        ++lineNumber;
    }

    private void readDXT3(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        int x;
        if (lineNumber >= 4) {
            lineNumber = 0;
        }
        if (lineNumber == 0) {
            linesColor = new byte[4][ddsHeader.getWidth()][4];
            for (x = 0; x < ddsHeader.getWidth(); x += 4) {
                this.decodeDXT3AlphaBlock(stream, ddsHeader, x);
                this.decodeColorBlock(stream, ddsHeader, banks, x);
            }
        }
        for (x = 0; x < ddsHeader.getWidth(); ++x) {
            banks[0][x] = linesColor[lineNumber][x][0];
            banks[1][x] = linesColor[lineNumber][x][1];
            banks[2][x] = linesColor[lineNumber][x][2];
            banks[3][x] = linesColor[lineNumber][x][3];
        }
        ++lineNumber;
    }

    private void readDXT5(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks) throws IOException {
        int x;
        if (lineNumber >= 4) {
            lineNumber = 0;
        }
        if (lineNumber == 0) {
            linesColor = new byte[4][ddsHeader.getWidth()][4];
            for (x = 0; x < ddsHeader.getWidth(); x += 4) {
                this.decodeDXT5AlphaBlock(stream, ddsHeader, x);
                this.decodeColorBlock(stream, ddsHeader, banks, x);
            }
        }
        for (x = 0; x < ddsHeader.getWidth(); ++x) {
            banks[0][x] = linesColor[lineNumber][x][0];
            banks[1][x] = linesColor[lineNumber][x][1];
            banks[2][x] = linesColor[lineNumber][x][2];
            banks[3][x] = linesColor[lineNumber][x][3];
        }
        ++lineNumber;
    }

    private void decodeColorBlock(ImageInputStream stream, DDSHeader ddsHeader, byte[][] banks, int x) throws IOException {
        int i;
        int c0lo = stream.readByte() & 0xFF;
        int c0hi = stream.readByte() & 0xFF;
        int c1lo = stream.readByte() & 0xFF;
        int c1hi = stream.readByte() & 0xFF;
        int bits0 = stream.readByte() & 0xFF;
        int bits1 = stream.readByte() & 0xFF;
        int bits2 = stream.readByte() & 0xFF;
        int bits3 = stream.readByte() & 0xFF;
        long bits = bits0 + 256 * (bits1 + 256 * (bits2 + 256 * bits3));
        int color0 = c0lo + c0hi * 256;
        int color1 = c1lo + c1hi * 256;
        int[][] colorsRGBA = new int[4][4];
        colorsRGBA[0] = this.unpackRBG565(color0);
        colorsRGBA[1] = this.unpackRBG565(color1);
        if (color0 > color1) {
            for (i = 0; i < 3; ++i) {
                colorsRGBA[2][i] = (2 * colorsRGBA[0][i] + colorsRGBA[1][i]) / 3;
                colorsRGBA[3][i] = (colorsRGBA[0][i] + 2 * colorsRGBA[1][i]) / 3;
            }
            colorsRGBA[2][3] = 255;
            colorsRGBA[3][3] = 255;
        } else {
            for (i = 0; i < 3; ++i) {
                colorsRGBA[2][i] = (colorsRGBA[0][i] + colorsRGBA[1][i]) / 2;
                colorsRGBA[3][i] = 0;
            }
            colorsRGBA[2][3] = 255;
            colorsRGBA[3][3] = ddsHeader.getPixelFormat().isDXT1() ? 0 : 255;
        }
        i = 0;
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 4; ++xi) {
                byte code = (byte)(bits >> i * 2 & 3L);
                DDSLineReader.linesColor[yi][x + xi][0] = (byte)colorsRGBA[code][0];
                DDSLineReader.linesColor[yi][x + xi][1] = (byte)colorsRGBA[code][1];
                DDSLineReader.linesColor[yi][x + xi][2] = (byte)colorsRGBA[code][2];
                if (ddsHeader.getPixelFormat().isDXT1()) {
                    DDSLineReader.linesColor[yi][x + xi][3] = (byte)colorsRGBA[code][3];
                }
                ++i;
            }
        }
    }

    private void decodeDXT3AlphaBlock(ImageInputStream stream, DDSHeader ddsHeader, int x) throws IOException {
        int y = 0;
        int a0 = stream.readByte() & 0xFF;
        int a1 = stream.readByte() & 0xFF;
        int a2 = stream.readByte() & 0xFF;
        int a3 = stream.readByte() & 0xFF;
        int a4 = stream.readByte() & 0xFF;
        int a5 = stream.readByte() & 0xFF;
        int a6 = stream.readByte() & 0xFF;
        int a7 = stream.readByte() & 0xFF;
        long alpha0 = a0 + 256 * (a1 + 256 * (a2 + 256 * (a3 + 256)));
        long alpha1 = a4 + 256 * (a5 + 256 * (a6 + 256 * a7));
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 4; ++xi) {
                int a;
                byte code = (byte)(4 * (4 * yi + xi));
                if (code >= 32) {
                    code = (byte)(code - 32);
                    a = (int)((alpha1 >> code & 0xFL) * 17L);
                } else {
                    a = (int)((alpha0 >> code & 0xFL) * 17L);
                }
                if (x != 192 || y == 96) {
                    // empty if block
                }
                DDSLineReader.linesColor[yi][x + xi][3] = (byte)a;
            }
        }
    }

    private void decodeDXT5AlphaBlock(ImageInputStream stream, DDSHeader ddsHeader, int x) throws IOException {
        boolean debug = false;
        int[] alpha = new int[8];
        int alpha0 = stream.readByte() & 0xFF;
        int alpha1 = stream.readByte() & 0xFF;
        int bits0 = stream.readByte() & 0xFF;
        int bits1 = stream.readByte() & 0xFF;
        int bits2 = stream.readByte() & 0xFF;
        int bits3 = stream.readByte() & 0xFF;
        int bits4 = stream.readByte() & 0xFF;
        int bits5 = stream.readByte() & 0xFF;
        long[] bits = new long[]{bits0 + 256 * (bits1 + 256 * (bits2 + 256)), bits2 + 256 * (bits3 + 256 * (bits4 + 256)), bits4 + 256 * bits5};
        alpha[0] = alpha0;
        alpha[1] = alpha1;
        if (debug) {
            System.out.println(" bits[0]: " + bits[0] + " (" + Long.toBinaryString(bits[0]) + ")");
            System.out.println(" bits[1]: " + bits[1] + " (" + Long.toBinaryString(bits[1]) + ")");
        }
        if (alpha0 > alpha1) {
            if (debug) {
                System.out.println("alpha0 > alpha1");
            }
            alpha[2] = (6 * alpha[0] + 1 * alpha[1]) / 7;
            alpha[3] = (5 * alpha[0] + 2 * alpha[1]) / 7;
            alpha[4] = (4 * alpha[0] + 3 * alpha[1]) / 7;
            alpha[5] = (3 * alpha[0] + 4 * alpha[1]) / 7;
            alpha[6] = (2 * alpha[0] + 5 * alpha[1]) / 7;
            alpha[7] = (1 * alpha[0] + 6 * alpha[1]) / 7;
        } else {
            if (debug) {
                System.out.println("alpha0 <= alpha1");
            }
            alpha[2] = (4 * alpha[0] + 1 * alpha[1]) / 5;
            alpha[3] = (3 * alpha[0] + 2 * alpha[1]) / 5;
            alpha[4] = (2 * alpha[0] + 3 * alpha[1]) / 5;
            alpha[5] = (1 * alpha[0] + 4 * alpha[1]) / 5;
            alpha[6] = 0;
            alpha[7] = 255;
        }
        for (int yi = 0; yi < 4; ++yi) {
            for (int xi = 0; xi < 4; ++xi) {
                int i = 3 * (4 * yi + xi);
                int bit = 0;
                if (i > 16 && i <= 32) {
                    bit = 1;
                    i -= 16;
                }
                if (i > 32 && i <= 48) {
                    i -= 32;
                    bit = 2;
                }
                byte code = (byte)(bits[bit] >> i & 7L);
                if (debug) {
                    System.out.println("yi: " + yi + " xi: " + xi + " byte: " + i * 3 + " code: " + code + " alpha[code]: " + alpha[code] + " (" + Integer.toBinaryString(alpha[code]) + ")");
                }
                DDSLineReader.linesColor[yi][x + xi][3] = (byte)alpha[code];
            }
        }
    }

    private int[] unpackRBG565(int rbg565) {
        int r = rbg565 >> 11 & 0x1F;
        int g = rbg565 >> 5 & 0x3F;
        int b = rbg565 & 0x1F;
        int[] color = new int[]{(char)(r << 3 | r >> 2), (char)(g << 2 | g >> 4), (char)(b << 3 | b >> 2), 255};
        return color;
    }

    static {
        lineNumber = 0;
    }
}

