/*
 * Decompiled with CFR 0.152.
 */
package net.nikr.dds;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.nikr.dds.DDSImageReader;

public class DDSImageReaderSpi
extends ImageReaderSpi {
    static final int MAGIC = 542327876;

    public DDSImageReaderSpi() {
        super("Niklas K. Rasmussen", "0.0.1 ALPHA 1", new String[]{"DDS"}, new String[]{"dds", "png", "jpg"}, new String[]{"image/dds", "image/png", "image/jpeg"}, "net.nikr.dds.DDSImageReader", STANDARD_INPUT_TYPE, null, false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)source;
        stream.reset();
        stream.mark();
        stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int magic = stream.readInt();
        if (magic != 542327876) {
            return false;
        }
        int size = stream.readInt();
        if (size != 124) {
            return false;
        }
        stream.reset();
        return true;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) throws IOException {
        return new DDSImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "NiKR.net DDS Reader by Niklas K. Rasmussen";
    }
}

