/*
 * Decompiled with CFR 0.152.
 */
package net.nikr.dds;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.nikr.dds.DDSHeader;
import net.nikr.dds.DDSLineReader;
import net.nikr.dds.PixelFormat;

public class DDSImageReader
extends ImageReader {
    private static final int MAGIC = 542327876;
    private static final int bandsCount = 4;
    private DDSHeader ddsHeader = null;
    private ImageInputStream stream;

    public DDSImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        this.setInput(this.input);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input == null) {
            this.stream = null;
            return;
        }
        if (!(input instanceof ImageInputStream)) {
            throw new IllegalArgumentException("ImageInputStream expected!");
        }
        this.stream = (ImageInputStream)input;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        this.readHeader();
        return this.ddsHeader.getMipMapCount();
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        this.readHeader();
        this.checkIndex(imageIndex);
        return this.ddsHeader.getWidth() / (imageIndex + 1);
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        this.readHeader();
        this.checkIndex(imageIndex);
        return this.ddsHeader.getHeight() / (imageIndex + 1);
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IIOException {
        this.readHeader();
        this.checkIndex(imageIndex);
        ImageTypeSpecifier imageType = null;
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        switch (this.ddsHeader.getPixelFormat().getFormat()) {
            case '\u0001': 
            case '\u0003': 
            case '\u0005': 
            case '\u0006': {
                imageType = ImageTypeSpecifier.createFromBufferedImageType(6);
                break;
            }
            default: {
                imageType = ImageTypeSpecifier.createFromBufferedImageType(5);
            }
        }
        l.add(imageType);
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readHeader();
        this.checkIndex(imageIndex);
        DDSLineReader ddsLineReader = new DDSLineReader();
        this.stream.reset();
        this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        Rectangle sourceRegion = DDSImageReader.getSourceRegion(param, this.ddsHeader.getWidth(), this.ddsHeader.getHeight());
        int sourceXSubsampling = 1;
        int sourceYSubsampling = 1;
        int[] sourceBands = null;
        int[] destinationBands = null;
        Point destinationOffset = new Point(0, 0);
        if (param != null) {
            sourceXSubsampling = param.getSourceXSubsampling();
            sourceYSubsampling = param.getSourceYSubsampling();
            sourceBands = param.getSourceBands();
            destinationBands = param.getDestinationBands();
            destinationOffset = param.getDestinationOffset();
        }
        BufferedImage dst = DDSImageReader.getDestination(param, this.getImageTypes(0), this.ddsHeader.getWidth(), this.ddsHeader.getHeight());
        DDSImageReader.checkReadParamBandSettings(param, 4, dst.getSampleModel().getNumBands());
        WritableRaster wrSrc = Raster.createBandedRaster(0, this.ddsHeader.getWidth(), 1, 4, new Point(0, 0));
        byte[][] banks = ((DataBufferByte)wrSrc.getDataBuffer()).getBankData();
        WritableRaster wrDst = dst.getRaster();
        int dstMinX = wrDst.getMinX();
        int dstMaxX = dstMinX + wrDst.getWidth() - 1;
        int dstMinY = wrDst.getMinY();
        int dstMaxY = dstMinY + wrDst.getHeight() - 1;
        if (sourceBands != null) {
            wrSrc = wrSrc.createWritableChild(0, 0, this.ddsHeader.getWidth(), 1, 0, 0, sourceBands);
        }
        if (destinationBands != null) {
            wrDst = wrDst.createWritableChild(0, 0, wrDst.getWidth(), wrDst.getHeight(), 0, 0, destinationBands);
        }
        int srcY = 0;
        try {
            int[] pixel = wrSrc.getPixel(0, 0, (int[])null);
            block2: for (srcY = 0; srcY < this.ddsHeader.getHeight(); ++srcY) {
                int dstY;
                ddsLineReader.readLine(this.stream, this.ddsHeader, banks);
                if (srcY < sourceRegion.y || srcY >= sourceRegion.y + sourceRegion.height || (srcY - sourceRegion.y) % sourceYSubsampling != 0 || (dstY = destinationOffset.y + (srcY - sourceRegion.y) / sourceYSubsampling) < dstMinY) continue;
                if (dstY <= dstMaxY) {
                    for (int srcX = sourceRegion.x; srcX < sourceRegion.x + sourceRegion.width; ++srcX) {
                        int dstX;
                        if ((srcX - sourceRegion.x) % sourceXSubsampling != 0 || (dstX = destinationOffset.x + (srcX - sourceRegion.x) / sourceXSubsampling) < dstMinX) continue;
                        if (dstX > dstMaxX) continue block2;
                        wrSrc.getPixel(srcX, 0, pixel);
                        wrDst.setPixel(dstX, dstY, pixel);
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new IIOException("Error reading line " + srcY + ": " + e.getMessage(), e);
        }
        return dst;
    }

    private void checkIndex(int imageIndex) throws IllegalArgumentException {
        if (imageIndex > this.ddsHeader.getMipMapCount()) {
            throw new IllegalArgumentException("MipMap index not found");
        }
    }

    private void readHeader() throws IIOException {
        if (this.ddsHeader != null) {
            return;
        }
        if (this.stream == null) {
            throw new IIOException("Failed to load header: Stream is Null");
        }
        try {
            this.stream.reset();
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            int magic = this.stream.readInt();
            if (magic != 542327876) {
                throw new IIOException("Failed To Load Header: MAGIC is not MAGIC");
            }
            int size = this.stream.readInt();
            if (size != 124) {
                throw new IIOException("Failed To Load Header: Size value is not right");
            }
            int flags = this.stream.readInt();
            int height = this.stream.readInt();
            int width = this.stream.readInt();
            int linearSize = this.stream.readInt();
            int depth = this.stream.readInt();
            int mipMapCount = this.stream.readInt();
            this.stream.skipBytes(44);
            boolean i = true;
            PixelFormat ddPixelFormat = this.readPixelFormat();
            int caps = this.stream.readInt();
            int caps2 = this.stream.readInt();
            int caps3 = this.stream.readInt();
            int caps4 = this.stream.readInt();
            this.ddsHeader = new DDSHeader(size, flags, height, width, linearSize, depth, mipMapCount, ddPixelFormat, caps, caps2, caps3, caps4);
            i = false;
        }
        catch (IOException ex) {
            throw new IIOException("Failed To Load Header: " + ex.getMessage());
        }
    }

    private PixelFormat readPixelFormat() throws IOException {
        int size = this.stream.readInt();
        if (size != 32) {
            throw new IOException("Failed load PixelFormat: File ill formed");
        }
        int flags = this.stream.readInt();
        int fourCC = this.stream.readInt();
        int rgbBitCount = this.stream.readInt();
        int rBitMask = this.stream.readInt();
        int gBitMask = this.stream.readInt();
        int bBitMask = this.stream.readInt();
        int rgbAlphaBitMask = this.stream.readInt();
        PixelFormat ddPixelFormat = new PixelFormat(size, flags, fourCC, rgbBitCount, rBitMask, gBitMask, bBitMask, rgbAlphaBitMask);
        this.stream.readInt();
        return ddPixelFormat;
    }
}

