/*
 * Decompiled with CFR 0.152.
 */
package net.nikr.dds;

import net.nikr.dds.PixelFormat;

public class DDSHeader {
    public static final int HEIGHT = 2;
    public static final int WIDTH = 4;
    public static final int LINEARSIZE = 524288;
    public static final int DEPTH = 0x800000;
    public static final int MIPMAPCOUNT = 131072;
    public static final int PIXELFORMAT = 4096;
    public static final int CAPS = 1;
    public static final int PITCH = 8;
    private int size;
    private int flags;
    private int height;
    private int width;
    private int pitchOrLinearSize;
    private int depth;
    private int mipMapCount;
    private PixelFormat pixelFormat;
    private int caps;
    private int caps2;
    private int caps3;
    private int caps4;

    public DDSHeader() {
    }

    public DDSHeader(int size, int flags, int height, int width, int linearSize, int depth, int mipMapCount, PixelFormat ddPixelFormat, int caps, int caps2, int caps3, int caps4) {
        this.size = size;
        this.flags = flags;
        this.height = height;
        this.width = width;
        this.pitchOrLinearSize = linearSize;
        this.depth = depth;
        this.mipMapCount = mipMapCount;
        this.pixelFormat = ddPixelFormat;
        this.caps = caps;
        this.caps2 = caps2;
        this.caps3 = caps3;
        this.caps4 = caps4;
    }

    public int getSize() {
        return this.size;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPitchOrLinearSize() {
        return this.pitchOrLinearSize;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getMipMapCount() {
        return this.mipMapCount;
    }

    public void printValues() {
        System.out.println("DDSHeader:");
        System.out.println("\tsize: " + this.size);
        System.out.print("\tflags: " + this.flags);
        if ((this.flags & 2) != 0) {
            System.out.print(" (HEIGHT)");
        }
        if ((this.flags & 4) != 0) {
            System.out.print(" (WIDTH)");
        }
        if ((this.flags & 0x80000) != 0) {
            System.out.print(" (LINEARSIZE)");
        }
        if ((this.flags & 0x800000) != 0) {
            System.out.print(" (DEPTH)");
        }
        if ((this.flags & 0x20000) != 0) {
            System.out.print(" (MIPMAPCOUNT)");
        }
        if ((this.flags & 0x1000) != 0) {
            System.out.print(" (PIXELFORMAT)");
        }
        if ((this.flags & 1) != 0) {
            System.out.print(" (CAPS)");
        }
        if ((this.flags & 8) != 0) {
            System.out.print(" (PITCH)");
        }
        System.out.print("\n");
        System.out.println("\theight: " + this.height);
        System.out.println("\twidth: " + this.width);
        System.out.println("\tlinearSize: " + this.pitchOrLinearSize);
        System.out.println("\tdepth: " + this.depth);
        System.out.println("\tmipMapCount: " + this.mipMapCount);
        this.pixelFormat.printValues(1);
        System.out.println("\tcaps: " + this.caps);
        System.out.println("\tcaps2: " + this.caps2);
        System.out.println("\tcaps3: " + this.caps3);
        System.out.println("\tcaps4: " + this.caps4);
    }

    public PixelFormat getPixelFormat() {
        return this.pixelFormat;
    }
}

