/*
 * Decompiled with CFR 0.152.
 */
package vstrade.shared;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class StatusEtchedBorder
extends AbstractBorder {
    public static final int RAISED = 0;
    public static final int LOWERED = 1;
    protected int etchType;
    protected Color highlight;
    protected Color shadow;
    boolean bTopOnly = false;

    public StatusEtchedBorder() {
        this(1);
    }

    public StatusEtchedBorder(boolean bTopInput) {
        this.bTopOnly = bTopInput;
        this.etchType = 1;
    }

    public StatusEtchedBorder(int etchType) {
        this(etchType, null, null);
    }

    public StatusEtchedBorder(Color highlight, Color shadow) {
        this(1, highlight, shadow);
    }

    public StatusEtchedBorder(int etchType, Color highlight, Color shadow) {
        this.etchType = etchType;
        this.highlight = highlight;
        this.shadow = shadow;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int w = width;
        int h = height;
        g.translate(x, y);
        g.setColor(this.etchType == 1 ? this.getShadowColor(c) : this.getHighlightColor(c));
        if (this.bTopOnly) {
            g.drawLine(0, 0, w, 0);
        } else {
            g.drawLine(0, 0, w, 0);
        }
        g.setColor(this.etchType == 1 ? this.getHighlightColor(c) : this.getShadowColor(c));
        if (this.bTopOnly) {
            g.drawLine(0, 1, w, 1);
        } else {
            g.drawLine(0, 1, w, 1);
        }
        g.translate(-x, -y);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.bTopOnly) {
            return new Insets(2, 0, 0, 0);
        }
        return new Insets(2, 0, 0, 2);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.bottom = 2;
        insets.right = 2;
        insets.top = 2;
        insets.left = 2;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    public int getEtchType() {
        return this.etchType;
    }

    public Color getHighlightColor(Component c) {
        return this.highlight != null ? this.highlight : c.getBackground().brighter();
    }

    public Color getHighlightColor() {
        return this.highlight;
    }

    public Color getShadowColor(Component c) {
        return this.shadow != null ? this.shadow : c.getBackground().darker();
    }

    public Color getShadowColor() {
        return this.shadow;
    }
}

