/*
 * Decompiled with CFR 0.152.
 */
package vstrade.shared;

import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import vstrade.data.Node;
import vstrade.shared.NodeComparator;

public class NodeListModel
extends AbstractListModel {
    Vector<Node> nodes = new Vector();

    public void add(Node node) {
        if (!this.nodes.contains(node)) {
            this.nodes.add(node);
            Collections.sort(this.nodes, new NodeComparator());
            this.fireIntervalAdded(this, this.nodes.indexOf(node), this.nodes.indexOf(node));
        }
    }

    public void clear() {
        if (!this.nodes.isEmpty()) {
            int index = this.nodes.size() - 1;
            this.nodes.clear();
            this.fireIntervalRemoved(this, 0, index);
        }
    }

    public void remove(int index) {
        if (index >= 0 && index < this.nodes.size()) {
            this.nodes.remove(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public Vector<Node> getItems() {
        return new Vector<Node>(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    public int indexOf(Node node) {
        return this.nodes.indexOf(node);
    }

    @Override
    public int getSize() {
        return this.nodes.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.nodes.get(index);
    }

    public Node get(int index) {
        if (index > this.nodes.size() - 1) {
            return null;
        }
        return this.nodes.get(index);
    }

    public Vector<Node> getSelectedNodes(JList jList) {
        if (jList.getModel().equals(this)) {
            int[] indices = jList.getSelectedIndices();
            Vector<Node> nodeVector = new Vector<Node>(indices.length);
            for (int a = 0; a < indices.length; ++a) {
                Node node = this.nodes.get(indices[a]);
                nodeVector.add(node);
            }
            return nodeVector;
        }
        return null;
    }
}

