/*
 * Decompiled with CFR 0.152.
 */
package vstrade.shared;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MultiSelectionList
extends JList
implements MouseListener,
KeyListener,
ListDataListener,
MouseMotionListener {
    private List<Integer> selectedList = new Vector<Integer>();

    public MultiSelectionList() {
        this((ListModel)new DefaultListModel());
    }

    public MultiSelectionList(ListModel model) {
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setDragEnabled(false);
        this.setModel(model);
        this.setSelectionModel(new DefaultListSelectionModel());
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        this.selectedList.clear();
    }

    @Override
    public void setSelectedIndex(int index) {
        super.setSelectedIndex(index);
        this.selectedList.clear();
        this.selectedList.add(index);
    }

    @Override
    public void setSelectedIndices(int[] indices) {
        super.setSelectedIndices(indices);
        this.selectedList.clear();
        for (int a = 0; a < indices.length; ++a) {
            this.selectedList.add(indices[a]);
        }
    }

    @Override
    public void setSelectedValue(Object anObject, boolean shouldScrool) {
        super.setSelectedValue(anObject, shouldScrool);
        this.selectedList.clear();
        this.selectedList.add(this.getSelectedIndex());
    }

    @Override
    public void addSelectionInterval(int anchor, int lead) {
        int end;
        int start;
        super.addSelectionInterval(anchor, lead);
        if (anchor < lead) {
            start = anchor;
            end = lead;
        } else {
            start = lead;
            end = anchor;
        }
        for (int a = start; a <= end; ++a) {
            if (this.selectedList.contains(a)) continue;
            this.selectedList.add(a);
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        int end;
        int start;
        super.removeSelectionInterval(index0, index1);
        if (index0 < index1) {
            start = index0;
            end = index1;
        } else {
            start = index1;
            end = index0;
        }
        for (int a = start; a <= end; ++a) {
            if (this.selectedList.contains(a)) continue;
            this.selectedList.add(a);
        }
    }

    public void setModel(ListModel model) {
        super.setModel(model);
        model.addListDataListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int index = this.locationToIndex(e.getPoint());
        if (e.getButton() == 1) {
            this.toggleSelectedIndex(index);
            e.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 65 && e.getModifiers() == 2) {
            this.selectAll();
        }
        if (e.getKeyCode() == 38) {
            this.setAnchor(this.getAnchorSelectionIndex() - 1);
        }
        if (e.getKeyCode() == 40) {
            this.setAnchor(this.getAnchorSelectionIndex() + 1);
        }
        if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
            int index = this.getAnchorSelectionIndex();
            this.toggleSelectedIndex(index);
        }
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.updateSelections();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        int index1;
        int index0 = e.getIndex0();
        if (index0 == (index1 = e.getIndex1())) {
            this.updateList(index0, 1);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        int index1;
        int index0 = e.getIndex0();
        if (index0 == (index1 = e.getIndex1())) {
            this.selectedList.remove((Object)index0);
            this.updateList(index0, -1);
        } else {
            this.selectedList.clear();
        }
        this.ensureIndexIsVisible(index1);
    }

    public void addSelection(int index, boolean bSelected) {
        Integer indexObj = new Integer(index);
        if (this.selectedList.contains(indexObj) && !bSelected) {
            this.selectedList.remove(indexObj);
        }
        if (!this.selectedList.contains(indexObj) && bSelected) {
            this.selectedList.add(indexObj);
        }
        this.updateSelections();
        this.setAnchor(index);
    }

    private void updateList(int index, int fix) {
        Vector<Integer> fixedIndices = new Vector<Integer>(this.selectedList.size());
        for (int a = 0; a < this.selectedList.size(); ++a) {
            int item = this.selectedList.get(a);
            if (item >= index) {
                fixedIndices.add(item += fix);
                continue;
            }
            fixedIndices.add(item);
        }
        this.selectedList = fixedIndices;
    }

    private void setAnchor(int nAnchor) {
        ListSelectionModel sm = this.getSelectionModel();
        ListModel lm = this.getModel();
        if (nAnchor >= 0 && nAnchor < lm.getSize()) {
            if (this.isSelectedIndex(nAnchor)) {
                sm.removeSelectionInterval(nAnchor, nAnchor);
                sm.addSelectionInterval(nAnchor, nAnchor);
            } else {
                sm.addSelectionInterval(nAnchor, nAnchor);
                sm.removeSelectionInterval(nAnchor, nAnchor);
            }
            this.ensureIndexIsVisible(nAnchor);
        }
    }

    private void toggleSelectedIndex(int index) {
        Integer indexObj = new Integer(index);
        if (this.selectedList.contains(indexObj)) {
            this.selectedList.remove(indexObj);
        } else {
            this.selectedList.add(indexObj);
        }
        this.updateSelections();
        this.setAnchor(index);
    }

    private void updateSelections() {
        int[] arr = new int[this.selectedList.size()];
        for (int i = 0; i < arr.length; ++i) {
            int item;
            arr[i] = item = this.selectedList.get(i).intValue();
        }
        this.setSelectedIndices(arr);
    }

    private void selectAll() {
        ListModel lm = this.getModel();
        int size = this.selectedList.size();
        this.selectedList.clear();
        if (size != lm.getSize()) {
            Integer a = 0;
            while (a < lm.getSize()) {
                this.selectedList.add(a);
                Integer n = a;
                Integer n2 = a = Integer.valueOf(a + 1);
            }
        }
        this.updateSelections();
        this.setAnchor(0);
    }
}

