/*
 * Decompiled with CFR 0.152.
 */
package vstrade.shared;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import vstrade.shared.KeyAction;

public class KeyActionTimer
implements ActionListener {
    private final String ACTION_START = "Start";
    private final String ACTION_END = "End";
    private Timer timer;
    private ActionListener actionListener;
    private String actionCommand;
    private JComponent jComponent;
    private int keyCode;
    private String start;
    private String end;

    public KeyActionTimer(ActionListener actionListener, String actionCommand, JComponent jComponent, int keyCode) {
        this.actionCommand = actionCommand;
        this.actionListener = actionListener;
        this.jComponent = jComponent;
        this.keyCode = keyCode;
        this.start = actionCommand + "Start";
        this.end = actionCommand + "End";
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, 0), this.start);
        jComponent.getActionMap().put(this.start, new KeyAction(this, this.start));
        jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, 0, true), this.end);
        jComponent.getActionMap().put(this.end, new KeyAction(this, this.end));
        this.timer = new Timer(10, this);
        this.timer.setActionCommand(actionCommand);
        this.timer.setInitialDelay(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.start.equals(e.getActionCommand())) {
            this.jComponent.getInputMap(1).remove(KeyStroke.getKeyStroke(this.keyCode, 0));
            this.timer.start();
        }
        if (this.end.equals(e.getActionCommand())) {
            this.jComponent.getInputMap(1).put(KeyStroke.getKeyStroke(this.keyCode, 0), this.start);
            this.timer.stop();
        }
        if (this.actionCommand.equals(e.getActionCommand())) {
            this.actionListener.actionPerformed(e);
        }
    }
}

