/*
 * Decompiled with CFR 0.152.
 */
package vstrade.shared;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.TitledBorder;
import vstrade.shared.MultiSelectionList;

public class GUIFactory {
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_SMALL_WIDTH = 44;
    private static final int SPACE_Y = 5;
    private static final int SPACE_X = 10;
    private static final int FIELD_MINIMUM_LENGTH = 250;
    public static final int FIELD_WIDTH = 250;
    public static final int FIELD_HEIGTH = 25;
    public static final int FIELD_WIDTH_AND_BUTTON = 406;
    public static final int FIELD_WIDTH_X2 = 515;
    public static final int FIELD_WIDTH_X3 = 780;
    private static final int SPACE_BUTTON_Y = 5;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;

    private GUIFactory() {
    }

    public static JPanel jPRow(JComponent ... jComponents) {
        return GUIFactory.jPCostum(jComponents, 2, false, false, 0, 0, true, false, null);
    }

    public static JPanel jPColumn(JComponent ... jComponents) {
        return GUIFactory.jPCostum(jComponents, 3, false, false, 0, 0, false, false, null);
    }

    public static JPanel jPDimension(Dimension dimension, JComponent ... jComponents) {
        return GUIFactory.jPCostum(jComponents, 3, false, false, 0, 0, false, false, dimension);
    }

    public static JPanel jPTitle(JComponent jComponent) {
        return GUIFactory.jPTitle(2, jComponent);
    }

    public static JPanel jPTitle(int nAxis, JComponent ... jComponents) {
        JPanel jPanel = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("[NOT TRASNLATED]");
        Insets insets = titledBorder.getBorderInsets(jPanel);
        Dimension d = titledBorder.getMinimumSize(jPanel);
        int x = insets.left + insets.right;
        int y = (int)d.getHeight();
        jPanel = GUIFactory.jPCostum(jComponents, nAxis, true, false, x, y, false, false, null);
        jPanel.setBorder(titledBorder);
        return jPanel;
    }

    public static JPanel jPButton(JComponent ... jComponents) {
        return GUIFactory.jPCostum(jComponents, 2, false, true, 0, 0, false, false, null);
    }

    private static JPanel jPCostum(JComponent[] jComponents, int nAxis, boolean bSpace, boolean bCustomSpace, int xOffset, int yOffset, boolean xMax, boolean yMax, Dimension d) {
        Dimension temp;
        int a;
        int y = 0;
        int x = 0;
        int xCustomSpace = 0;
        int yCustomSpace = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, nAxis));
        if (bCustomSpace && jComponents.length > 1) {
            for (a = 0; a < jComponents.length; ++a) {
                temp = jComponents[a].getPreferredSize();
                if (nAxis == 3) {
                    yCustomSpace += temp.height;
                }
                if (nAxis != 2) continue;
                xCustomSpace += temp.width;
            }
            xCustomSpace = (250 - xCustomSpace) / (jComponents.length - 1);
        }
        for (a = 0; a < jComponents.length; ++a) {
            temp = jComponents[a].getPreferredSize();
            if (nAxis == 3) {
                y += temp.height;
                if (bSpace && a > 0) {
                    jPanel.add(Box.createRigidArea(new Dimension(250, 5)));
                    y += 5;
                }
                if (bCustomSpace && a > 0) {
                    jPanel.add(Box.createRigidArea(new Dimension(250, yCustomSpace)));
                    y += yCustomSpace;
                }
            } else if (temp.height > y) {
                y = temp.height;
            }
            if (nAxis == 2) {
                x += temp.width;
                if (bSpace && a > 0) {
                    jPanel.add(Box.createRigidArea(new Dimension(10, 25)));
                    x += 10;
                }
                if (bCustomSpace && a > 0) {
                    jPanel.add(Box.createRigidArea(new Dimension(xCustomSpace, 25)));
                    x += xCustomSpace;
                }
            } else if (temp.width > x) {
                x = temp.width;
            }
            jPanel.add(jComponents[a]);
        }
        x += xOffset;
        y += yOffset;
        if (xMax) {
            x = Short.MAX_VALUE;
        }
        if (yMax) {
            y = Short.MAX_VALUE;
        }
        if (d == null) {
            d = new Dimension(x, y);
        }
        jPanel.setPreferredSize(d);
        jPanel.setMaximumSize(d);
        return jPanel;
    }

    public static JScrollPane jScrollPanel(JComponent jComponent, int y) {
        JScrollPane jScrollPanel = new JScrollPane(jComponent);
        jScrollPanel.setPreferredSize(new Dimension(250, 25 * y));
        jScrollPanel.setMinimumSize(new Dimension(250, 25 * y));
        return jScrollPanel;
    }

    private static JScrollPane jScrollPanel(JComponent jComponent, int x, int y) {
        JScrollPane jScrollPanel = new JScrollPane(jComponent);
        jScrollPanel.setPreferredSize(new Dimension(250 * x, 25 * y));
        jScrollPanel.setMinimumSize(new Dimension(250 * x, 25 * y));
        return jScrollPanel;
    }

    public static JPanel jPRadioButton(JRadioButton jRadioButton, JLabel jLabel) {
        return GUIFactory.jPCheckRadioBox(jRadioButton, jLabel);
    }

    public static JPanel jPCheckBox(JCheckBox jCheckBox, JLabel jLabel) {
        return GUIFactory.jPCheckRadioBox(jCheckBox, jLabel);
    }

    private static JPanel jPCheckRadioBox(JComponent jComponent, JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.add(jComponent);
        jPanel.add(jLabel);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setMaximumSize(new Dimension(250, 25));
        jPanel.setPreferredSize(new Dimension(250, 25));
        jPanel.setMinimumSize(new Dimension(250, 25));
        return jPanel;
    }

    public static JLabel jLabel(MouseListener mouseListener) {
        return GUIFactory.jLabel(0, mouseListener);
    }

    private static JLabel jLabel(int x, MouseListener mouseListener) {
        JLabel jLabel = new JLabel();
        jLabel.addMouseListener(mouseListener);
        if (x > 0) {
            jLabel.setPreferredSize(new Dimension(250 * x, 25));
            jLabel.setMinimumSize(new Dimension(250 * x, 25));
        }
        return jLabel;
    }

    public static JTextField jTextField(KeyListener textListener) {
        JTextField jTextField = new JTextField();
        jTextField.addKeyListener(textListener);
        jTextField.setPreferredSize(new Dimension(250, 25));
        jTextField.setMinimumSize(new Dimension(250, 25));
        return jTextField;
    }

    public static JComboBox jComboBox() {
        return GUIFactory.jComboBox(null, null, "", null, null);
    }

    public static JComboBox jComboBox(ActionListener actionListener, String sActionCommand) {
        return GUIFactory.jComboBox(null, actionListener, sActionCommand, null, null);
    }

    public static JComboBox jComboBox(ActionListener actionListener, String sActionCommand, KeyListener keyListener) {
        return GUIFactory.jComboBox(null, actionListener, sActionCommand, keyListener, null);
    }

    public static JComboBox jComboBox(Object[] array, ActionListener actionListener, String sActionCommand) {
        return GUIFactory.jComboBox(array, actionListener, sActionCommand, null, null);
    }

    public static JComboBox jComboBoxSmall(ActionListener actionListener, String sActionCommand) {
        return GUIFactory.jComboBoxSmall(actionListener, sActionCommand, null);
    }

    public static JComboBox jComboBoxSmall(ActionListener actionListener, String sActionCommand, KeyListener keyListener) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setPreferredSize(new Dimension(196, 25));
        jComboBox.setMinimumSize(new Dimension(191, 25));
        jComboBox.setActionCommand(sActionCommand);
        jComboBox.addActionListener(actionListener);
        jComboBox.addKeyListener(keyListener);
        return jComboBox;
    }

    private static JComboBox jComboBox(Object[] array, ActionListener actionListener, String sActionCommand, KeyListener keyListener, MouseListener mouseListener) {
        JComboBox<Object> jComboBox = array != null ? new JComboBox<Object>(array) : new JComboBox();
        jComboBox.setMaximumSize(new Dimension(250, 25));
        jComboBox.setPreferredSize(new Dimension(250, 25));
        jComboBox.setMinimumSize(new Dimension(250, 25));
        jComboBox.setActionCommand(sActionCommand);
        jComboBox.addActionListener(actionListener);
        jComboBox.addKeyListener(keyListener);
        jComboBox.addMouseListener(mouseListener);
        return jComboBox;
    }

    public static JCheckBox jCheckBox() {
        return GUIFactory.jCheckBox(null, "");
    }

    public static JCheckBox jCheckBox(ActionListener actionListener, String sActionCommand) {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setActionCommand(sActionCommand);
        jCheckBox.addActionListener(actionListener);
        return jCheckBox;
    }

    public static JRadioButton jRadioButton() {
        return GUIFactory.jRadioButton(null, "");
    }

    public static JRadioButton jRadioButton(ActionListener actionListener, String sActionCommand) {
        JRadioButton jRadioButton = new JRadioButton();
        jRadioButton.setActionCommand(sActionCommand);
        jRadioButton.addActionListener(actionListener);
        return jRadioButton;
    }

    public static MultiSelectionList jMultiSelectionList() {
        return GUIFactory.jMultiSelectionList(null, null, null, null);
    }

    public static MultiSelectionList jMultiSelectionList(String[] data) {
        return GUIFactory.jMultiSelectionList(data, null, null, null);
    }

    public static MultiSelectionList jMultiSelectionList(ListModel listModel, KeyListener keyListener, MouseListener mouseListener) {
        return GUIFactory.jMultiSelectionList(null, listModel, keyListener, mouseListener);
    }

    private static MultiSelectionList jMultiSelectionList(String[] data, ListModel listModel, KeyListener keyListener, MouseListener mouseListener) {
        MultiSelectionList multiSelectionList = new MultiSelectionList();
        if (keyListener != null) {
            multiSelectionList.addKeyListener(keyListener);
        }
        if (mouseListener != null) {
            multiSelectionList.addMouseListener(mouseListener);
        }
        if (listModel != null) {
            multiSelectionList.setModel(listModel);
        }
        if (data != null) {
            multiSelectionList.setListData(data);
        }
        return multiSelectionList;
    }

    public static JButton jButton(ActionListener actionListener, String sActionCommand) {
        JButton jButton = new JButton();
        jButton.setMaximumSize(new Dimension(100, 25));
        jButton.setPreferredSize(new Dimension(100, 25));
        jButton.setMinimumSize(new Dimension(100, 25));
        jButton.setActionCommand(sActionCommand);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static JButton jButtonSmall(ActionListener actionListener, String sActionCommand) {
        JButton jButton = new JButton();
        jButton.setMaximumSize(new Dimension(44, 25));
        jButton.setPreferredSize(new Dimension(44, 25));
        jButton.setMinimumSize(new Dimension(44, 25));
        jButton.setActionCommand(sActionCommand);
        jButton.addActionListener(actionListener);
        return jButton;
    }

    public static void setBorderTitle(JPanel jPanel, String sTitle) {
        ((TitledBorder)jPanel.getBorder()).setTitle(sTitle);
    }
}

