/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.trade;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.moduls.trade.TradeSearch;
import vstrade.moduls.trade.TradeTable;
import vstrade.moduls.trade.TradeTableFormat;
import vstrade.moduls.trade.TradeTablePopupMenu;
import vstrade.moduls.trade.TradeTableRow;
import vstrade.shared.GUIFactory;
import vstrade.shared.IntegerKeyListener;
import vstrade.shared.ModuleView;
import vstrade.shared.MultiSelectionList;
import vstrade.shared.NodeListModel;

public class TradeView
extends ModuleView
implements ActionListener,
MouseListener,
KeyListener {
    private final String ACTION_SEARCH = "FindBaseToBase";
    private final String ACTION_CLEAR = "ClearBasesTable";
    private final String ACTION_BUY_TYPE = "basesFromType";
    private final String ACTION_BUY_ADD = "AddBuyBase";
    private final String ACTION_SELL_TYPE = "basesToType";
    private final String ACTION_SELL_ADD = "AddSellBase";
    private final String ACTION_SYNC = "SyncBases";
    private final String ACTION_BUY_ADD_SELECTED = "AddSelectedToSellBase";
    private final String ACTION_BUY_ADD_ALL = "AddAllToSellBase";
    private final String ACTION_BUY_CLEAR_LIST = "ClearBuyList";
    private final String ACTION_SELL_ADD_SELECTED = "AddSelectedToBuyBase";
    private final String ACTION_SELL_ADD_ALL = "AddAllToBuyBase";
    private final String ACTION_SELL_CLEAR_LIST = "ClearSellList";
    private final String ACTION_BUY_SELECT_ALL = "SelectBuyList";
    private final String ACTION_BUY_DESELECT_ALL = "DeselectBuyList";
    private final String ACTION_SELL_SELECT_ALL = "SelectSellList";
    private final String ACTION_SELL_DESELECT_ALL = "DeselectSellList";
    private JButton jBuyAddSelected;
    private JButton jBuyAddAll;
    private JButton jBuyClear;
    private JCheckBox jBuySync;
    private JPanel jBuyTPanel;
    private MultiSelectionList jBuyBases;
    private NodeListModel jBuyBasesModel;
    private JButton jBuySelectAll;
    private JButton jBuyDeselectAll;
    private JComboBox jBuyType;
    private JComboBox jBuyAdd;
    private JButton jBuyAddButton;
    private JButton jSellAddSelected;
    private JButton jSellAddAll;
    private JButton jSellClear;
    private JPanel jSellTPanel;
    private MultiSelectionList jSellBases;
    private NodeListModel jSellBasesModel;
    private JButton jSellSelectAll;
    private JButton jSellDeselectAll;
    private JComboBox jSellType;
    private JComboBox jSellAdd;
    private JButton jSellAddButton;
    private JTextField jPercentProfit;
    private JPanel jPercentProfitTPanel;
    private JTextField jCashProfit;
    private JPanel jCashProfitTPanel;
    private JCheckBox jRisk;
    private JLabel jRiskLabel;
    private JLabel jBestTradeLabel;
    private JRadioButton jBestTrade;
    private JLabel jNormalSearchLabel;
    private JRadioButton jNormalSearch;
    private JLabel jBestCargoTradeLabel;
    private JRadioButton jBestCargoTrade;
    private JPanel jSwitchTPanel;
    private JButton jClear;
    private JButton jSearch;
    private JPanel jSearchTPanel;
    private JTable jTable;
    private TradeTableFormat tradeTableFormat;
    private EventTableModel<TradeTableRow> tradeTableModel;
    private EventList<TradeTableRow> tradeEventList;
    private SortedList<TradeTableRow> tradeSortedList;
    TradeTablePopupMenu jTradeTablePopupMenu;
    private IntegerKeyListener textListener;
    private String sAlt;
    private Program program;

    public TradeView(Program program) {
        this.program = program;
        this.textListener = new IntegerKeyListener();
        this.jTradeTablePopupMenu = new TradeTablePopupMenu(program, this);
        this.jBuySelectAll = GUIFactory.jButtonSmall(this, "SelectBuyList");
        this.jBuyDeselectAll = GUIFactory.jButtonSmall(this, "DeselectBuyList");
        this.jBuyAddSelected = GUIFactory.jButtonSmall(this, "AddSelectedToSellBase");
        this.jBuyAddAll = GUIFactory.jButtonSmall(this, "AddAllToSellBase");
        this.jBuyClear = GUIFactory.jButtonSmall(this, "ClearBuyList");
        this.jBuySync = GUIFactory.jCheckBox(this, "SyncBases");
        JPanel jBuyButtonPanel = GUIFactory.jPButton(this.jBuySelectAll, this.jBuyDeselectAll, this.jBuyAddSelected, this.jBuyAddAll, this.jBuyClear, this.jBuySync);
        this.jBuyBasesModel = new NodeListModel();
        this.jBuyBases = GUIFactory.jMultiSelectionList(this.jBuyBasesModel, this, this);
        this.jBuyType = GUIFactory.jComboBox(this, "basesFromType");
        this.jBuyAdd = GUIFactory.jComboBoxSmall(null, "", this);
        this.jBuyAddButton = GUIFactory.jButtonSmall(this, "AddBuyBase");
        JPanel jBuyAddPanel = GUIFactory.jPButton(this.jBuyAdd, this.jBuyAddButton);
        this.jBuyTPanel = GUIFactory.jPTitle(3, jBuyButtonPanel, GUIFactory.jScrollPanel(this.jBuyBases, 4), this.jBuyType, jBuyAddPanel);
        this.jSellSelectAll = GUIFactory.jButtonSmall(this, "SelectSellList");
        this.jSellDeselectAll = GUIFactory.jButtonSmall(this, "DeselectSellList");
        this.jSellAddSelected = GUIFactory.jButtonSmall(this, "AddSelectedToBuyBase");
        this.jSellAddAll = GUIFactory.jButtonSmall(this, "AddAllToBuyBase");
        this.jSellClear = GUIFactory.jButtonSmall(this, "ClearSellList");
        JPanel jSellButtonPanel = GUIFactory.jPButton(this.jSellSelectAll, this.jSellDeselectAll, this.jSellAddSelected, this.jSellAddAll, this.jSellClear);
        this.jSellBasesModel = new NodeListModel();
        this.jSellBases = GUIFactory.jMultiSelectionList(this.jSellBasesModel, this, this);
        this.jSellType = GUIFactory.jComboBox(this, "basesToType");
        this.jSellAdd = GUIFactory.jComboBoxSmall(null, "AddSellBase", this);
        this.jSellAddButton = GUIFactory.jButtonSmall(this, "AddSellBase");
        JPanel jSellAddPanel = GUIFactory.jPButton(this.jSellAdd, this.jSellAddButton);
        this.jSellTPanel = GUIFactory.jPTitle(3, jSellButtonPanel, GUIFactory.jScrollPanel(this.jSellBases, 4), this.jSellType, jSellAddPanel);
        JPanel jbasesRPanel = GUIFactory.jPRow(this.jBuyTPanel, this.jSellTPanel);
        this.jRiskLabel = GUIFactory.jLabel(this);
        this.jRisk = GUIFactory.jCheckBox();
        this.jNormalSearchLabel = GUIFactory.jLabel(this);
        this.jNormalSearch = GUIFactory.jRadioButton();
        this.jNormalSearch.setSelected(true);
        this.jBestTradeLabel = GUIFactory.jLabel(this);
        this.jBestTrade = GUIFactory.jRadioButton();
        this.jBestCargoTradeLabel = GUIFactory.jLabel(this);
        this.jBestCargoTrade = GUIFactory.jRadioButton();
        ButtonGroup group = new ButtonGroup();
        group.add(this.jNormalSearch);
        group.add(this.jBestTrade);
        group.add(this.jBestCargoTrade);
        this.jSwitchTPanel = GUIFactory.jPTitle(3, GUIFactory.jPCheckBox(this.jRisk, this.jRiskLabel), GUIFactory.jPRadioButton(this.jNormalSearch, this.jNormalSearchLabel), GUIFactory.jPRadioButton(this.jBestTrade, this.jBestTradeLabel), GUIFactory.jPRadioButton(this.jBestCargoTrade, this.jBestCargoTradeLabel));
        this.jPercentProfit = GUIFactory.jTextField(this.textListener);
        this.jPercentProfitTPanel = GUIFactory.jPTitle(this.jPercentProfit);
        this.jCashProfit = GUIFactory.jTextField(this.textListener);
        this.jCashProfitTPanel = GUIFactory.jPTitle(this.jCashProfit);
        this.jClear = GUIFactory.jButton(this, "ClearBasesTable");
        this.jSearch = GUIFactory.jButton(this, "FindBaseToBase");
        JPanel jSearchBPanel = GUIFactory.jPButton(this.jClear, this.jSearch);
        this.jSearchTPanel = GUIFactory.jPTitle(2, jSearchBPanel);
        JPanel jSearchCPanel = GUIFactory.jPColumn(this.jPercentProfitTPanel, this.jCashProfitTPanel, this.jSearchTPanel);
        JPanel jActionRPanel = GUIFactory.jPRow(this.jSwitchTPanel, jSearchCPanel);
        this.tradeEventList = new BasicEventList<TradeTableRow>();
        this.tradeSortedList = new SortedList<TradeTableRow>(this.tradeEventList);
        this.tradeTableFormat = new TradeTableFormat(program);
        this.tradeTableModel = new EventTableModel<TradeTableRow>(this.tradeSortedList, this.tradeTableFormat);
        this.jTable = new TradeTable(this.tradeTableModel, this.tradeSortedList);
        this.jTable.addMouseListener(this);
        this.jTable.addMouseListener(program);
        TableComparatorChooser<TradeTableRow> tableSorter = new TableComparatorChooser<TradeTableRow>(this.jTable, this.tradeSortedList, true);
        JScrollPane jTableSPanel = new JScrollPane(this.jTable);
        jTableSPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createEtchedBorder(1)));
        JPanel jInputPanel = new JPanel();
        jInputPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jInputPanel.setLayout(new BoxLayout(jInputPanel, 3));
        jInputPanel.add(jbasesRPanel);
        jInputPanel.add(jActionRPanel);
        JSplitPane jPanel = new JSplitPane(0, jInputPanel, jTableSPanel);
        jPanel.setBorder(null);
        jPanel.setOneTouchExpandable(true);
        jPanel.setEnabled(false);
        jPanel.setDividerSize(10);
        this.setLayout(new BoxLayout(this, 3));
        this.add(jPanel);
    }

    @Override
    public void setData() {
        this.updateLanguage();
        boolean bEnabled = this.program.getBases().isLoaded();
        if (bEnabled) {
            this.jBuyType.setModel(new DefaultComboBoxModel<String>(this.getTypeList()));
            this.jBuyAdd.setModel(new DefaultComboBoxModel<Node>(this.getBaseList()));
            this.jSellType.setModel(new DefaultComboBoxModel<String>(this.getTypeList()));
            this.jSellAdd.setModel(new DefaultComboBoxModel<Node>(this.getBaseList()));
        }
        this.jBuySync.setEnabled(bEnabled);
        this.jBuyAddSelected.setEnabled(bEnabled);
        this.jBuyAddAll.setEnabled(bEnabled);
        this.jBuyClear.setEnabled(bEnabled);
        this.jBuyBases.setEnabled(bEnabled);
        this.jBuySelectAll.setEnabled(bEnabled);
        this.jBuyDeselectAll.setEnabled(bEnabled);
        this.jBuyType.setEnabled(bEnabled);
        this.jBuyAdd.setEnabled(bEnabled);
        this.jBuyAddButton.setEnabled(bEnabled);
        this.jSellAddSelected.setEnabled(bEnabled);
        this.jSellAddAll.setEnabled(bEnabled);
        this.jSellClear.setEnabled(bEnabled);
        this.jSellBases.setEnabled(bEnabled);
        this.jSellSelectAll.setEnabled(bEnabled);
        this.jSellDeselectAll.setEnabled(bEnabled);
        this.jSellBasesModel.clear();
        this.jSellAddButton.setEnabled(bEnabled);
        this.jSellType.setEnabled(bEnabled);
        this.jSellAdd.setEnabled(bEnabled);
        this.jCashProfit.setEnabled(bEnabled);
        this.jPercentProfit.setEnabled(bEnabled);
        this.jRisk.setEnabled(bEnabled);
        this.jRiskLabel.setEnabled(bEnabled);
        this.jNormalSearchLabel.setEnabled(bEnabled);
        this.jNormalSearch.setEnabled(bEnabled);
        this.jBestTradeLabel.setEnabled(bEnabled);
        this.jBestTrade.setEnabled(bEnabled);
        this.jBestCargoTradeLabel.setEnabled(bEnabled);
        this.jBestCargoTrade.setEnabled(bEnabled);
        this.jSearch.setEnabled(bEnabled);
        this.jClear.setEnabled(bEnabled);
    }

    @Override
    public void clearData() {
        String[] arrBases = new String[]{this.program.getSettings().getLanguageSettings().getString("NoBases", "trade")};
        String[] arrTypes = new String[]{this.program.getSettings().getLanguageSettings().getString("NoTypes", "trade")};
        this.jBuyType.setModel(new DefaultComboBoxModel<String>(arrTypes));
        this.jBuyAdd.setModel(new DefaultComboBoxModel<String>(arrBases));
        this.jBuyBasesModel.clear();
        this.jSellType.setModel(new DefaultComboBoxModel<String>(arrTypes));
        this.jSellAdd.setModel(new DefaultComboBoxModel<String>(arrBases));
        this.jSellBasesModel.clear();
        this.tradeEventList.getReadWriteLock().writeLock().lock();
        this.tradeEventList.clear();
        this.tradeEventList.getReadWriteLock().writeLock().unlock();
        this.program.getStatusView().setTradeResults("-");
    }

    @Override
    public void updateLanguage() {
        this.sAlt = this.program.getSettings().getLanguageSettings().getString("All", "trade");
        this.sTitle = this.program.getSettings().getLanguageSettings().getString("Title", "trade");
        this.jBuyAddSelected.setText("\u203a");
        this.jBuyAddSelected.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyAddSelectedTT", "trade"));
        this.jBuyAddAll.setText("\u203a\u203a");
        this.jBuyAddAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyAddAllTT", "trade"));
        this.jBuyClear.setText("!");
        this.jBuyClear.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyClearListTT", "trade"));
        this.jBuySync.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SyncLists", "trade"));
        this.jBuySelectAll.setText("+");
        this.jBuySelectAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuySelectAllTT", "trade"));
        this.jBuyDeselectAll.setText("-");
        this.jBuyDeselectAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyDeselectAllTT", "trade"));
        this.jBuyBases.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyBasesTT", "trade"));
        this.jBuyType.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyTypeTT", "trade"));
        this.jBuyAdd.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyAddTT", "trade"));
        this.jBuyAddButton.setText(this.program.getSettings().getLanguageSettings().getString("BuyAddButton", "trade"));
        this.jBuyAddButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BuyAddButtonTT", "trade"));
        GUIFactory.setBorderTitle(this.jBuyTPanel, this.program.getSettings().getLanguageSettings().getString("BuyBase", "trade"));
        this.jSellSelectAll.setText("+");
        this.jSellSelectAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellSelectAllTT", "trade"));
        this.jSellDeselectAll.setText("-");
        this.jSellDeselectAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellDeselectAllTT", "trade"));
        this.jSellAddSelected.setText("\u2039");
        this.jSellAddSelected.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellAddSelectedTT", "trade"));
        this.jSellAddAll.setText("\u2039\u2039");
        this.jSellAddAll.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellAddAllTT", "trade"));
        this.jSellClear.setText("!");
        this.jSellClear.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellClearListTT", "trade"));
        this.jSellBases.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellBasesTT", "trade"));
        this.jSellType.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellTypeTT", "trade"));
        this.jSellAdd.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellAddTT", "trade"));
        this.jSellAddButton.setText(this.program.getSettings().getLanguageSettings().getString("SellAddButton", "trade"));
        this.jSellAddButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SellAddButtonTT", "trade"));
        GUIFactory.setBorderTitle(this.jSellTPanel, this.program.getSettings().getLanguageSettings().getString("SellBase", "trade"));
        this.jPercentProfit.setToolTipText(this.program.getSettings().getLanguageSettings().getString("MinPercentProfitTT", "trade"));
        GUIFactory.setBorderTitle(this.jPercentProfitTPanel, this.program.getSettings().getLanguageSettings().getString("MinPercentProfit", "trade"));
        this.jCashProfit.setToolTipText(this.program.getSettings().getLanguageSettings().getString("MinCashProfitTT", "trade"));
        GUIFactory.setBorderTitle(this.jCashProfitTPanel, this.program.getSettings().getLanguageSettings().getString("MinCashProfit", "trade"));
        this.jRiskLabel.setText(this.program.getSettings().getLanguageSettings().getString("RiskTaker", "trade"));
        this.jRiskLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("RiskTakerTT", "trade"));
        this.jRisk.setToolTipText(this.program.getSettings().getLanguageSettings().getString("RiskTakerTT", "trade"));
        this.jNormalSearchLabel.setText(this.program.getSettings().getLanguageSettings().getString("NormalSearch", "trade"));
        this.jNormalSearchLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("NormalSearchTT", "trade"));
        this.jNormalSearch.setToolTipText(this.program.getSettings().getLanguageSettings().getString("NormalSearchTT", "trade"));
        this.jBestTradeLabel.setText(this.program.getSettings().getLanguageSettings().getString("BestTrade", "trade"));
        this.jBestTradeLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BestTradeTT", "trade"));
        this.jBestTrade.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BestTradeTT", "trade"));
        this.jBestCargoTradeLabel.setText(this.program.getSettings().getLanguageSettings().getString("BestCargoTrade", "trade"));
        this.jBestCargoTradeLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BestCargoTradeTT", "trade"));
        this.jBestCargoTrade.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BestCargoTradeTT", "trade"));
        GUIFactory.setBorderTitle(this.jSwitchTPanel, this.program.getSettings().getLanguageSettings().getString("Switches", "trade"));
        this.jClear.setText(this.program.getSettings().getLanguageSettings().getString("Clear", "trade"));
        this.jClear.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ClearTT", "trade"));
        this.jSearch.setText(this.program.getSettings().getLanguageSettings().getString("Search", "trade"));
        this.jSearch.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SearchTT", "trade"));
        GUIFactory.setBorderTitle(this.jSearchTPanel, this.program.getSettings().getLanguageSettings().getString("Search", "trade"));
        this.jTradeTablePopupMenu.updateLanguage();
        this.tradeTableModel.fireTableStructureChanged();
    }

    public void selectAllBuy() {
        if (!this.jBuyBasesModel.isEmpty()) {
            int[] indices = new int[this.jBuyBasesModel.size()];
            for (int index = 0; index < indices.length; ++index) {
                indices[index] = index;
            }
            this.jBuyBases.setSelectedIndices(indices);
        }
    }

    public void deselectAllBuy() {
        if (!this.jBuyBasesModel.isEmpty()) {
            this.jBuyBases.clearSelection();
        }
    }

    public void selectAllSell() {
        if (!this.jSellBasesModel.isEmpty()) {
            int[] indices = new int[this.jSellBasesModel.size()];
            for (int index = 0; index < indices.length; ++index) {
                indices[index] = index;
            }
            this.jSellBases.setSelectedIndices(indices);
        }
    }

    public void deselectAllSell() {
        if (!this.jSellBasesModel.isEmpty()) {
            this.jSellBases.clearSelection();
        }
    }

    public void addBuyBase(Base base) {
        this.jBuyBasesModel.add(base);
        this.jBuyBases.addSelection(this.jBuyBasesModel.indexOf(base), true);
    }

    public void addSellBase(Base base) {
        this.jSellBasesModel.add(base);
        this.jSellBases.addSelection(this.jSellBasesModel.indexOf(base), true);
    }

    public Cargo getSelectedCargo() {
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        TradeTableRow tradeTableRow = this.tradeTableModel.getElementAt(row);
        Cargo cargo = tradeTableRow.getCargo();
        return cargo;
    }

    public Base getSelectedBuyBase() {
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        TradeTableRow tradeTableRow = this.tradeTableModel.getElementAt(row);
        Base base = tradeTableRow.getBuyBase();
        return base;
    }

    public Base getSelectedSellBase() {
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        TradeTableRow tradeTableRow = this.tradeTableModel.getElementAt(row);
        Base base = tradeTableRow.getSellBase();
        return base;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Base node;
        TradeTableRow row;
        Vector<Node> basesList;
        String sType;
        if ("basesFromType".equals(e.getActionCommand())) {
            sType = (String)this.jBuyType.getSelectedItem();
            basesList = sType.equals(this.getAll()) ? this.getBaseList() : this.getBaseList(sType);
            this.jBuyAdd.setModel(new DefaultComboBoxModel<Node>(basesList));
        }
        if ("AddBuyBase".equals(e.getActionCommand())) {
            this.addBaseToList(this.jBuyAdd, this.jBuyType, this.jBuyBases, this.jBuyBasesModel);
            if (this.jBuySync.isSelected()) {
                this.addBaseToList(this.jBuyAdd, this.jBuyType, this.jSellBases, this.jSellBasesModel);
            }
        }
        if ("AddSelectedToSellBase".equals(e.getActionCommand())) {
            this.addSelectedToList(this.jBuyBases, this.jBuyBasesModel, this.jSellBases, this.jSellBasesModel);
        }
        if ("AddAllToSellBase".equals(e.getActionCommand())) {
            this.addAllToList(this.jBuyBases, this.jBuyBasesModel, this.jSellBases, this.jSellBasesModel);
        }
        if ("ClearBuyList".equals(e.getActionCommand())) {
            this.jBuyBasesModel.clear();
            if (this.jBuySync.isSelected()) {
                this.jSellBasesModel.clear();
            }
        }
        if ("basesToType".equals(e.getActionCommand())) {
            sType = (String)this.jSellType.getSelectedItem();
            basesList = sType.equals(this.getAll()) ? this.getBaseList() : this.getBaseList(sType);
            this.jSellAdd.setModel(new DefaultComboBoxModel<Node>(basesList));
        }
        if ("AddSellBase".equals(e.getActionCommand()) && e.getModifiers() > 0) {
            this.addBaseToList(this.jSellAdd, this.jSellType, this.jSellBases, this.jSellBasesModel);
        }
        if ("AddSelectedToBuyBase".equals(e.getActionCommand())) {
            this.addSelectedToList(this.jSellBases, this.jSellBasesModel, this.jBuyBases, this.jBuyBasesModel);
        }
        if ("AddAllToBuyBase".equals(e.getActionCommand())) {
            this.addAllToList(this.jSellBases, this.jSellBasesModel, this.jBuyBases, this.jBuyBasesModel);
        }
        if ("ClearSellList".equals(e.getActionCommand())) {
            this.jSellBasesModel.clear();
        }
        if ("SyncBases".equals(e.getActionCommand())) {
            boolean bSynkSelected = this.jBuySync.isSelected();
            this.jSellType.setEnabled(!bSynkSelected);
            this.jSellAdd.setEnabled(!bSynkSelected);
            this.jBuyAddSelected.setEnabled(!bSynkSelected);
            this.jBuyAddAll.setEnabled(!bSynkSelected);
            this.jSellAddSelected.setEnabled(!bSynkSelected);
            this.jSellAddAll.setEnabled(!bSynkSelected);
            this.jSellClear.setEnabled(!bSynkSelected);
            this.jSellAddButton.setEnabled(!bSynkSelected);
            if (bSynkSelected) {
                this.addAllToList(this.jBuyBases, this.jBuyBasesModel, this.jSellBases, this.jSellBasesModel);
                this.addAllToList(this.jSellBases, this.jSellBasesModel, this.jBuyBases, this.jBuyBasesModel);
            }
        }
        if ("SelectBuyList".equals(e.getActionCommand())) {
            this.selectAllBuy();
        }
        if ("DeselectBuyList".equals(e.getActionCommand())) {
            this.deselectAllBuy();
        }
        if ("SelectSellList".equals(e.getActionCommand())) {
            this.selectAllSell();
        }
        if ("DeselectSellList".equals(e.getActionCommand())) {
            this.deselectAllSell();
        }
        if ("ClearBasesTable".equals(e.getActionCommand())) {
            this.tradeEventList.getReadWriteLock().writeLock().lock();
            this.tradeEventList.clear();
            this.tradeEventList.getReadWriteLock().writeLock().unlock();
            this.program.getStatusView().setTradeResults("-");
        }
        if ("FindBaseToBase".equals(e.getActionCommand())) {
            this.search();
        }
        if (this.jTradeTablePopupMenu.ACTION_TRADE_ADD_BUY_TO_BUY.equals(e.getActionCommand())) {
            int i = this.jTable.getSelectedRow();
            row = (TradeTableRow)this.tradeSortedList.get(i);
            node = row.getBuyBase();
            this.jBuyBasesModel.add(node);
            this.jBuyBases.addSelection(this.jBuyBasesModel.indexOf(node), true);
        }
        if (this.jTradeTablePopupMenu.ACTION_TRADE_ADD_BUY_TO_SELL.equals(e.getActionCommand())) {
            int i = this.jTable.getSelectedRow();
            row = (TradeTableRow)this.tradeSortedList.get(i);
            node = row.getBuyBase();
            this.jSellBasesModel.add(node);
            this.jSellBases.addSelection(this.jSellBasesModel.indexOf(node), true);
        }
        if (this.jTradeTablePopupMenu.ACTION_TRADE_ADD_SELL_TO_SELL.equals(e.getActionCommand())) {
            int i = this.jTable.getSelectedRow();
            row = (TradeTableRow)this.tradeSortedList.get(i);
            node = row.getSellBase();
            this.jSellBasesModel.add(node);
            this.jSellBases.addSelection(this.jSellBasesModel.indexOf(node), true);
        }
        if (this.jTradeTablePopupMenu.ACTION_TRADE_ADD_SELL_TO_BUY.equals(e.getActionCommand())) {
            int i = this.jTable.getSelectedRow();
            row = (TradeTableRow)this.tradeSortedList.get(i);
            node = row.getSellBase();
            this.jBuyBasesModel.add(node);
            this.jBuyBases.addSelection(this.jBuyBasesModel.indexOf(node), true);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.jBuyBases) && e.getButton() == 3) {
            int index = this.jBuyBases.locationToIndex(e.getPoint());
            this.jBuyBasesModel.remove(index);
            if (this.jBuySync.isSelected()) {
                this.jSellBasesModel.remove(index);
            }
        }
        if (e.getSource().equals(this.jSellBases) && e.getButton() == 3 && !this.jBuySync.isSelected()) {
            this.jSellBasesModel.remove(this.jSellBases.locationToIndex(e.getPoint()));
        }
        if (e.getSource().equals(this.jRiskLabel) && this.jRiskLabel.isEnabled()) {
            this.jRisk.setSelected(!this.jRisk.isSelected());
        }
        if (e.getSource().equals(this.jNormalSearchLabel) && this.jNormalSearchLabel.isEnabled() && !this.jNormalSearch.isSelected()) {
            this.jNormalSearch.setSelected(true);
        }
        if (e.getSource().equals(this.jBestTradeLabel) && this.jBestTradeLabel.isEnabled() && !this.jBestTrade.isSelected()) {
            this.jBestTrade.setSelected(true);
        }
        if (e.getSource().equals(this.jBestCargoTradeLabel) && this.jBestCargoTradeLabel.isEnabled() && !this.jBestCargoTrade.isSelected()) {
            this.jBestCargoTrade.setSelected(true);
        }
        if (e.getSource().equals(this.jTable) && e.getButton() == 3) {
            int i = this.jTable.rowAtPoint(e.getPoint());
            this.jTable.setRowSelectionInterval(i, i);
            this.jTradeTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource().equals(this.jSellAdd) && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.addBaseToList(this.jSellAdd, this.jSellType, this.jSellBases, this.jSellBasesModel);
        }
        if (e.getSource().equals(this.jSellBases) && e.getKeyCode() == 127) {
            this.jSellBasesModel.remove(this.jSellBases.getAnchorSelectionIndex());
        }
        if (e.getSource().equals(this.jBuyAdd) && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.addBaseToList(this.jBuyAdd, this.jBuyType, this.jBuyBases, this.jBuyBasesModel);
            if (this.jBuySync.isSelected()) {
                this.addBaseToList(this.jBuyAdd, this.jBuyType, this.jSellBases, this.jSellBasesModel);
            }
        }
        if (e.getSource().equals(this.jBuyBases) && e.getKeyCode() == 127) {
            this.jBuyBasesModel.remove(this.jBuyBases.getAnchorSelectionIndex());
            if (this.jBuySync.isSelected()) {
                this.jSellBasesModel.remove(this.jBuyBases.getAnchorSelectionIndex());
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private void search() {
        Integer nCashProfit;
        Integer nPercentProfit;
        if (this.jBuyBasesModel.isEmpty()) {
            return;
        }
        Vector<Node> buyBases = this.jBuyBasesModel.getSelectedNodes(this.jBuyBases);
        if (this.jSellBasesModel.isEmpty()) {
            return;
        }
        Vector<Node> sellBases = this.jSellBasesModel.getSelectedNodes(this.jSellBases);
        boolean bRisk = this.jRisk.isSelected();
        boolean bBestTrade = this.jBestTrade.isSelected();
        boolean bBestCargoTrade = this.jBestCargoTrade.isSelected();
        String sPercentProfit = this.jPercentProfit.getText();
        try {
            nPercentProfit = Integer.valueOf(sPercentProfit);
        }
        catch (NumberFormatException ex) {
            nPercentProfit = 0;
        }
        String sCashProfit = this.jCashProfit.getText();
        try {
            nCashProfit = Integer.valueOf(sCashProfit);
        }
        catch (NumberFormatException ex) {
            nCashProfit = 0;
        }
        TradeSearch tradeSearch = new TradeSearch(this.program, this.jClear, this.jSearch, this.tradeEventList, buyBases, sellBases, nPercentProfit, nCashProfit, bRisk, bBestTrade, bBestCargoTrade);
        tradeSearch.start();
    }

    private void addBaseToList(JComboBox addCombo, JComboBox typeCombo, MultiSelectionList list, NodeListModel listModel) {
        Node node = (Node)addCombo.getSelectedItem();
        if (node.getName().contains(this.sAlt)) {
            Vector<Node> nodes = node.getName().equals(this.getAll()) ? this.getBaseList() : this.getBaseList((String)typeCombo.getSelectedItem());
            for (int a = 0; a < nodes.size(); ++a) {
                node = nodes.get(a);
                listModel.add(node);
                list.addSelection(listModel.indexOf(node), true);
            }
        } else if (!listModel.contains(node)) {
            listModel.add(node);
            list.addSelection(listModel.indexOf(node), true);
        }
    }

    private void addAllToList(MultiSelectionList fromList, NodeListModel fromListModel, MultiSelectionList toList, NodeListModel toListModel) {
        Vector<Node> nodeList = fromListModel.getItems();
        for (int a = 0; a < nodeList.size(); ++a) {
            Node node = nodeList.get(a);
            boolean bSelected = fromList.isSelectedIndex(a);
            if (toListModel.contains(node)) continue;
            toListModel.add(node);
            toList.addSelection(toListModel.indexOf(node), bSelected);
        }
    }

    private void addSelectedToList(MultiSelectionList fromList, NodeListModel fromListModel, MultiSelectionList toList, NodeListModel toListModel) {
        Vector<Node> nodeList = fromListModel.getItems();
        for (int a = 0; a < nodeList.size(); ++a) {
            Node node = nodeList.get(a);
            if (toListModel.contains(node) || !fromList.isSelectedIndex(a)) continue;
            toListModel.add(node);
            toList.addSelection(toListModel.indexOf(node), true);
        }
    }

    private Vector<String> getTypeList() {
        Vector<String> typeVector = this.program.getBases().getTypeList();
        typeVector.add(0, this.getAll());
        return typeVector;
    }

    private Vector<Node> getBaseList() {
        Vector<Node> baseVector = this.program.getBases().getBaseList();
        baseVector.add(0, new Base(this.getAll(), ""));
        return baseVector;
    }

    private Vector<Node> getBaseList(String sType) {
        Vector<Node> baseVector = this.program.getBases().getBaseList(sType);
        baseVector.add(0, new Base(this.getAllType(sType), ""));
        return baseVector;
    }

    private String getAll() {
        return "[" + this.sAlt + "]";
    }

    private String getAllType(String sType) {
        return "[" + this.sAlt + " " + sType + "]";
    }
}

