/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.trade;

import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;

public class TradeTableRow
implements Comparable<TradeTableRow> {
    private Base buyBase = null;
    private Cargo buyCargo = null;
    private Base sellBase = null;
    private Cargo sellCargo = null;
    private String sBuyBaseName;
    private String sSellBaseName;
    private String sCargoName;
    private int nQuantityMax;
    private int nQuantityAvg;
    private int nQuantityMin;
    private float nCargoVolume;
    private int nPercentProfitMax;
    private int nPercentProfitAvg;
    private int nPercentProfitMin;
    private int nCashProfitMax;
    private int nCashProfitAvg;
    private int nCashProfitMin;

    public TradeTableRow(Base buyBase, Cargo buyCargo, Base sellBase, Cargo sellCargo, boolean bUpgrade) {
        this.buyBase = buyBase;
        this.buyCargo = buyCargo;
        this.sellBase = sellBase;
        this.sellCargo = sellCargo;
        this.sBuyBaseName = buyBase.getName();
        this.sCargoName = buyCargo.getName();
        this.sSellBaseName = sellBase.getName();
        this.nQuantityMax = buyCargo.getQuantityMaximum();
        this.nQuantityAvg = buyCargo.getQuantityAverage();
        this.nQuantityMin = buyCargo.getQuantityMinimum();
        this.nCargoVolume = buyCargo.getCargoVolume();
        this.nPercentProfitMax = Cargo.calcPercentProfitMax(buyCargo, sellCargo, bUpgrade);
        this.nPercentProfitAvg = Cargo.calcPercentProfitAvg(buyCargo, sellCargo, bUpgrade);
        this.nPercentProfitMin = Cargo.calcPercentProfitMin(buyCargo, sellCargo, bUpgrade);
        this.nCashProfitMax = Cargo.calcCashProfitMax(buyCargo, sellCargo, bUpgrade);
        this.nCashProfitAvg = Cargo.calcCashProfitAvg(buyCargo, sellCargo, bUpgrade);
        this.nCashProfitMin = Cargo.calcCashProfitMin(buyCargo, sellCargo, bUpgrade);
    }

    public Base getBuyBase() {
        return this.buyBase;
    }

    public Base getSellBase() {
        return this.sellBase;
    }

    public Cargo getCargo() {
        return this.buyCargo;
    }

    public String getBuyBaseName() {
        return this.sBuyBaseName;
    }

    public String getSellBaseName() {
        return this.sSellBaseName;
    }

    public String getCargoName() {
        return this.sCargoName;
    }

    public int getQuantityMax() {
        return this.nQuantityMax;
    }

    public int getQuantityAvg() {
        return this.nQuantityAvg;
    }

    public int getQuantityMin() {
        return this.nQuantityMin;
    }

    public float getCargoVolume() {
        return this.nCargoVolume;
    }

    public int getPercentProfitMax() {
        return this.nPercentProfitMax;
    }

    public int getPercentProfitAvg() {
        return this.nPercentProfitAvg;
    }

    public int getPercentProfitMin() {
        return this.nPercentProfitMin;
    }

    public int getCashProfitMax() {
        return this.nCashProfitMax;
    }

    public int getCashProfitAvg() {
        return this.nCashProfitAvg;
    }

    public int getCashProfitMin() {
        return this.nCashProfitMin;
    }

    @Override
    public int compareTo(TradeTableRow o) {
        return o.getBuyBase().getName().compareTo(this.getBuyBase().getName());
    }
}

