/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.trade;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;
import vstrade.Program;
import vstrade.moduls.trade.TradeTableRow;
import vstrade.shared.FloatComparator;
import vstrade.shared.IntegerComparator;
import vstrade.shared.StringComparator;

public class TradeTableFormat
implements AdvancedTableFormat<TradeTableRow> {
    private Comparator integerComparator;
    private Comparator stringComparator;
    private Comparator floatComparator;
    private Program program;

    public TradeTableFormat(Program program) {
        this.program = program;
        this.integerComparator = new IntegerComparator();
        this.stringComparator = new StringComparator();
        this.floatComparator = new FloatComparator();
    }

    @Override
    public int getColumnCount() {
        return this.program.getSettings().getTradeSettings().getTradeTableColumns().size();
    }

    @Override
    public String getColumnName(int i) {
        return this.program.getSettings().getLanguageSettings().getString(this.program.getSettings().getTradeSettings().getTradeTableColumn(i), "trade");
    }

    @Override
    public Object getColumnValue(TradeTableRow row, int i) {
        String sColumn = this.program.getSettings().getTradeSettings().getTradeTableColumn(i);
        if (sColumn.equals("TableBuyBase")) {
            return row.getBuyBaseName();
        }
        if (sColumn.equals("TableSellBase")) {
            return row.getSellBaseName();
        }
        if (sColumn.equals("TableCommerce")) {
            return row.getCargoName();
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return row.getQuantityMax();
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return row.getQuantityAvg();
        }
        if (sColumn.equals("TableMinQuantity")) {
            return row.getQuantityMin();
        }
        if (sColumn.equals("TableVolume")) {
            return Float.valueOf(row.getCargoVolume());
        }
        if (sColumn.equals("TableMaxPercent")) {
            return row.getPercentProfitMax();
        }
        if (sColumn.equals("TableAvgPercent")) {
            return row.getPercentProfitAvg();
        }
        if (sColumn.equals("TableMinPercent")) {
            return row.getPercentProfitMin();
        }
        if (sColumn.equals("TableMaxCash")) {
            return row.getCashProfitMax();
        }
        if (sColumn.equals("TableAvgCash")) {
            return row.getCashProfitAvg();
        }
        if (sColumn.equals("TableMinCash")) {
            return row.getCashProfitMin();
        }
        return new String();
    }

    @Override
    public Class getColumnClass(int i) {
        String sColumn = this.program.getSettings().getTradeSettings().getTradeTableColumn(i);
        if (sColumn.equals("TableBuyBase")) {
            return String.class;
        }
        if (sColumn.equals("TableSellBase")) {
            return String.class;
        }
        if (sColumn.equals("TableCommerce")) {
            return String.class;
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMinQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableVolume")) {
            return Float.class;
        }
        if (sColumn.equals("TableMaxPercent")) {
            return Integer.class;
        }
        if (sColumn.equals("TableAvgPercent")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMinPercent")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMaxCash")) {
            return Integer.class;
        }
        if (sColumn.equals("TableAvgCash")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMinCash")) {
            return Integer.class;
        }
        return Object.class;
    }

    @Override
    public Comparator getColumnComparator(int i) {
        String sColumn = this.program.getSettings().getTradeSettings().getTradeTableColumn(i);
        if (sColumn.equals("TableBuyBase")) {
            return this.stringComparator;
        }
        if (sColumn.equals("TableSellBase")) {
            return this.stringComparator;
        }
        if (sColumn.equals("TableCommerce")) {
            return this.stringComparator;
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMinQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableVolume")) {
            return this.floatComparator;
        }
        if (sColumn.equals("TableMaxPercent")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableAvgPercent")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMinPercent")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMaxCash")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableAvgCash")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMinCash")) {
            return this.integerComparator;
        }
        return null;
    }
}

