/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.trade;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.io.Log;
import vstrade.moduls.trade.TradeTableRow;

public class TradeSearch
extends Thread {
    public static final String BUY_CARGO = "BuyCargo";
    public static final String SELL_CARGO = "SellCargo";
    public static final String BUY_BASE = "BuyBase";
    public static final String SELL_BASE = "SellBase";
    private final int MIN_QUANTITY = 1;
    private Vector<Node> buyBases;
    private Vector<Node> sellBases;
    private Base buyBase;
    private Base sellBase;
    private int nMinimumPercentProfit;
    private int nMinimumCashProfit;
    private boolean bUpgrade;
    private boolean bRisk;
    private boolean bBestTrade;
    private boolean bBestCargoTrade;
    private List<TradeTableRow> result;
    private JButton jClear;
    private JButton jSearch;
    private Program program;
    private EventList<TradeTableRow> tradeEventList;

    public TradeSearch(Program program, JButton jClear, JButton jSearch, EventList<TradeTableRow> tradeEventList, Vector<Node> buyBases, Vector<Node> sellBases, int nMinimumPercentProfit, int nMinimumCashProfit, boolean bRisk, boolean bBestTrade, boolean bBestCargoTrade) {
        this.program = program;
        this.jClear = jClear;
        this.jSearch = jSearch;
        this.tradeEventList = tradeEventList;
        this.buyBases = buyBases;
        this.sellBases = sellBases;
        this.nMinimumPercentProfit = nMinimumPercentProfit;
        this.nMinimumCashProfit = nMinimumCashProfit;
        this.bRisk = bRisk;
        this.bBestTrade = bBestTrade;
        this.bBestCargoTrade = bBestCargoTrade;
        this.setName("TradeSearch");
    }

    @Override
    public void run() {
        this.jClear.setEnabled(false);
        this.jSearch.setEnabled(false);
        this.result = new Vector<TradeTableRow>();
        int aMax = this.buyBases.size();
        int bMax = this.sellBases.size();
        for (int a = 0; a < this.buyBases.size(); ++a) {
            this.buyBase = (Base)this.buyBases.get(a);
            for (int b = 0; b < this.sellBases.size(); ++b) {
                this.program.getStatusView().setTradeSearchProgress(this.calcProgress(aMax, bMax, a, b));
                this.sellBase = (Base)this.sellBases.get(b);
                this.deepSearch(this.buyBase, this.sellBase);
            }
        }
        if (this.bBestCargoTrade) {
            this.bestCargoTrade();
        } else if (this.bBestTrade) {
            this.bestTrade();
        }
        this.program.getStatusView().setTradeResults(this.result.size());
        this.tradeEventList.getReadWriteLock().writeLock().lock();
        this.tradeEventList.clear();
        if (this.result.size() > 0) {
            this.tradeEventList.addAll(this.result);
        }
        this.tradeEventList.getReadWriteLock().writeLock().unlock();
        this.jClear.setEnabled(true);
        this.jSearch.setEnabled(true);
        this.program.getStatusView().setTradeSearchProgress(100);
    }

    private void deepSearch(Node buyNode, Node sellNode) {
        Vector<Node> buyNodes = buyNode.getValues();
        Vector<Node> sellNodes = sellNode.getValues();
        for (int a = 0; a < buyNodes.size() && a < sellNodes.size(); ++a) {
            Node buy = buyNodes.get(a);
            Node sell = sellNodes.get(a);
            if (buy.getParent() instanceof Base && buy.getName().equals("upgrades")) {
                this.bUpgrade = true;
            }
            if (buy.getParent() instanceof Base && !buy.getName().equals("upgrades")) {
                this.bUpgrade = false;
            }
            if (buy instanceof Cargo && sell instanceof Cargo) {
                this.compare((Cargo)buy, (Cargo)sell);
                continue;
            }
            this.deepSearch(buy, sell);
        }
    }

    private void compare(Cargo buyCargo, Cargo sellCargo) {
        if (!buyCargo.getName().equals(sellCargo.getName())) {
            Log.error(this.getClass() + ".compare() :: Search out of sync (Buy: " + buyCargo.getName() + " Sell: " + sellCargo.getName());
        }
        int nBuyPriceAvg = buyCargo.getPriceAverage();
        int nBuyQuantityAvg = buyCargo.getQuantityAverage();
        int nSellPriceAvg = sellCargo.getPriceAverage();
        if (nBuyPriceAvg > 0 && nSellPriceAvg > 0) {
            int nPercentProfitAvg = Cargo.calcPercentProfitAvg(buyCargo, sellCargo, this.bUpgrade);
            int nCashProfitAvg = Cargo.calcCashProfitAvg(buyCargo, sellCargo, this.bUpgrade);
            int nCashProfitMin = Cargo.calcCashProfitMin(buyCargo, sellCargo, this.bUpgrade);
            if (nBuyQuantityAvg >= 1 && nPercentProfitAvg >= this.nMinimumPercentProfit && nCashProfitAvg >= this.nMinimumCashProfit && (nCashProfitMin > 0 || this.bRisk && nCashProfitAvg != 0)) {
                this.addResult(buyCargo, sellCargo);
            }
        }
    }

    private void addResult(Cargo buyCargo, Cargo sellCargo) {
        this.result.add(new TradeTableRow(this.buyBase, buyCargo, this.sellBase, sellCargo, this.bUpgrade));
    }

    private int calcProgress(int aMax, int bMax, int a, int b) {
        float area = aMax * bMax;
        int progress = (int)((float)(a * bMax + b) / area * 100.0f);
        return progress;
    }

    private void bestTrade() {
        Base lastBase = new Base("", "");
        TradeTableRow bestPercentRow = null;
        TradeTableRow bestCashRow = null;
        Vector<TradeTableRow> bestTradeResult = new Vector<TradeTableRow>();
        for (int a = 0; a < this.result.size(); ++a) {
            TradeTableRow currentRow = this.result.get(a);
            Base currentBase = currentRow.getBuyBase();
            if (lastBase.equals(currentBase)) {
                if (currentRow.getPercentProfitAvg() > bestPercentRow.getPercentProfitAvg()) {
                    bestTradeResult.remove(bestPercentRow);
                    bestTradeResult.add(currentRow);
                    bestPercentRow = currentRow;
                }
                if (currentRow.getCashProfitAvg() > bestPercentRow.getCashProfitAvg()) {
                    bestTradeResult.remove(bestCashRow);
                    bestTradeResult.add(currentRow);
                    bestCashRow = currentRow;
                }
            } else {
                bestTradeResult.add(currentRow);
                bestPercentRow = currentRow;
                bestCashRow = currentRow;
            }
            lastBase = currentBase;
        }
        this.result = bestTradeResult;
    }

    private void bestCargoTrade() {
        HashMap<String, ArrayList<TradeTableRow>> bestPercentRows = new HashMap<String, ArrayList<TradeTableRow>>();
        HashMap<String, ArrayList<TradeTableRow>> bestCashRows = new HashMap<String, ArrayList<TradeTableRow>>();
        for (int a = 0; a < this.result.size(); ++a) {
            TradeTableRow currentRow = this.result.get(a);
            Cargo currentCargo = currentRow.getCargo();
            String currentName = currentCargo.getName();
            List bestPercentRow = (List)bestPercentRows.get(currentName);
            if (bestPercentRow == null || currentRow.getPercentProfitAvg() > ((TradeTableRow)bestPercentRow.get(0)).getPercentProfitAvg()) {
                bestPercentRows.put(currentName, new ArrayList<TradeTableRow>(Collections.singleton(currentRow)));
            } else if (currentRow.getPercentProfitAvg() == ((TradeTableRow)bestPercentRow.get(0)).getPercentProfitAvg()) {
                bestPercentRow.add(currentRow);
            }
            List bestCashRow = (List)bestCashRows.get(currentName);
            if (bestCashRow == null || currentRow.getCashProfitAvg() > ((TradeTableRow)bestCashRow.get(0)).getCashProfitAvg()) {
                bestCashRows.put(currentName, new ArrayList<TradeTableRow>(Collections.singleton(currentRow)));
                continue;
            }
            if (currentRow.getCashProfitAvg() != ((TradeTableRow)bestCashRow.get(0)).getCashProfitAvg()) continue;
            bestCashRow.add(currentRow);
        }
        Set rows = Collections.newSetFromMap(new IdentityHashMap());
        for (List bestRows : bestPercentRows.values()) {
            rows.addAll(bestRows);
        }
        for (List bestRows : bestCashRows.values()) {
            rows.addAll(bestRows);
        }
        this.result = new Vector(rows);
    }
}

