/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.status;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import vstrade.Program;
import vstrade.shared.ModuleView;
import vstrade.shared.StatusEtchedBorder;

public class StatusView
extends ModuleView
implements ActionListener {
    private final int STATUS_HEIGHT = 25;
    private JLabel jTradeResult;
    private JLabel jPriceResult;
    private JLabel jInfo;
    private JProgressBar jTradeSearch;
    private JPanel jTradeSearchPanel;
    private JProgressBar jPriceSearch;
    private JPanel jPriceSearchPanel;
    private JProgressBar jSettingsSave;
    private JPanel jSettingsSavePanel;
    private Timer jTradeTimer;
    private Timer jPriceTimer;
    private Timer jSettingsTimer;
    private CompoundBorder jFieldBorder;
    private Program program;

    public StatusView(Program program) {
        this.program = program;
        StatusEtchedBorder jStatusBorder = new StatusEtchedBorder();
        this.jFieldBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, jStatusBorder.getShadowColor(this)), BorderFactory.createMatteBorder(0, 1, 0, 0, jStatusBorder.getHighlightColor(this)));
        this.jTradeTimer = new Timer(500, this);
        this.jPriceTimer = new Timer(500, this);
        this.jSettingsTimer = new Timer(500, this);
        this.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.setBorder(jStatusBorder);
        this.setLayout(new BoxLayout(this, 2));
        this.jInfo = new JLabel();
        this.jInfo.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.jInfo.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        this.jInfo.setMinimumSize(new Dimension(5, 25));
        this.jInfo.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jSettingsSave = this.createProgress();
        this.jSettingsSavePanel = this.createProgressPanel(this.jSettingsSave);
        this.jTradeSearch = this.createProgress();
        this.jTradeSearchPanel = this.createProgressPanel(this.jTradeSearch);
        this.jTradeResult = this.createResult();
        this.jPriceSearch = this.createProgress();
        this.jPriceSearchPanel = this.createProgressPanel(this.jPriceSearch);
        this.jPriceResult = this.createResult();
        this.add(this.jInfo);
        this.add(this.jTradeSearchPanel);
        this.add(this.jPriceSearchPanel);
        this.add(this.jSettingsSavePanel);
        this.add(this.jTradeResult);
        this.add(this.jPriceResult);
    }

    @Override
    public void setData() {
        this.updateLanguage();
    }

    @Override
    public void clearData() {
    }

    @Override
    public void updateLanguage() {
        this.jSettingsSave.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SettingsSaveProgress", "status"));
        this.jTradeSearch.setToolTipText(this.program.getSettings().getLanguageSettings().getString("TradeSearchProgress", "status"));
        this.jTradeResult.setToolTipText(this.program.getSettings().getLanguageSettings().getString("TradeResults", "status"));
        this.jPriceSearch.setToolTipText(this.program.getSettings().getLanguageSettings().getString("PriceSearchProgress", "status"));
        this.jPriceResult.setToolTipText(this.program.getSettings().getLanguageSettings().getString("PriceResults", "status"));
    }

    public void setStatusbarText(String sText) {
        this.jInfo.setText(sText);
    }

    public void setTradeResults(int nResults) {
        this.setTradeResults(String.valueOf(nResults));
    }

    public void setTradeResults(String sResults) {
        this.jTradeResult.setText(sResults);
    }

    public void setPriceResults(int nResults) {
        this.setPriceResults(String.valueOf(nResults));
    }

    public void setPriceResults(String sResults) {
        this.jPriceResult.setText(sResults);
    }

    public void setTradeSearchProgress(int nProgress) {
        if (nProgress >= 100) {
            this.jTradeTimer.start();
        } else {
            if (!this.jTradeSearchPanel.isVisible()) {
                this.jTradeSearchPanel.setVisible(true);
            }
            if (nProgress < 0) {
                nProgress = 0;
            }
            this.jTradeSearch.setValue(nProgress);
        }
    }

    public void setPriceSearchProgress(int nProgress) {
        if (nProgress >= 100) {
            this.jPriceTimer.start();
        } else {
            if (!this.jPriceSearchPanel.isVisible()) {
                this.jPriceSearchPanel.setVisible(true);
            }
            if (nProgress < 0) {
                nProgress = 0;
            }
            this.jPriceSearch.setValue(nProgress);
        }
    }

    public void setSettingsSaveProgress(int nProgress) {
        if (nProgress >= 100) {
            this.jSettingsTimer.start();
        } else {
            if (!this.jSettingsSavePanel.isVisible()) {
                this.jSettingsSavePanel.setVisible(true);
            }
            if (nProgress < 0) {
                nProgress = 0;
            }
            this.jSettingsSave.setValue(nProgress);
        }
    }

    private JLabel createResult() {
        JLabel jLabel = new JLabel("-");
        jLabel.setMinimumSize(new Dimension(50, 25));
        jLabel.setMaximumSize(new Dimension(50, 25));
        jLabel.setPreferredSize(new Dimension(50, 25));
        jLabel.setBorder(this.jFieldBorder);
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    private JProgressBar createProgress() {
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setValue(100);
        return jProgressBar;
    }

    private JPanel createProgressPanel(JComponent c) {
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize(new Dimension(107, 23));
        jPanel.setMaximumSize(new Dimension(107, 23));
        jPanel.setPreferredSize(new Dimension(107, 23));
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.jFieldBorder, BorderFactory.createEmptyBorder(2, 2, 0, 2)));
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(c);
        jPanel.setVisible(false);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.jTradeTimer)) {
            this.jTradeTimer.stop();
            this.jTradeSearchPanel.setVisible(false);
        }
        if (e.getSource().equals(this.jPriceTimer)) {
            this.jPriceTimer.stop();
            this.jPriceSearchPanel.setVisible(false);
        }
        if (e.getSource().equals(this.jSettingsTimer)) {
            this.jSettingsTimer.stop();
            this.jSettingsSavePanel.setVisible(false);
        }
    }
}

