/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.settings;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import vstrade.data.settings.FileSettings;

public class VegaFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private FileSettings paths;

    public VegaFileChooser(FileSettings paths) {
        this.paths = paths;
        this.setFileSelectionMode(1);
        this.setMultiSelectionEnabled(false);
        this.addPropertyChangeListener(this);
    }

    @Override
    public void approveSelection() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            if (this.paths.isValidPath(selectedFile.getAbsolutePath())) {
                super.approveSelection();
            } else {
                super.setCurrentDirectory(selectedFile);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop.equals("directoryChanged")) {
            this.approveSelection();
        }
    }

    @Override
    public void updateUI() {
        this.putClientProperty("FileChooser.useShellFolder", Boolean.FALSE);
        super.updateUI();
    }
}

