/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.settings;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import vstrade.Program;
import vstrade.io.Log;
import vstrade.language.LocaleItem;
import vstrade.moduls.settings.ListItem;
import vstrade.moduls.settings.VegaFileChooser;
import vstrade.shared.GUIFactory;
import vstrade.shared.ModuleView;
import vstrade.shared.MultiSelectionList;

public class SettingsView
extends ModuleView
implements ActionListener,
MouseListener {
    private final String ACTION_BROWSE = "browseVegaStrike";
    private final String ACTION_SAVE = "SaveSettings";
    private final String ACTION_LOAD = "LoadSettings";
    private JTextField jVegaStrikePath;
    private JButton jVegaStrikePathButton;
    private JPanel jVegaStrikePathTPanel;
    private MultiSelectionList jTradeColumns;
    private JPanel jTradeColumnsTPanel;
    private MultiSelectionList jPriceColumns;
    private JPanel jPriceColumnsTPanel;
    private JPanel jSwitchTPanel;
    private JCheckBox jAutoCenter;
    private JLabel jAutoCenterLabel;
    private JCheckBox jAutoConfig;
    private JLabel jAutoConfigLabel;
    private JCheckBox jSwitchComponent;
    private JLabel jSwitchComponentLabel;
    private JComboBox jLanguage;
    private JPanel jLanguageTPanel;
    private JButton jCancel;
    private JButton jSave;
    private JPanel jSaveTPanel;
    private VegaFileChooser fileChooser;
    private Program program;

    public SettingsView(Program program) {
        this.program = program;
        this.fileChooser = new VegaFileChooser(program.getSettings().getFileSettings());
        this.jVegaStrikePathButton = GUIFactory.jButton(this, "browseVegaStrike");
        this.jVegaStrikePath = new JTextField();
        this.jVegaStrikePath.setPreferredSize(new Dimension(406, 25));
        this.jVegaStrikePath.setMinimumSize(new Dimension(406, 25));
        this.jVegaStrikePathTPanel = GUIFactory.jPTitle(2, this.jVegaStrikePath, this.jVegaStrikePathButton);
        JPanel jVegaStrikePathRPanel = GUIFactory.jPRow(this.jVegaStrikePathTPanel);
        this.jTradeColumns = GUIFactory.jMultiSelectionList();
        JScrollPane tradeScrollPanel = GUIFactory.jScrollPanel(this.jTradeColumns, 4);
        this.jTradeColumnsTPanel = GUIFactory.jPTitle(tradeScrollPanel);
        this.jPriceColumns = GUIFactory.jMultiSelectionList();
        JScrollPane priceScrollPanel = GUIFactory.jScrollPanel(this.jPriceColumns, 4);
        this.jPriceColumnsTPanel = GUIFactory.jPTitle(priceScrollPanel);
        JPanel jColumnsRPanel = GUIFactory.jPRow(this.jTradeColumnsTPanel, this.jPriceColumnsTPanel);
        this.jAutoCenterLabel = GUIFactory.jLabel(this);
        this.jAutoCenter = GUIFactory.jCheckBox();
        this.jAutoConfigLabel = GUIFactory.jLabel(this);
        this.jAutoConfig = GUIFactory.jCheckBox();
        this.jSwitchComponentLabel = GUIFactory.jLabel(this);
        this.jSwitchComponent = GUIFactory.jCheckBox();
        JPanel jSwitchCPanel = GUIFactory.jPColumn(GUIFactory.jPCheckBox(this.jAutoCenter, this.jAutoCenterLabel), GUIFactory.jPCheckBox(this.jAutoConfig, this.jAutoConfigLabel), GUIFactory.jPCheckBox(this.jSwitchComponent, this.jSwitchComponentLabel));
        this.jSwitchTPanel = GUIFactory.jPTitle(jSwitchCPanel);
        this.jLanguage = GUIFactory.jComboBox();
        this.jLanguageTPanel = GUIFactory.jPTitle(this.jLanguage);
        this.jCancel = GUIFactory.jButton(this, "LoadSettings");
        this.jSave = GUIFactory.jButton(this, "SaveSettings");
        JPanel jSaveBPanel = GUIFactory.jPButton(this.jCancel, this.jSave);
        this.jSaveTPanel = GUIFactory.jPTitle(2, jSaveBPanel);
        JPanel jSaveLanguageCPanel = GUIFactory.jPColumn(this.jLanguageTPanel, this.jSaveTPanel);
        JPanel jButtonRPanel = GUIFactory.jPRow(this.jSwitchTPanel, jSaveLanguageCPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(jVegaStrikePathRPanel);
        jPanel.add(jColumnsRPanel);
        jPanel.add(jButtonRPanel);
        this.setLayout(new BoxLayout(this, 3));
        this.add(jPanel);
    }

    @Override
    public void setData() {
        this.updateLanguage();
        this.jLanguage.setModel(new DefaultComboBoxModel<LocaleItem>(this.program.getSettings().getLanguageSettings().getLocaleItemList()));
        this.load();
    }

    @Override
    public void clearData() {
    }

    @Override
    public void updateLanguage() {
        this.sTitle = this.program.getSettings().getLanguageSettings().getString("Title", "settings");
        GUIFactory.setBorderTitle(this.jVegaStrikePathTPanel, this.program.getSettings().getLanguageSettings().getString("VegaStrikePath", "settings"));
        this.jVegaStrikePath.setToolTipText(this.program.getSettings().getLanguageSettings().getString("VegaStrikePathTT", "settings"));
        this.jVegaStrikePathButton.setText(this.program.getSettings().getLanguageSettings().getString("ButtonBrowse", "settings"));
        this.jTradeColumns.setToolTipText(this.program.getSettings().getLanguageSettings().getString("TradeColumnsTT", "settings"));
        GUIFactory.setBorderTitle(this.jTradeColumnsTPanel, this.program.getSettings().getLanguageSettings().getString("TradeColumns", "settings"));
        Vector<String> tradeKeys = this.program.getSettings().getTradeSettings().getTradeTableColumnKeys();
        Vector<ListItem> tradeColumns = new Vector<ListItem>(tradeKeys.size());
        for (int i = 0; i < tradeKeys.size(); ++i) {
            tradeColumns.add(new ListItem(this.program.getSettings().getLanguageSettings().getString(tradeKeys.get(i), "trade"), tradeKeys.get(i)));
        }
        this.jTradeColumns.setListData(tradeColumns);
        this.jPriceColumns.setToolTipText(this.program.getSettings().getLanguageSettings().getString("PricesColumnsTT", "settings"));
        GUIFactory.setBorderTitle(this.jPriceColumnsTPanel, this.program.getSettings().getLanguageSettings().getString("PricesColumns", "settings"));
        Vector<String> priceKeys = this.program.getSettings().getPriceSettings().getPriceTableColumnKeys();
        Vector<ListItem> priceColumns = new Vector<ListItem>(priceKeys.size());
        for (int i = 0; i < priceKeys.size(); ++i) {
            priceColumns.add(new ListItem(this.program.getSettings().getLanguageSettings().getString(priceKeys.get(i), "price"), priceKeys.get(i)));
        }
        this.jPriceColumns.setListData(priceColumns);
        this.jAutoCenterLabel.setText(this.program.getSettings().getLanguageSettings().getString("AutoCenter", "settings"));
        this.jAutoCenterLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AutoCenterTT", "settings"));
        this.jAutoCenter.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AutoCenterTT", "settings"));
        this.jAutoConfigLabel.setText(this.program.getSettings().getLanguageSettings().getString("AutoConfig", "settings"));
        this.jAutoConfigLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AutoConfigTT", "settings"));
        this.jAutoConfig.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AutoConfigTT", "settings"));
        this.jSwitchComponentLabel.setText(this.program.getSettings().getLanguageSettings().getString("SwitchComponent", "settings"));
        this.jSwitchComponentLabel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SwitchComponentTT", "settings"));
        this.jSwitchComponent.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SwitchComponentTT", "settings"));
        GUIFactory.setBorderTitle(this.jSwitchTPanel, this.program.getSettings().getLanguageSettings().getString("Switches", "settings"));
        this.jLanguage.setToolTipText(this.program.getSettings().getLanguageSettings().getString("LanguageTT", "settings"));
        GUIFactory.setBorderTitle(this.jLanguageTPanel, this.program.getSettings().getLanguageSettings().getString("Language", "settings"));
        this.jCancel.setText(this.program.getSettings().getLanguageSettings().getString("CancelButton", "settings"));
        this.jCancel.setToolTipText(this.program.getSettings().getLanguageSettings().getString("CancelButtonTT", "settings"));
        this.jSave.setText(this.program.getSettings().getLanguageSettings().getString("SaveButton", "settings"));
        this.jSave.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SaveButtonTT", "settings"));
        GUIFactory.setBorderTitle(this.jSaveTPanel, this.program.getSettings().getLanguageSettings().getString("SaveSettings", "settings"));
    }

    private String browse() {
        String sCurrentPath = this.jVegaStrikePath.getText();
        File fCurrentPath = new File(sCurrentPath);
        if (fCurrentPath.exists()) {
            this.fileChooser.setCurrentDirectory(fCurrentPath);
        } else {
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        }
        int bFound = this.fileChooser.showOpenDialog(this);
        if (bFound == 0) {
            String path = this.fileChooser.getSelectedFile().getAbsolutePath();
            if (path.lastIndexOf(File.separator) < path.length() - 1) {
                path = path + File.separator;
            }
            return path;
        }
        return sCurrentPath;
    }

    private void load() {
        this.jVegaStrikePath.setText(this.program.getSettings().getFileSettings().getVegaStrikePath());
        this.jAutoCenter.setSelected(this.program.getSettings().getMapSettings().isAutoCenterEnabled());
        this.jAutoConfig.setSelected(this.program.getSettings().getAutoConfig());
        this.jSwitchComponent.setSelected(this.program.getSettings().getSwitchComponent());
        this.jLanguage.setSelectedItem(this.program.getSettings().getLanguageSettings().getCurrentLocale());
        Vector<String> tradeKeys = this.program.getSettings().getTradeSettings().getTradeTableColumnKeys();
        Vector<String> tradeTableColumns = this.program.getSettings().getTradeSettings().getTradeTableColumns();
        int[] selected = new int[tradeTableColumns.size()];
        for (int a = 0; a < tradeTableColumns.size(); ++a) {
            for (int b = 0; b < tradeKeys.size(); ++b) {
                if (!tradeKeys.get(b).equals(tradeTableColumns.get(a))) continue;
                selected[a] = b;
            }
        }
        this.jTradeColumns.setSelectedIndices(selected);
        Vector<String> priceKeys = this.program.getSettings().getPriceSettings().getPriceTableColumnKeys();
        Vector<String> priceTableColumns = this.program.getSettings().getPriceSettings().getPriceTableColumns();
        selected = new int[priceTableColumns.size()];
        for (int a = 0; a < priceTableColumns.size(); ++a) {
            for (int b = 0; b < priceKeys.size(); ++b) {
                if (!priceKeys.get(b).equals(priceTableColumns.get(a))) continue;
                selected[a] = b;
            }
        }
        this.jPriceColumns.setSelectedIndices(selected);
    }

    private void save() {
        Log.write("--------------------------------");
        String sVegaStrikePath = this.jVegaStrikePath.getText();
        if (!this.program.getSettings().getFileSettings().isValidPath(sVegaStrikePath) && !this.jVegaStrikePath.getText().equals("")) {
            Log.showWarning("The path to vega strike is not a valid.\nPlease browse to or type in a valid directory.\n\nSee the readme.txt for more information");
        }
        this.program.getSettings().getFileSettings().setVegaStrikePath(sVegaStrikePath);
        this.program.getSettings().getMapSettings().enableAutoCenter(this.jAutoCenter.isSelected());
        this.program.getSettings().setAutoConfig(this.jAutoConfig.isSelected());
        this.program.getSettings().setSwitchComponent(this.jSwitchComponent.isSelected());
        LocaleItem localeItem = (LocaleItem)this.jLanguage.getSelectedItem();
        this.program.getSettings().getLanguageSettings().setCurrentLocale(localeItem);
        Object[] arrTradeColumns = this.jTradeColumns.getSelectedValues();
        Vector<String> tradeColumns = new Vector<String>(arrTradeColumns.length);
        for (int a = 0; a < arrTradeColumns.length; ++a) {
            ListItem listItem = (ListItem)arrTradeColumns[a];
            tradeColumns.add(listItem.getKey());
        }
        this.program.getSettings().getTradeSettings().setTradeTableColumns(tradeColumns);
        Object[] arrPriceColumns = this.jPriceColumns.getSelectedValues();
        Vector<String> priceColumns = new Vector<String>();
        for (int a = 0; a < arrPriceColumns.length; ++a) {
            ListItem listItem = (ListItem)arrPriceColumns[a];
            priceColumns.add(listItem.getKey());
        }
        this.program.getSettings().getPriceSettings().setPriceTableColumns(priceColumns);
        this.program.save();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("browseVegaStrike".equals(e.getActionCommand())) {
            String path = this.browse();
            this.jVegaStrikePath.setText(path);
        }
        if ("SaveSettings".equals(e.getActionCommand())) {
            this.save();
        }
        if ("LoadSettings".equals(e.getActionCommand())) {
            this.load();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.jAutoCenterLabel)) {
            this.jAutoCenter.setSelected(!this.jAutoCenter.isSelected());
        }
        if (e.getSource().equals(this.jAutoConfigLabel)) {
            this.jAutoConfig.setSelected(!this.jAutoConfig.isSelected());
        }
        if (e.getSource().equals(this.jSwitchComponentLabel)) {
            this.jSwitchComponent.setSelected(!this.jSwitchComponent.isSelected());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

