/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.price;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.moduls.price.PriceSearch;
import vstrade.moduls.price.PriceTableFormat;
import vstrade.moduls.price.PriceTablePopupMenu;
import vstrade.moduls.price.PriceTableRow;
import vstrade.shared.ComboSelectionManager;
import vstrade.shared.GUIFactory;
import vstrade.shared.IntegerKeyListener;
import vstrade.shared.ModuleView;
import vstrade.shared.MultiSelectionList;
import vstrade.shared.NodeListModel;

public class PriceView
extends ModuleView
implements ActionListener,
MouseListener,
KeyListener {
    public final String ACTION_SEARCH = "FindPriceList";
    public final String ACTION_CLEAR = "ClearBasesTable";
    public final String ACTION_BASE_TYPE = "BaseType";
    public final String ACTION_BASE_ADD = "AddBase";
    public final String ACTION_BASE_CLEAR = "ClearBaseList";
    private JButton jClearList;
    private NodeListModel jBasesModel;
    private MultiSelectionList jBases;
    private JComboBox jAddBase;
    private JComboBox jType;
    private JButton jAddButton;
    private JPanel pricesBasesPanel;
    private JComboBox jCargo;
    private JPanel pricesCargoPanel;
    private JTextField jMinimumPrice;
    private JPanel jMinimumPriceTPanel;
    private JTextField jMaximumPrice;
    private JPanel jMaximumPriceTPanel;
    private JTextField jQuantity;
    private JPanel jQuantityTPanel;
    private JButton jClear;
    private JButton jSearch;
    private JPanel jSearchTPanel;
    private JTable jTable;
    private PriceTableFormat priceTableFormat;
    private EventTableModel<PriceTableRow> priceTableModel;
    private EventList<PriceTableRow> priceEventList;
    PriceTablePopupMenu jPriceTablePopupMenu;
    private IntegerKeyListener textListener;
    private Program program;
    private String sAlt;

    public PriceView(Program program) {
        this.program = program;
        this.textListener = new IntegerKeyListener();
        this.jPriceTablePopupMenu = new PriceTablePopupMenu(program, this);
        this.jClearList = GUIFactory.jButtonSmall(this, "ClearBaseList");
        JPanel jButtonPanel = GUIFactory.jPButton(this.jClearList);
        this.jBasesModel = new NodeListModel();
        this.jBases = GUIFactory.jMultiSelectionList(this.jBasesModel, this, this);
        this.jType = GUIFactory.jComboBox(this, "BaseType");
        this.jAddBase = GUIFactory.jComboBoxSmall(null, "AddBase", this);
        this.jAddButton = GUIFactory.jButtonSmall(this, "AddBase");
        JPanel jAddPanel = GUIFactory.jPButton(this.jAddBase, this.jAddButton);
        this.pricesBasesPanel = GUIFactory.jPTitle(3, jButtonPanel, GUIFactory.jScrollPanel(this.jBases, 4), this.jType, jAddPanel);
        this.jCargo = GUIFactory.jComboBox();
        this.jCargo.setKeySelectionManager(new ComboSelectionManager());
        this.pricesCargoPanel = GUIFactory.jPTitle(this.jCargo);
        this.jMinimumPrice = GUIFactory.jTextField(this.textListener);
        this.jMinimumPriceTPanel = GUIFactory.jPTitle(this.jMinimumPrice);
        this.jMaximumPrice = GUIFactory.jTextField(this.textListener);
        this.jMaximumPriceTPanel = GUIFactory.jPTitle(this.jMaximumPrice);
        JPanel jPriceRPanel = GUIFactory.jPRow(this.jMinimumPriceTPanel, this.jMaximumPriceTPanel);
        this.jQuantity = GUIFactory.jTextField(this.textListener);
        this.jQuantityTPanel = GUIFactory.jPTitle(this.jQuantity);
        this.jClear = GUIFactory.jButton(this, "ClearBasesTable");
        this.jSearch = GUIFactory.jButton(this, "FindPriceList");
        JPanel jSearchBPanel = GUIFactory.jPButton(this.jClear, this.jSearch);
        this.jSearchTPanel = GUIFactory.jPTitle(2, jSearchBPanel);
        this.priceEventList = new BasicEventList<PriceTableRow>();
        SortedList<PriceTableRow> priceSortedList = new SortedList<PriceTableRow>(this.priceEventList);
        this.priceTableFormat = new PriceTableFormat(program);
        this.priceTableModel = new EventTableModel<PriceTableRow>(priceSortedList, this.priceTableFormat);
        this.jTable = new JTable(this.priceTableModel);
        this.jTable.addMouseListener(this);
        this.jTable.addMouseListener(program);
        TableComparatorChooser<PriceTableRow> priceSorter = new TableComparatorChooser<PriceTableRow>(this.jTable, priceSortedList, true);
        JScrollPane jTableSPanel = new JScrollPane(this.jTable);
        jTableSPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), BorderFactory.createEtchedBorder(1)));
        JPanel jInputCPanel = GUIFactory.jPColumn(this.pricesCargoPanel, this.jMinimumPriceTPanel, this.jMaximumPriceTPanel, this.jQuantityTPanel, this.jSearchTPanel);
        JPanel jInputRPanel = GUIFactory.jPRow(jInputCPanel, GUIFactory.jPDimension(jInputCPanel.getPreferredSize(), this.pricesBasesPanel));
        JPanel jConfigPanel = new JPanel();
        jConfigPanel.setLayout(new BoxLayout(jConfigPanel, 3));
        jConfigPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jConfigPanel.add(jInputRPanel);
        JSplitPane jPanel = new JSplitPane(0, jConfigPanel, jTableSPanel);
        jPanel.setBorder(null);
        jPanel.setOneTouchExpandable(true);
        jPanel.setEnabled(false);
        jPanel.setDividerSize(10);
        this.setLayout(new BoxLayout(this, 3));
        this.add(jPanel);
    }

    @Override
    public void setData() {
        this.updateLanguage();
        boolean bEnable = this.program.getBases().isLoaded();
        if (bEnable) {
            this.jType.setModel(new DefaultComboBoxModel<String>(this.getTypeList()));
            this.jAddBase.setModel(new DefaultComboBoxModel<Node>(this.getBaseList()));
            this.jCargo.setModel(new DefaultComboBoxModel<Node>(this.getCargoList()));
        }
        this.jClearList.setEnabled(bEnable);
        this.jBases.setEnabled(bEnable);
        this.jType.setEnabled(bEnable);
        this.jAddBase.setEnabled(bEnable);
        this.jAddButton.setEnabled(bEnable);
        this.jCargo.setEnabled(bEnable);
        this.jMinimumPrice.setEnabled(bEnable);
        this.jMaximumPrice.setEnabled(bEnable);
        this.jQuantity.setEnabled(bEnable);
        this.jClear.setEnabled(bEnable);
        this.jSearch.setEnabled(bEnable);
    }

    @Override
    public void clearData() {
        String[] arrDefaultType = new String[]{this.program.getSettings().getLanguageSettings().getString("NoTypes", "price")};
        String[] arrDefaultBase = new String[]{this.program.getSettings().getLanguageSettings().getString("NoBases", "price")};
        String[] arrDefaultCargo = new String[]{this.program.getSettings().getLanguageSettings().getString("NoCargo", "price")};
        this.jType.setModel(new DefaultComboBoxModel<String>(arrDefaultType));
        this.jAddBase.setModel(new DefaultComboBoxModel<String>(arrDefaultBase));
        this.jCargo.setModel(new DefaultComboBoxModel<String>(arrDefaultCargo));
        this.jBasesModel.clear();
        this.priceEventList.getReadWriteLock().writeLock().lock();
        this.priceEventList.clear();
        this.priceEventList.getReadWriteLock().writeLock().unlock();
        this.program.getStatusView().setPriceResults("-");
    }

    @Override
    public void updateLanguage() {
        this.sTitle = this.program.getSettings().getLanguageSettings().getString("Title", "price");
        this.sAlt = this.program.getSettings().getLanguageSettings().getString("All", "price");
        this.jPriceTablePopupMenu.updateLanguage();
        this.jType.setToolTipText(this.program.getSettings().getLanguageSettings().getString("TypeTT", "price"));
        this.jAddBase.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AddTT", "price"));
        this.jAddButton.setText(this.program.getSettings().getLanguageSettings().getString("AddButton", "price"));
        this.jAddButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("AddButtonTT", "price"));
        this.jBases.setToolTipText(this.program.getSettings().getLanguageSettings().getString("BasesTT", "price"));
        this.jClearList.setText("!");
        this.jClearList.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ClearListTT", "price"));
        GUIFactory.setBorderTitle(this.pricesBasesPanel, this.program.getSettings().getLanguageSettings().getString("Base", "price"));
        this.jCargo.setToolTipText(this.program.getSettings().getLanguageSettings().getString("CargoTT", "price"));
        GUIFactory.setBorderTitle(this.pricesCargoPanel, this.program.getSettings().getLanguageSettings().getString("Cargo", "price"));
        this.jMinimumPrice.setToolTipText(this.program.getSettings().getLanguageSettings().getString("MinPriceTT", "price"));
        GUIFactory.setBorderTitle(this.jMinimumPriceTPanel, this.program.getSettings().getLanguageSettings().getString("MinPrice", "price"));
        this.jMaximumPrice.setToolTipText(this.program.getSettings().getLanguageSettings().getString("MaxPriceTT", "price"));
        GUIFactory.setBorderTitle(this.jMaximumPriceTPanel, this.program.getSettings().getLanguageSettings().getString("MaxPrice", "price"));
        this.jQuantity.setToolTipText(this.program.getSettings().getLanguageSettings().getString("MinQuantityTT", "price"));
        GUIFactory.setBorderTitle(this.jQuantityTPanel, this.program.getSettings().getLanguageSettings().getString("MinQuantity", "price"));
        this.jClear.setText(this.program.getSettings().getLanguageSettings().getString("Clear", "price"));
        this.jClear.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ClearTT", "price"));
        this.jSearch.setText(this.program.getSettings().getLanguageSettings().getString("Search", "price"));
        this.jSearch.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SearchTT", "price"));
        GUIFactory.setBorderTitle(this.jSearchTPanel, this.program.getSettings().getLanguageSettings().getString("Search", "price"));
        this.priceTableModel.fireTableStructureChanged();
    }

    public void setSelectedCargo(Cargo cargo) {
        this.jCargo.setSelectedItem(cargo);
    }

    public void addBase(Base base) {
        this.jBasesModel.add(base);
        this.jBases.addSelection(this.jBasesModel.indexOf(base), true);
    }

    public Cargo getSelectedCargo() {
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        PriceTableRow priceTableRow = this.priceTableModel.getElementAt(row);
        Cargo cargo = priceTableRow.getCargo();
        return cargo;
    }

    public Base getSelectedBase() {
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        PriceTableRow priceTableRow = this.priceTableModel.getElementAt(row);
        Base base = priceTableRow.getBase();
        return base;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PriceTableRow priceTableRow;
        if ("BaseType".equals(e.getActionCommand())) {
            String sType = (String)this.jType.getSelectedItem();
            Vector<Node> basesList = sType.equals(this.getAll()) ? this.getBaseList() : this.getBaseList(sType);
            this.jAddBase.setModel(new DefaultComboBoxModel<Node>(basesList));
        }
        if ("AddBase".equals(e.getActionCommand()) && e.getModifiers() > 0) {
            this.addBaseToList();
        }
        if ("ClearBaseList".equals(e.getActionCommand())) {
            this.jBasesModel.clear();
        }
        if ("ClearBasesTable".equals(e.getActionCommand())) {
            this.priceEventList.getReadWriteLock().writeLock().lock();
            this.priceEventList.clear();
            this.priceEventList.getReadWriteLock().writeLock().unlock();
            this.program.getStatusView().setPriceResults("-");
        }
        if ("FindPriceList".equals(e.getActionCommand())) {
            this.search();
        }
        if (this.jPriceTablePopupMenu.ACTION_PRICE_ADD_BASE.equals(e.getActionCommand())) {
            int row = this.jTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            priceTableRow = this.priceTableModel.getElementAt(row);
            Base base = priceTableRow.getBase();
            this.jBasesModel.add(base);
            this.jBases.addSelection(this.jBasesModel.indexOf(base), true);
        }
        if (this.jPriceTablePopupMenu.ACTION_PRICE_SET_CARGO.equals(e.getActionCommand())) {
            int row = this.jTable.getSelectedRow();
            if (row < 0) {
                return;
            }
            priceTableRow = this.priceTableModel.getElementAt(row);
            Cargo cargo = priceTableRow.getCargo();
            this.jCargo.setSelectedItem(cargo);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource().equals(this.jTable) && e.getButton() == 3) {
            int i = this.jTable.rowAtPoint(e.getPoint());
            this.jTable.setRowSelectionInterval(i, i);
            this.jPriceTablePopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
        if (e.getSource().equals(this.jBases) && e.getButton() == 3) {
            this.jBasesModel.remove(this.jBases.locationToIndex(e.getPoint()));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource().equals(this.jAddBase) && (e.getKeyCode() == 10 || e.getKeyCode() == 32)) {
            this.addBaseToList();
        }
        if (e.getSource().equals(this.jBases) && e.getKeyCode() == 127) {
            this.jBasesModel.remove(this.jBases.getAnchorSelectionIndex());
        }
    }

    private void search() {
        int nQuantity;
        int nMaxPrice;
        int nMinPrice;
        if (this.jBasesModel.isEmpty()) {
            return;
        }
        Vector<Node> arrBases = this.jBasesModel.getSelectedNodes(this.jBases);
        Node cargoNode = (Node)this.jCargo.getSelectedItem();
        String sMinPrice = this.jMinimumPrice.getText();
        try {
            nMinPrice = Integer.valueOf(sMinPrice);
        }
        catch (NumberFormatException ex) {
            nMinPrice = 0;
        }
        String sMaxPrice = this.jMaximumPrice.getText();
        try {
            nMaxPrice = Integer.valueOf(sMaxPrice);
        }
        catch (NumberFormatException ex) {
            nMaxPrice = 0;
        }
        String sQuantity = this.jQuantity.getText();
        try {
            nQuantity = Integer.valueOf(sQuantity);
        }
        catch (NumberFormatException ex) {
            nQuantity = 0;
        }
        PriceSearch priceSearch = new PriceSearch(this.program, this.jClear, this.jSearch, this.priceEventList, arrBases, cargoNode, nMinPrice, nMaxPrice, nQuantity);
        priceSearch.start();
    }

    private Vector<String> getTypeList() {
        Vector<String> typeVector = this.program.getBases().getTypeList();
        typeVector.add(0, this.getAll());
        return typeVector;
    }

    private Vector<Node> getBaseList() {
        Vector<Node> baseVector = this.program.getBases().getBaseList();
        baseVector.add(0, new Base(this.getAll(), ""));
        return baseVector;
    }

    private Vector<Node> getBaseList(String sType) {
        Vector<Node> baseVector = this.program.getBases().getBaseList(sType);
        baseVector.add(0, new Base(this.getAll(sType), ""));
        return baseVector;
    }

    private Vector<Node> getCargoList() {
        Vector<Node> cargoVector = this.program.getBases().getCargoList();
        if (!cargoVector.get(0).equals(new Cargo(this.getAll()))) {
            cargoVector.add(0, new Cargo(this.getAll()));
        }
        return cargoVector;
    }

    private String getAll() {
        return "[" + this.sAlt + "]";
    }

    private String getAll(String sType) {
        return "[" + this.sAlt + " " + sType + "]";
    }

    private void addBaseToList() {
        Node node = (Node)this.jAddBase.getSelectedItem();
        if (node.getName().contains(this.sAlt)) {
            Vector<Node> nodes = node.getName().equals(this.getAll()) ? this.getBaseList() : this.getBaseList((String)this.jType.getSelectedItem());
            for (int a = 0; a < nodes.size(); ++a) {
                node = nodes.get(a);
                this.jBasesModel.add(node);
                this.jBases.addSelection(this.jBasesModel.indexOf(node), true);
            }
        } else if (!this.jBasesModel.contains(node)) {
            this.jBasesModel.add(node);
            this.jBases.addSelection(this.jBasesModel.indexOf(node), true);
        }
    }
}

