/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.price;

import ca.odell.glazedlists.gui.AdvancedTableFormat;
import java.util.Comparator;
import vstrade.Program;
import vstrade.moduls.price.PriceTableRow;
import vstrade.shared.FloatComparator;
import vstrade.shared.IntegerComparator;
import vstrade.shared.StringComparator;

public class PriceTableFormat
implements AdvancedTableFormat<PriceTableRow> {
    private Comparator integerComparator;
    private Comparator stringComparator;
    private Comparator floatComparator;
    private Program program;

    public PriceTableFormat(Program program) {
        this.program = program;
        this.integerComparator = new IntegerComparator();
        this.stringComparator = new StringComparator();
        this.floatComparator = new FloatComparator();
    }

    @Override
    public Class getColumnClass(int i) {
        String sColumn = this.program.getSettings().getPriceSettings().getPriceTableColumn(i);
        if (sColumn.equals("TableBase")) {
            return String.class;
        }
        if (sColumn.equals("TableCommerce")) {
            return String.class;
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMinQuantity")) {
            return Integer.class;
        }
        if (sColumn.equals("TableVolume")) {
            return Float.class;
        }
        if (sColumn.equals("TableMaxPrice")) {
            return Integer.class;
        }
        if (sColumn.equals("TableAvgPrice")) {
            return Integer.class;
        }
        if (sColumn.equals("TableMinPrice")) {
            return Integer.class;
        }
        if (sColumn.equals("TablePercentPrice")) {
            return Integer.class;
        }
        return Object.class;
    }

    @Override
    public Comparator getColumnComparator(int i) {
        String sColumn = this.program.getSettings().getPriceSettings().getPriceTableColumn(i);
        if (sColumn.equals("TableBase")) {
            return this.stringComparator;
        }
        if (sColumn.equals("TableCommerce")) {
            return this.stringComparator;
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMinQuantity")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableVolume")) {
            return this.floatComparator;
        }
        if (sColumn.equals("TableMaxPrice")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableAvgPrice")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TableMinPrice")) {
            return this.integerComparator;
        }
        if (sColumn.equals("TablePercentPrice")) {
            return this.integerComparator;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return this.program.getSettings().getPriceSettings().getPriceTableColumns().size();
    }

    @Override
    public String getColumnName(int i) {
        return this.program.getSettings().getLanguageSettings().getString(this.program.getSettings().getPriceSettings().getPriceTableColumn(i), "price");
    }

    @Override
    public Object getColumnValue(PriceTableRow row, int i) {
        String sColumn = this.program.getSettings().getPriceSettings().getPriceTableColumn(i);
        if (sColumn.equals("TableBase")) {
            return row.getBaseName();
        }
        if (sColumn.equals("TableCommerce")) {
            return row.getCargoName();
        }
        if (sColumn.equals("TableMaxQuantity")) {
            return row.getQuantityMaximum();
        }
        if (sColumn.equals("TableAvgQuantity")) {
            return row.getQuantityAverage();
        }
        if (sColumn.equals("TableMinQuantity")) {
            return row.getQuantityMinimum();
        }
        if (sColumn.equals("TableVolume")) {
            return Float.valueOf(row.getCargoVolume());
        }
        if (sColumn.equals("TableMaxPrice")) {
            return row.getPriceMaximum();
        }
        if (sColumn.equals("TableAvgPrice")) {
            return row.getPriceAverage();
        }
        if (sColumn.equals("TableMinPrice")) {
            return row.getPriceMinimum();
        }
        if (sColumn.equals("TablePercentPrice")) {
            return row.getPricePercent();
        }
        return new String();
    }
}

