/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.price;

import ca.odell.glazedlists.EventList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.bases.Base;
import vstrade.data.bases.Cargo;
import vstrade.moduls.price.PriceTableRow;

public class PriceSearch
extends Thread {
    public static final String CARGO = "Cargo";
    public static final String BASE = "Base";
    private List<PriceTableRow> result;
    private Base base;
    private Node cargo;
    private Vector<Node> arrBases;
    private int nMinPrice;
    private int nMaxPrice;
    private int nQuantity;
    private EventList<PriceTableRow> priceEventList;
    private Program program;
    private JButton jClear;
    private JButton jSearch;

    public PriceSearch(Program program, JButton jClear, JButton jSearch, EventList<PriceTableRow> priceEventList, Vector<Node> arrBases, Node cargo, int nMinPrice, int nMaxPrice, int nQuantity) {
        this.program = program;
        this.jClear = jClear;
        this.jSearch = jSearch;
        this.priceEventList = priceEventList;
        this.arrBases = arrBases;
        this.cargo = cargo;
        this.nMinPrice = nMinPrice;
        this.nMaxPrice = nMaxPrice;
        this.nQuantity = nQuantity;
    }

    @Override
    public void run() {
        this.jClear.setEnabled(false);
        this.jSearch.setEnabled(false);
        this.result = new Vector<PriceTableRow>();
        for (int a = 0; a < this.arrBases.size(); ++a) {
            this.base = (Base)this.arrBases.get(a);
            Node cargoByPath = this.base.getByPath(this.cargo.getPath());
            if (cargoByPath == null) {
                this.deepSearch(this.base);
            } else {
                this.deepSearch(cargoByPath);
            }
            this.program.getStatusView().setPriceSearchProgress(this.calcProgress(this.arrBases.size(), a));
        }
        this.program.getStatusView().setPriceResults(this.result.size());
        this.priceEventList.getReadWriteLock().writeLock().lock();
        this.priceEventList.clear();
        if (this.result.size() > 0) {
            this.priceEventList.addAll(this.result);
        }
        this.priceEventList.getReadWriteLock().writeLock().unlock();
        this.jClear.setEnabled(true);
        this.jSearch.setEnabled(true);
        this.program.getStatusView().setPriceSearchProgress(100);
    }

    private void deepSearch(Node node) {
        if (node instanceof Cargo) {
            this.compare((Cargo)node);
        } else {
            Vector<Node> nodes = node.getValues();
            for (int a = 0; a < nodes.size(); ++a) {
                this.deepSearch(nodes.get(a));
            }
        }
    }

    private void compare(Cargo cargo) {
        if (!(cargo.getPriceAverage() < this.nMinPrice && this.nMinPrice != 0 || cargo.getPriceAverage() > this.nMaxPrice && this.nMaxPrice != 0 || cargo.getQuantityAverage() < this.nQuantity && this.nQuantity != 0)) {
            this.addResult(cargo);
        }
    }

    private void addResult(Cargo cargo) {
        this.result.add(new PriceTableRow(this.base, cargo));
    }

    private int calcProgress(float aMax, int a) {
        int progress = (int)((float)(++a) / aMax * 100.0f);
        return progress;
    }
}

