/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.map;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import vstrade.data.Node;
import vstrade.data.galaxy.GalaxySystem;

public class PathFinder {
    public List<GalaxySystem> getPath(GalaxySystem start, GalaxySystem end) {
        VerticeQueue q = new VerticeQueue();
        q.add(new Vertice(start, 0));
        Hashtable<GalaxySystem, Vertice> found = new Hashtable<GalaxySystem, Vertice>();
        while (!q.isEmpty()) {
            Vertice c = q.remove();
            if (c.dist == Integer.MAX_VALUE) break;
            found.put(c.system, c);
            if (c.system == end) break;
            Vector<Node> sectorNodes = c.system.getValues();
            for (int a = 0; a < sectorNodes.size(); ++a) {
                GalaxySystem s = (GalaxySystem)sectorNodes.get(a);
                int dist = 1;
                int newDist = c.dist + dist;
                Vertice other = q.get(s);
                if (other != null) {
                    if (newDist >= other.dist) continue;
                    other = q.remove(s);
                    other.dist = newDist;
                    other.prev = c.system;
                    q.add(other);
                    continue;
                }
                if (found.containsKey(s)) continue;
                other = new Vertice(s, newDist);
                other.prev = c.system;
                q.add(other);
            }
        }
        if (found.get(end) == null) {
            return null;
        }
        Vector<GalaxySystem> result = new Vector<GalaxySystem>();
        GalaxySystem current = end;
        while (current != start) {
            Vertice v = (Vertice)found.get(current);
            result.add(0, v.system);
            current = v.prev;
        }
        result.add(0, start);
        return result;
    }

    private class Vertice
    implements Comparable<Vertice> {
        public GalaxySystem system;
        public int dist;
        public GalaxySystem prev;

        public Vertice(GalaxySystem system, int dist) {
            this.system = system;
            this.dist = dist;
            this.prev = null;
        }

        @Override
        public int compareTo(Vertice v) {
            if (this.dist < v.dist) {
                return -1;
            }
            if (this.dist > v.dist) {
                return 1;
            }
            return 0;
        }
    }

    private class VerticeQueue {
        private Map<GalaxySystem, Vertice> map = new Hashtable<GalaxySystem, Vertice>();
        private PriorityQueue<Vertice> queue = new PriorityQueue();

        public void add(Vertice v) {
            this.map.put(v.system, v);
            this.queue.add(v);
        }

        public boolean contains(GalaxySystem s) {
            return this.map.get(s) != null;
        }

        public Vertice get(GalaxySystem s) {
            return this.map.get(s);
        }

        public Vertice remove(GalaxySystem s) {
            Vertice v = this.map.get(s);
            this.map.remove(v);
            this.queue.remove(v);
            return v;
        }

        public Vertice remove() {
            Vertice v = (Vertice)this.queue.remove();
            this.map.remove(v);
            return v;
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }
    }
}

