/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.map;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.galaxy.GalaxySystem;
import vstrade.moduls.map.GalaxyView;
import vstrade.moduls.map.ScaleItem;
import vstrade.shared.AlignedListCellRenderer;
import vstrade.shared.DoubleKeyListener;
import vstrade.shared.GUIFactory;
import vstrade.shared.KeyAction;
import vstrade.shared.KeyActionTimer;
import vstrade.shared.ModuleView;

public class MapView
extends ModuleView
implements ActionListener,
MouseWheelListener,
ComponentListener {
    private final String ACTION_VEGAMAP_SELECT = "VegamapSelect";
    private final String ACTION_VEGAMAP_CENTER = "VegamapCenter";
    private final String ACTION_MOVE_UP = "VegamapMoveUp";
    private final String ACTION_MOVE_LEFT = "VegamapMoveLeft";
    private final String ACTION_MOVE_DOWN = "VegamapMoveDown";
    private final String ACTION_MOVE_RIGHT = "VegamapMoveRight";
    private final String ACTION_SHOW_NAMES = "VegamapShowNames";
    private final String ACTION_SHOW_JUMP_LINES = "VegamapShowJumpLines";
    private final String ACTION_SHOW_JUMPLESS_SYSTEMS = "VegamapShowJumplessSystems";
    private final String ACTION_SHOW_FACTIONS = "VegamapShowFactions";
    private final String ACTION_SHOW_SECTORS = "VegamapShowSectors";
    private final String ACTION_SHOW_SECTOR_BOXES = "VegamapShowSectorBoxes";
    private final String ACTION_SHOW_YAXIS = "VegamapShowYAxis";
    private final String ACTION_VEGAMAP_SCALE = "VegamapScale";
    private final String ACTION_VEGAMAP_ZOOM_OUT = "VegamapZoomOut";
    private final String ACTION_VEGAMAP_ZOOM_IN = "VegamapZoomIn";
    private final int PATH_PANEL_WIDTH = 255;
    private JButton jNamesButton;
    private JButton jJumpsLinesButton;
    private JButton jJumplessSystemsButton;
    private JButton jFactionsButton;
    private JButton jSectorsButton;
    private JButton jSectorBoxesButton;
    private JButton jYaxisButton;
    private JComboBox jSystemList;
    private final EventList<Node> priceSystemsEventList;
    private AutoCompleteSupport autoCompleteSupport;
    private JButton jCenter;
    private JButton jSelect;
    private JComboBox jScaleList;
    private JButton jZoomIn;
    private JButton jZoomOut;
    private JPanel jGalaxyPanel;
    private JTextArea jPath;
    private GalaxyView galaxyView;
    private DoubleKeyListener doubleKeyListener;
    private String sAlt;
    private Program program;

    public MapView(Program program) {
        this.program = program;
        this.doubleKeyListener = new DoubleKeyListener();
        this.getInputMap(1).put(KeyStroke.getKeyStroke("N"), "VegamapShowNames");
        this.getActionMap().put("VegamapShowNames", new KeyAction(this, "VegamapShowNames"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("J"), "VegamapShowJumpLines");
        this.getActionMap().put("VegamapShowJumpLines", new KeyAction(this, "VegamapShowJumpLines"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("L"), "VegamapShowJumplessSystems");
        this.getActionMap().put("VegamapShowJumplessSystems", new KeyAction(this, "VegamapShowJumplessSystems"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("F"), "VegamapShowFactions");
        this.getActionMap().put("VegamapShowFactions", new KeyAction(this, "VegamapShowFactions"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("C"), "VegamapShowSectors");
        this.getActionMap().put("VegamapShowSectors", new KeyAction(this, "VegamapShowSectors"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("B"), "VegamapShowSectorBoxes");
        this.getActionMap().put("VegamapShowSectorBoxes", new KeyAction(this, "VegamapShowSectorBoxes"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("R"), "VegamapShowYAxis");
        this.getActionMap().put("VegamapShowYAxis", new KeyAction(this, "VegamapShowYAxis"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke(90, 64), "VegamapZoomOut");
        this.getActionMap().put("VegamapZoomOut", new KeyAction(this, "VegamapZoomOut"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("X"), "VegamapZoomOut");
        this.getActionMap().put("VegamapZoomOut", new KeyAction(this, "VegamapZoomOut"));
        this.getInputMap(1).put(KeyStroke.getKeyStroke("Z"), "VegamapZoomIn");
        this.getActionMap().put("VegamapZoomIn", new KeyAction(this, "VegamapZoomIn"));
        new KeyActionTimer(this, "VegamapMoveLeft", this, 65);
        new KeyActionTimer(this, "VegamapMoveRight", this, 68);
        new KeyActionTimer(this, "VegamapMoveUp", this, 87);
        new KeyActionTimer(this, "VegamapMoveDown", this, 83);
        this.jNamesButton = GUIFactory.jButton(this, "VegamapShowNames");
        this.jNamesButton.setSelected(program.getSettings().getMapSettings().showNames());
        this.jJumpsLinesButton = GUIFactory.jButton(this, "VegamapShowJumpLines");
        this.jJumpsLinesButton.setSelected(program.getSettings().getMapSettings().showJumpsLines());
        this.jJumplessSystemsButton = GUIFactory.jButton(this, "VegamapShowJumplessSystems");
        this.jJumplessSystemsButton.setSelected(program.getSettings().getMapSettings().showJumplessSystems());
        this.jFactionsButton = GUIFactory.jButton(this, "VegamapShowFactions");
        this.jFactionsButton.setSelected(program.getSettings().getMapSettings().showFactions());
        this.jSectorsButton = GUIFactory.jButton(this, "VegamapShowSectors");
        this.jSectorsButton.setSelected(program.getSettings().getMapSettings().showSectors());
        this.jSectorBoxesButton = GUIFactory.jButton(this, "VegamapShowSectorBoxes");
        this.jSectorBoxesButton.setSelected(program.getSettings().getMapSettings().showSectorBoxes());
        this.jYaxisButton = GUIFactory.jButton(this, "VegamapShowYAxis");
        this.jYaxisButton.setSelected(program.getSettings().getMapSettings().showYaxis());
        JToolBar jToggleToolBar = new JToolBar();
        jToggleToolBar.add(this.jNamesButton);
        jToggleToolBar.add(this.jJumpsLinesButton);
        jToggleToolBar.add(this.jJumplessSystemsButton);
        jToggleToolBar.add(this.jFactionsButton);
        jToggleToolBar.add(this.jSectorsButton);
        jToggleToolBar.add(this.jSectorBoxesButton);
        jToggleToolBar.add(this.jYaxisButton);
        this.jSystemList = GUIFactory.jComboBox();
        this.jSystemList.setMaximumSize(new Dimension(120, 25));
        this.jSystemList.setMinimumSize(new Dimension(120, 25));
        this.jSystemList.setPreferredSize(new Dimension(120, 25));
        this.priceSystemsEventList = new BasicEventList<Node>();
        this.autoCompleteSupport = AutoCompleteSupport.install(this.jSystemList, this.priceSystemsEventList);
        this.autoCompleteSupport.setStrict(true);
        this.jCenter = GUIFactory.jButtonSmall(this, "VegamapCenter");
        this.jSelect = GUIFactory.jButtonSmall(this, "VegamapSelect");
        JToolBar jSelectToolBar = new JToolBar();
        jSelectToolBar.add(this.jSystemList);
        jSelectToolBar.add(this.jSelect);
        jSelectToolBar.add(this.jCenter);
        Object[] arrScales = new ScaleItem[]{new ScaleItem(1.0), new ScaleItem(10.0), new ScaleItem(25.0), new ScaleItem(50.0), new ScaleItem(100.0), new ScaleItem(250.0), new ScaleItem(500.0), new ScaleItem(1000.0), new ScaleItem(1500.0), new ScaleItem(2000.0)};
        this.jScaleList = GUIFactory.jComboBox(arrScales, this, "VegamapScale");
        this.jScaleList.setEditable(true);
        this.jScaleList.setMaximumSize(new Dimension(70, 25));
        this.jScaleList.setMinimumSize(new Dimension(70, 25));
        this.jScaleList.setPreferredSize(new Dimension(70, 25));
        this.jScaleList.getEditor().getEditorComponent().addKeyListener(this.doubleKeyListener);
        ((JTextField)this.jScaleList.getEditor().getEditorComponent()).setHorizontalAlignment(11);
        this.jScaleList.setRenderer(new AlignedListCellRenderer());
        this.jZoomIn = GUIFactory.jButtonSmall(this, "VegamapZoomIn");
        this.jZoomOut = GUIFactory.jButtonSmall(this, "VegamapZoomOut");
        JToolBar jZoomToolBar = new JToolBar();
        int nHeigth = (int)jZoomToolBar.getMinimumSize().getHeight();
        jZoomToolBar.add(this.jScaleList);
        jZoomToolBar.add(this.jZoomIn);
        jZoomToolBar.add(this.jZoomOut);
        JPanel jInputRPanel = new JPanel();
        jInputRPanel.setLayout(new FlowLayout(3));
        jInputRPanel.add(jToggleToolBar);
        jInputRPanel.add(jSelectToolBar);
        jInputRPanel.add(jZoomToolBar);
        jInputRPanel.setMinimumSize(new Dimension(Short.MAX_VALUE, 50 + nHeigth * 4 + 5));
        jInputRPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, 50 + nHeigth * 4 + 5));
        jInputRPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50 + nHeigth * 4 + 5));
        JPanel jInputPanel = new JPanel();
        jInputPanel.setLayout(new BoxLayout(jInputPanel, 3));
        jInputPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jInputPanel.add(jInputRPanel);
        this.jGalaxyPanel = new JPanel();
        this.jGalaxyPanel.setLayout(new BoxLayout(this.jGalaxyPanel, 2));
        this.jGalaxyPanel.setPreferredSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jGalaxyPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.jPath = new JTextArea();
        this.jPath.setEditable(false);
        JScrollPane jPathSPanel = new JScrollPane(this.jPath);
        JPanel jPathPanel = new JPanel();
        jPathPanel.setLayout(new BoxLayout(jPathPanel, 3));
        jPathPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPathPanel.add(jPathSPanel);
        JSplitPane jGalaxyPathSPanel = new JSplitPane(1, this.jGalaxyPanel, jPathPanel);
        jGalaxyPathSPanel.setBorder(null);
        jGalaxyPathSPanel.setOneTouchExpandable(true);
        jGalaxyPathSPanel.setDividerSize(10);
        jGalaxyPathSPanel.setEnabled(false);
        jGalaxyPathSPanel.addComponentListener(this);
        JSplitPane jPanel = new JSplitPane(0, jInputPanel, jGalaxyPathSPanel);
        jPanel.setBorder(null);
        jPanel.setOneTouchExpandable(true);
        jPanel.setDividerSize(10);
        jPanel.setEnabled(false);
        this.setLayout(new BoxLayout(this, 3));
        this.add(jPanel);
    }

    @Override
    public void setData() {
        this.updateLanguage();
        boolean bEnabled = this.program.getGalaxy().isLoaded();
        if (bEnabled) {
            this.jGalaxyPanel.removeAll();
            this.galaxyView = new GalaxyView(this.program, this.jPath);
            this.galaxyView.addMouseWheelListener(this);
            this.jGalaxyPanel.add(this.galaxyView);
            this.priceSystemsEventList.getReadWriteLock().writeLock().lock();
            this.priceSystemsEventList.clear();
            this.priceSystemsEventList.addAll(this.program.getGalaxy().getSystems());
            this.priceSystemsEventList.getReadWriteLock().writeLock().unlock();
            this.jSystemList.setSelectedIndex(0);
            this.jScaleList.setSelectedIndex(0);
        }
        this.jNamesButton.setEnabled(bEnabled);
        this.jJumpsLinesButton.setEnabled(bEnabled);
        this.jJumplessSystemsButton.setEnabled(bEnabled);
        this.jFactionsButton.setEnabled(bEnabled);
        this.jSectorsButton.setEnabled(bEnabled);
        this.jSectorBoxesButton.setEnabled(bEnabled);
        this.jYaxisButton.setEnabled(bEnabled);
        this.jCenter.setEnabled(bEnabled);
        this.jSelect.setEnabled(bEnabled);
        this.jSystemList.setEnabled(bEnabled);
        this.jScaleList.setEnabled(bEnabled);
        this.jZoomIn.setEnabled(bEnabled);
        this.jZoomOut.setEnabled(bEnabled);
    }

    @Override
    public void clearData() {
        this.jGalaxyPanel.removeAll();
        Node defaultSystem = new Node(this.program.getSettings().getLanguageSettings().getString("NoSystems", "map"));
        this.priceSystemsEventList.getReadWriteLock().writeLock().lock();
        this.priceSystemsEventList.clear();
        this.priceSystemsEventList.add(defaultSystem);
        this.priceSystemsEventList.getReadWriteLock().writeLock().unlock();
        this.jSystemList.setSelectedIndex(0);
    }

    @Override
    public void updateLanguage() {
        this.sTitle = this.program.getSettings().getLanguageSettings().getString("Title", "map");
        this.sAlt = this.program.getSettings().getLanguageSettings().getString("All", "map");
        this.jSystemList.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SelectSystemTT", "map"));
        this.jCenter.setText(this.program.getSettings().getLanguageSettings().getString("Center", "map"));
        this.jCenter.setToolTipText(this.program.getSettings().getLanguageSettings().getString("CenterTT", "map"));
        this.jSelect.setText(this.program.getSettings().getLanguageSettings().getString("Select", "map"));
        this.jSelect.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SelectTT", "map"));
        this.jNamesButton.setText(this.program.getSettings().getLanguageSettings().getString("Names", "map"));
        this.jNamesButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("NamesTT", "map"));
        this.jJumpsLinesButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("JumpLinesTT", "map"));
        this.jJumpsLinesButton.setText(this.program.getSettings().getLanguageSettings().getString("JumpLines", "map"));
        this.jJumplessSystemsButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("JumplessSystemsTT", "map"));
        this.jJumplessSystemsButton.setText(this.program.getSettings().getLanguageSettings().getString("JumplessSystems", "map"));
        this.jFactionsButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("FactionsTT", "map"));
        this.jFactionsButton.setText(this.program.getSettings().getLanguageSettings().getString("Factions", "map"));
        this.jSectorsButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SectorsTT", "map"));
        this.jSectorsButton.setText(this.program.getSettings().getLanguageSettings().getString("Sectors", "map"));
        this.jSectorBoxesButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("SectorBoxesTT", "map"));
        this.jSectorBoxesButton.setText(this.program.getSettings().getLanguageSettings().getString("SectorBoxes", "map"));
        this.jYaxisButton.setToolTipText(this.program.getSettings().getLanguageSettings().getString("YAxisTT", "map"));
        this.jYaxisButton.setText(this.program.getSettings().getLanguageSettings().getString("YAxis", "map"));
        this.jScaleList.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ZoomTT", "map"));
        this.jZoomIn.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ZoomInTT", "map"));
        this.jZoomIn.setText(this.program.getSettings().getLanguageSettings().getString("ZoomIn", "map"));
        this.jZoomOut.setToolTipText(this.program.getSettings().getLanguageSettings().getString("ZoomOutTT", "map"));
        this.jZoomOut.setText(this.program.getSettings().getLanguageSettings().getString("ZoomOut", "map"));
        this.jPath.setText(this.program.getSettings().getLanguageSettings().getString("NothingSelected", "map"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        GalaxySystem system;
        if ("VegamapScale".equals(e.getActionCommand())) {
            Object o = this.jScaleList.getSelectedItem();
            if (o instanceof ScaleItem) {
                ScaleItem scale = (ScaleItem)this.jScaleList.getSelectedItem();
                this.galaxyView.rescale(scale.getScale());
            }
            if (o instanceof String) {
                double d = Double.valueOf((String)o) / 10.0;
                this.galaxyView.rescale(d);
                this.jScaleList.setSelectedItem(new ScaleItem(d));
            }
        }
        if ("VegamapCenter".equals(e.getActionCommand())) {
            system = (GalaxySystem)this.jSystemList.getSelectedItem();
            this.galaxyView.recenter(system);
        }
        if ("VegamapSelect".equals(e.getActionCommand())) {
            system = (GalaxySystem)this.jSystemList.getSelectedItem();
            this.galaxyView.selectSystem(system);
            if (this.program.getSettings().getMapSettings().isAutoCenterEnabled()) {
                this.galaxyView.recenter(system);
            }
        }
        if (!this.jSystemList.getEditor().getEditorComponent().isFocusOwner()) {
            ScaleItem scale;
            if ("VegamapShowNames".equals(e.getActionCommand())) {
                this.jNamesButton.setSelected(!this.jNamesButton.isSelected());
                this.program.getSettings().getMapSettings().showNames(this.jNamesButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowJumpLines".equals(e.getActionCommand())) {
                this.jJumpsLinesButton.setSelected(!this.jJumpsLinesButton.isSelected());
                this.program.getSettings().getMapSettings().showJumpsLines(this.jJumpsLinesButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowJumplessSystems".equals(e.getActionCommand())) {
                this.jJumplessSystemsButton.setSelected(!this.jJumplessSystemsButton.isSelected());
                this.program.getSettings().getMapSettings().showJumplessSystems(this.jJumplessSystemsButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowFactions".equals(e.getActionCommand())) {
                this.jFactionsButton.setSelected(!this.jFactionsButton.isSelected());
                this.program.getSettings().getMapSettings().showFactions(this.jFactionsButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowSectors".equals(e.getActionCommand())) {
                this.jSectorsButton.setSelected(!this.jSectorsButton.isSelected());
                this.program.getSettings().getMapSettings().showSectors(this.jSectorsButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowSectorBoxes".equals(e.getActionCommand())) {
                this.jSectorBoxesButton.setSelected(!this.jSectorBoxesButton.isSelected());
                this.program.getSettings().getMapSettings().showSectorBoxes(this.jSectorBoxesButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapShowYAxis".equals(e.getActionCommand())) {
                this.jYaxisButton.setSelected(!this.jYaxisButton.isSelected());
                this.program.getSettings().getMapSettings().showYaxis(this.jYaxisButton.isSelected());
                this.galaxyView.repaint();
            }
            if ("VegamapMoveLeft".equals(e.getActionCommand())) {
                this.galaxyView.moveLeft();
            }
            if ("VegamapMoveRight".equals(e.getActionCommand())) {
                this.galaxyView.moveRight();
            }
            if ("VegamapMoveDown".equals(e.getActionCommand())) {
                this.galaxyView.moveDown();
            }
            if ("VegamapMoveUp".equals(e.getActionCommand())) {
                this.galaxyView.moveUp();
            }
            if ("VegamapZoomIn".equals(e.getActionCommand())) {
                scale = (ScaleItem)this.jScaleList.getSelectedItem();
                double nNumber = scale.getScale();
                nNumber *= 1.3;
                if ((nNumber = (double)Math.round(nNumber * 10.0) / 10.0) < 1.0) {
                    nNumber = 1.0;
                }
                this.jScaleList.setSelectedItem(new ScaleItem(nNumber));
            }
            if ("VegamapZoomOut".equals(e.getActionCommand())) {
                scale = (ScaleItem)this.jScaleList.getSelectedItem();
                double nNumber = scale.getScale();
                nNumber *= 0.7;
                if ((nNumber = (double)Math.round(nNumber * 10.0) / 10.0) < 1.0) {
                    nNumber = 1.0;
                }
                this.jScaleList.setSelectedItem(new ScaleItem(nNumber));
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int clicks = e.getWheelRotation();
        ScaleItem scale = (ScaleItem)this.jScaleList.getSelectedItem();
        double nNumber = scale.getScale();
        if (clicks != 0) {
            nNumber *= 1.0 - 0.3 * (double)clicks;
            if ((nNumber = (double)Math.round(nNumber * 10.0) / 10.0) < 1.0) {
                nNumber = 1.0;
            }
            this.jScaleList.setSelectedItem(new ScaleItem(nNumber));
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() instanceof JSplitPane) {
            this.resizePathPanel((JSplitPane)e.getSource());
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (e.getSource() instanceof JSplitPane) {
            this.resizePathPanel((JSplitPane)e.getSource());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (e.getSource() instanceof JSplitPane) {
            this.resizePathPanel((JSplitPane)e.getSource());
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void resizePathPanel(JSplitPane jSplitPane) {
        jSplitPane.setDividerLocation(jSplitPane.getWidth() - 255);
    }
}

