/*
 * Decompiled with CFR 0.152.
 */
package vstrade.moduls.map;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import vstrade.Program;
import vstrade.data.Node;
import vstrade.data.galaxy.GalaxySector;
import vstrade.data.galaxy.GalaxySystem;
import vstrade.data.galaxy.Point3D;
import vstrade.moduls.map.PathFinder;

public class GalaxyView
extends JPanel
implements MouseListener,
MouseWheelListener {
    private static final int STAR_RADIUS = 2;
    private static final int SECTOR_MARGIN = 1;
    private static final int MOVE_SPEED = 6;
    private Point2D center;
    private double scale;
    private double scaleFactor;
    private GalaxySystem start;
    private GalaxySystem end;
    private List<GalaxySystem> path;
    private PathFinder pathFinder;
    private BufferedImage systemDotWhite;
    private BufferedImage systemDotOrange;
    private BufferedImage systemDotRed;
    private Program program;
    private JTextComponent jPath;

    public GalaxyView(Program program, JTextComponent jPath) {
        this.program = program;
        this.jPath = jPath;
        this.center = null;
        this.start = null;
        this.end = null;
        this.path = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        this.systemDotWhite = gc.createCompatibleImage(5, 5, 1);
        Graphics graphics = this.systemDotWhite.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillOval(0, 0, 4, 4);
        graphics.drawOval(0, 0, 4, 4);
        this.systemDotOrange = gc.createCompatibleImage(5, 5, 1);
        graphics = this.systemDotOrange.getGraphics();
        graphics.setColor(Color.ORANGE);
        graphics.fillOval(0, 0, 4, 4);
        graphics.drawOval(0, 0, 4, 4);
        this.systemDotRed = gc.createCompatibleImage(5, 5, 1);
        graphics = this.systemDotRed.getGraphics();
        graphics.setColor(Color.RED);
        graphics.fillOval(0, 0, 4, 4);
        graphics.drawOval(0, 0, 4, 4);
        this.pathFinder = new PathFinder();
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.setBackground(Color.BLACK);
    }

    private void updateFactor() {
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            double viewYY;
            double h;
            double mapXX = Math.abs(this.program.getGalaxy().getMax().x) + Math.abs(this.program.getGalaxy().getMin().x);
            double mapYY = Math.abs(this.program.getGalaxy().getMax().y) + Math.abs(this.program.getGalaxy().getMin().y);
            double viewXX = this.getWidth();
            double w = viewXX / mapXX * 100.0;
            this.scaleFactor = w < (h = (viewYY = (double)this.getHeight()) / mapYY * 100.0) ? w / 2.0 : h / 2.0;
        } else {
            this.scaleFactor = 100.0;
        }
    }

    private void updateCenter() {
        if (this.center != null) {
            return;
        }
        double mapXX = this.program.getGalaxy().getMax().x + this.program.getGalaxy().getMin().x;
        double mapYY = this.program.getGalaxy().getMax().y + this.program.getGalaxy().getMin().y;
        this.center = new Point2D.Double(mapXX / 2.0, mapYY / 2.0);
    }

    private double getScale() {
        return this.scale / 100.0 * this.scaleFactor;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.updateFactor();
        this.updateCenter();
        Graphics g = graphics.create();
        if (this.program.getSettings().getMapSettings().showJumpsLines()) {
            this.paintJumps(g);
        }
        if (this.program.getSettings().getMapSettings().showSectorBoxes()) {
            this.paintSectorBoxes(g);
        }
        this.paintSystems(g);
        if (this.start != null) {
            this.paintSelected(graphics);
        }
        if (this.path != null) {
            this.paintPath(g);
        }
    }

    private void paintJumps(Graphics graphics) {
        Graphics g = graphics.create();
        g.setColor(Color.DARK_GRAY);
        Vector<Node> galaxyNodes = this.program.getGalaxy().getValues();
        for (int a = 0; a < galaxyNodes.size(); ++a) {
            GalaxySector sector = (GalaxySector)galaxyNodes.get(a);
            Vector<Node> sectorNodes = sector.getValues();
            for (int b = 0; b < sectorNodes.size(); ++b) {
                GalaxySystem system = (GalaxySystem)sectorNodes.get(b);
                Vector<Node> systemNodes = system.getValues();
                for (int c = 0; c < systemNodes.size(); ++c) {
                    GalaxySystem systemJump = (GalaxySystem)systemNodes.get(c);
                    this.paintJump(g, system, systemJump);
                }
            }
        }
    }

    private void paintJump(Graphics graphics, GalaxySystem start, GalaxySystem end) {
        Point3D tmp1 = start.getPos();
        Point2D.Double loc1 = new Point2D.Double(tmp1.getX(), tmp1.getY());
        Point p1 = this.getViewPoint(loc1);
        Point3D tmp2 = end.getPos();
        Point2D.Double loc2 = new Point2D.Double(tmp2.getX(), tmp2.getY());
        Point p2 = this.getViewPoint(loc2);
        Line2D.Double theLine = new Line2D.Double(p2.getX(), p2.getY(), p1.getX(), p1.getY());
        if (theLine.intersects(0.0, 0.0, this.getWidth(), this.getHeight())) {
            graphics.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    private void paintSectorBoxes(Graphics graphics) {
        Graphics g = graphics.create();
        g.setColor(Color.ORANGE);
        Vector<Node> galaxyNodes = this.program.getGalaxy().getValues();
        for (int a = 0; a < galaxyNodes.size(); ++a) {
            GalaxySector sector = (GalaxySector)galaxyNodes.get(a);
            Point3D min = sector.getMin();
            Point3D max = sector.getMax();
            Point2D.Double tmpMin = new Point2D.Double(min.x, min.y);
            Point2D.Double tmpMax = new Point2D.Double(max.x, max.y);
            Point p1 = this.getViewPoint(tmpMin);
            Point p2 = this.getViewPoint(tmpMax);
            int x = p1.x;
            int y = Math.min(p1.y, p2.y);
            int width = Math.abs(p1.x - p2.x);
            int height = Math.abs(p1.y - p2.y);
            g.drawRect(x - 1, y - 1, width + 2, height + 2);
            g.drawString(sector.getName(), x, y - 6);
        }
    }

    private void paintSystems(Graphics graphics) {
        Graphics g = graphics.create();
        g.setColor(Color.WHITE);
        Vector<Node> galaxyNodes = this.program.getGalaxy().getValues();
        for (int a = 0; a < galaxyNodes.size(); ++a) {
            GalaxySector sector = (GalaxySector)galaxyNodes.get(a);
            Vector<Node> sectorNodes = sector.getValues();
            for (int b = 0; b < sectorNodes.size(); ++b) {
                GalaxySystem system = (GalaxySystem)sectorNodes.get(b);
                if (system.getSize() <= 0 && !this.program.getSettings().getMapSettings().showJumplessSystems()) continue;
                this.paintSystem(g, system);
            }
        }
    }

    private void paintSystem(Graphics graphics, GalaxySystem system) {
        Point3D tmp = system.getPos();
        Point2D.Double loc = new Point2D.Double(tmp.getX(), tmp.getY());
        Point p = this.getViewPoint(loc);
        if (p.getX() <= 0.0 || p.getY() <= 0.0 || p.getX() > (double)this.getWidth() || p.getY() > (double)this.getHeight()) {
            return;
        }
        if (graphics.getColor().equals(Color.WHITE)) {
            graphics.drawImage(this.systemDotWhite, p.x - 2, p.y - 2, null);
        }
        if (graphics.getColor().equals(Color.RED)) {
            graphics.drawImage(this.systemDotRed, p.x - 2, p.y - 2, null);
        }
        if (graphics.getColor().equals(Color.ORANGE)) {
            graphics.drawImage(this.systemDotOrange, p.x - 2, p.y - 2, null);
        }
        StringBuffer name = new StringBuffer();
        if (this.program.getSettings().getMapSettings().showSectors()) {
            name.append(system.getParent().getName());
        }
        if (this.program.getSettings().getMapSettings().showNames() || this.path != null && this.path.contains(system) || this.start != null && this.path == null && this.start.equals(system) || this.start != null && this.path == null && this.start.getValues().contains(system)) {
            if (name.length() > 0) {
                name.append("/");
            }
            name.append(system.getName());
        }
        if (this.program.getSettings().getMapSettings().showFactions()) {
            if (name.length() > 0) {
                name.append("/");
            }
            name.append(system.getFaction());
        }
        if (!graphics.getColor().equals(Color.WHITE)) {
            Color tempColor = graphics.getColor();
            graphics.setColor(Color.BLACK);
            Rectangle2D huhu = graphics.getFontMetrics().getStringBounds(name.toString(), graphics);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.85f));
            graphics.fillRect(p.x + 5, p.y - 5 - (int)huhu.getHeight(), (int)huhu.getWidth() + 2, (int)huhu.getHeight() + 2);
            graphics.setColor(tempColor);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
        }
        graphics.drawString(name.toString(), p.x + 6, p.y - 6);
    }

    private void paintPath(Graphics graphics) {
        int i;
        Graphics g = graphics.create();
        g.setColor(Color.RED);
        for (i = 0; i < this.path.size() - 1; ++i) {
            this.paintJump(g, this.path.get(i), this.path.get(i + 1));
        }
        for (i = 0; i < this.path.size(); ++i) {
            this.paintSystem(g, this.path.get(i));
        }
    }

    private void paintSelected(Graphics graphics) {
        graphics.setColor(Color.ORANGE);
        if (this.start != null) {
            graphics.setColor(Color.ORANGE);
            if (this.end == null) {
                this.paintConnectingJumps(graphics, this.start);
            }
            graphics.setColor(Color.RED);
            this.paintSystem(graphics, this.start);
        }
        if (this.end != null) {
            graphics.setColor(Color.RED);
            this.paintSystem(graphics, this.end);
        }
    }

    private void paintConnectingJumps(Graphics graphics, GalaxySystem from) {
        Vector<Node> systemNodes = from.getValues();
        for (int i = 0; i < systemNodes.size(); ++i) {
            GalaxySystem to = (GalaxySystem)systemNodes.get(i);
            this.paintJump(graphics, from, to);
            this.paintSystem(graphics, to);
        }
    }

    public void recenter(GalaxySystem system) {
        this.recenter(system.getPos());
    }

    public void moveLeft() {
        if (this.program.getGalaxy().isLoaded()) {
            Point2D point = this.center;
            this.center = new Point2D.Double(point.getX() - 6.0 / this.getScale(), point.getY());
            this.repaint();
        }
    }

    public void moveRight() {
        if (this.program.getGalaxy().isLoaded()) {
            Point2D point = this.center;
            this.center = new Point2D.Double(point.getX() + 6.0 / this.getScale(), point.getY());
            this.repaint();
        }
    }

    public void moveUp() {
        if (this.program.getGalaxy().isLoaded()) {
            Point2D point = this.center;
            this.center = new Point2D.Double(point.getX(), point.getY() - 6.0 / this.getScale());
            this.repaint();
        }
    }

    public void moveDown() {
        if (this.program.getGalaxy().isLoaded()) {
            Point2D point = this.center;
            this.center = new Point2D.Double(point.getX(), point.getY() + 6.0 / this.getScale());
            this.repaint();
        }
    }

    private void recenter(Point3D center) {
        Point2D.Double loc1 = new Point2D.Double(center.getX(), center.getY());
        Point p1 = this.getViewPoint(loc1);
        this.center = this.getMapPoint(p1);
        this.repaint();
    }

    private void recenter(Point2D center) {
        this.center = center;
        this.repaint();
    }

    public void rescale(double scale) {
        this.scale = scale;
        this.repaint();
    }

    public void zoomIn() {
        this.rescale(this.scale * 1.1);
    }

    public void zoomOut() {
        this.rescale(this.scale * 0.9);
    }

    private Point2D getMapPoint(Point p) {
        Point vc = this.getViewCenter();
        Point tp = this.program.getSettings().getMapSettings().showYaxis() ? new Point(p.x - vc.x, p.y - vc.y) : new Point(p.x - vc.x, -(p.y - vc.y));
        Point2D.Double result = new Point2D.Double(this.center.getX() + (double)tp.x / this.getScale(), this.center.getY() + (double)tp.y / this.getScale());
        return result;
    }

    private Point getViewPoint(Point2D p) {
        Point shift = this.getViewCenter();
        int x = (int)Math.round((p.getX() - this.center.getX()) * this.getScale()) + shift.x;
        int y = this.program.getSettings().getMapSettings().showYaxis() ? (int)Math.round((p.getY() - this.center.getY()) * this.getScale()) + shift.y : (int)Math.round(-(p.getY() - this.center.getY()) * this.getScale()) + shift.y;
        return new Point(x, y);
    }

    private Point getViewCenter() {
        return new Point(this.getWidth() / 2, this.getHeight() / 2);
    }

    private GalaxySystem getSystem(Point2D p) {
        double dist = Double.MAX_VALUE;
        GalaxySystem result = null;
        Vector<Node> galaxyNodes = this.program.getGalaxy().getValues();
        for (int a = 0; a < galaxyNodes.size(); ++a) {
            GalaxySector sector = (GalaxySector)galaxyNodes.get(a);
            if (!(p.getX() >= sector.getMin().x) || !(p.getY() >= sector.getMin().y) || !(p.getX() <= sector.getMax().x) || !(p.getY() <= sector.getMax().y)) continue;
            Vector<Node> sectorNodes = sector.getValues();
            for (int b = 0; b < sectorNodes.size(); ++b) {
                Point3D pos;
                double tmp;
                GalaxySystem system = (GalaxySystem)sectorNodes.get(b);
                if (system.getSize() <= 0 && !this.program.getSettings().getMapSettings().showJumplessSystems() || !((tmp = (pos = system.getPos()).distance(p.getX(), p.getY(), pos.z)) < dist)) continue;
                dist = tmp;
                result = system;
            }
        }
        return result;
    }

    public void selectSystem(GalaxySystem system) {
        if (system != null) {
            if (this.end != null) {
                this.end = null;
                this.start = system;
                this.path = null;
                this.printConnectingSystems();
            } else if (this.start != null && !this.start.equals(system)) {
                this.end = system;
                this.path = this.pathFinder.getPath(this.start, this.end);
                this.printPath();
            } else {
                this.start = system;
                this.printConnectingSystems();
            }
            this.repaint();
        }
    }

    private void selectSystem(Point2D p) {
        GalaxySystem system = this.getSystem(p);
        this.selectSystem(system);
    }

    private void printPath() {
        String sPath;
        if (this.path != null) {
            sPath = this.program.getSettings().getLanguageSettings().getString("PathFound", "map") + "\r\n";
            sPath = sPath.replace("%1", String.valueOf(this.path.size()));
            for (int i = 0; i < this.path.size(); ++i) {
                sPath = sPath + "> " + this.path.get(i).getFullName() + "\r\n";
            }
        } else {
            sPath = this.program.getSettings().getLanguageSettings().getString("PathNotFound", "map") + "\r\n";
            sPath = sPath + "> " + this.start.getFullName() + "\r\n";
            sPath = sPath + this.program.getSettings().getLanguageSettings().getString("And", "map") + "\r\n";
            sPath = sPath + "> " + this.end.getFullName();
        }
        this.jPath.setText(sPath);
    }

    private void printConnectingSystems() {
        String sPath;
        Vector<Node> connectedSystems = this.start.getValues();
        if (connectedSystems.size() > 0) {
            sPath = this.program.getSettings().getLanguageSettings().getString("ConnectedTo", "map") + "\r\n";
            sPath = sPath.replace("%1", String.valueOf(connectedSystems.size()));
            for (int i = 0; i < connectedSystems.size(); ++i) {
                GalaxySystem system = (GalaxySystem)connectedSystems.get(i);
                sPath = sPath + "> " + system.getFullName() + "\r\n";
            }
        } else {
            sPath = this.program.getSettings().getLanguageSettings().getString("NotConnected", "map") + "\r\n";
        }
        this.jPath.setText(sPath);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Point2D mapP;
        Point p = e.getPoint();
        int button = e.getButton();
        if (button == 1) {
            mapP = this.getMapPoint(p);
            this.selectSystem(mapP);
        }
        if (button == 3) {
            mapP = this.getMapPoint(p);
            this.recenter(mapP);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }
}

